/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail.dkim;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.demail.DeMailAlgorithmMapper;
import de.governikus.csl.demail.DeMailParsingException;
import de.governikus.csl.demail.dkim.DKIMHeader;
import de.governikus.csl.svp.SVPFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class DeMailDKIMHeader
extends DKIMHeader {
    public static final String SUPPORTED_DKIM_VERSION = "1";
    public static final String SUPPORTED_CANONICALIZATION = "simple/simple";
    private static final String[] HEADERS_TO_BE_SIGNED = new String[]{"From", "Date", "Message-ID", "Subject", "Reply-To", "X-de-mail-confirmation-of-dispatch", "X-de-mail-confirmation-of-receipt", "X-de-mail-confirmation-of-retrieve", "X-de-mail-authoritative", "X-de-mail-private", "X-de-mail-sender", "X-de-mail-chosen-recipient", "X-de-mail-auth-mechanism", "X-de-mail-auth-level", "X-de-mail-originator-provider", "X-de-mail-message-type", "X-de-mail-version", "X-de-mail-private-id", "X-de-mail-message-id", "X-de-mail-account-holder"};
    private List<String> signedHeaderNameList = new ArrayList<String>();
    private Algorithm mappedAlgorithm;

    public DeMailDKIMHeader(String headerLine) throws IllegalArgumentException {
        super(headerLine);
        for (String header : HEADERS_TO_BE_SIGNED) {
            this.signedHeaderNameList.add(header.toLowerCase(Locale.ENGLISH));
        }
    }

    public void checkBodyHash() throws DeMailParsingException {
        if (this.getBodyHash() == null) {
            throw new DeMailParsingException(SVPFactory.createMessageCode((String)"de_mail_dkim_missing_body_hash"));
        }
    }

    public void checkCanonicalization() throws DeMailParsingException {
        if (SUPPORTED_CANONICALIZATION.equals(this.getCanonicalization())) {
            return;
        }
        throw new DeMailParsingException(SVPFactory.createMessageCode((String)"de_mail_canonicalization_not_supported", (Object[])new Object[]{DeMailDKIMHeader.doPreventNull(this.getCanonicalization())}));
    }

    public void checkSignedHeaders() throws DeMailParsingException {
        if (this.getHeaders().isEmpty()) {
            throw new DeMailParsingException(SVPFactory.createMessageCode((String)"de_mail_dkim_missing_signed_header_list"));
        }
        List<String> badHeaderNameList = this.getBadHeaderNames();
        if (!badHeaderNameList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String s : badHeaderNameList) {
                sb.append(", ");
                sb.append(s);
            }
            throw new DeMailParsingException(SVPFactory.createMessageCode((String)"de_mail_dkim_header_not_signable", (Object[])new Object[]{sb.substring(2)}));
        }
    }

    public void checkSignature() throws DeMailParsingException {
        if (this.getSignature() == null) {
            throw new DeMailParsingException(SVPFactory.createMessageCode((String)"de_mail_dkim_missing_signature"));
        }
    }

    public void checkDKIMVersion() throws DeMailParsingException {
        if (SUPPORTED_DKIM_VERSION.equals(this.getVersion())) {
            return;
        }
        throw new DeMailParsingException(SVPFactory.createMessageCode((String)"de_mail_dkim_version_not_supported", (Object[])new Object[]{DeMailDKIMHeader.doPreventNull(this.getVersion())}));
    }

    public boolean isSignableHeader(String header) {
        return this.signedHeaderNameList.contains(header.toLowerCase(Locale.ENGLISH));
    }

    public List<String> getBadHeaderNames() {
        ArrayList<String> badHeaderNameList = new ArrayList<String>();
        for (String header : this.getHeaders()) {
            if (this.isSignableHeader(header)) continue;
            badHeaderNameList.add(header);
        }
        Collections.sort(badHeaderNameList);
        return badHeaderNameList;
    }

    public synchronized Algorithm getMappedAlgorithm() throws DeMailParsingException {
        try {
            if (this.mappedAlgorithm == null) {
                this.mappedAlgorithm = DeMailAlgorithmMapper.mapAlgorithm(this.getAlgorithm());
            }
            if (this.mappedAlgorithm == null) {
                throw new IllegalArgumentException();
            }
            if (this.mappedAlgorithm instanceof SignatureAlgorithm) {
                return this.mappedAlgorithm;
            }
            if (this.mappedAlgorithm instanceof DigestAlgorithm) {
                return this.mappedAlgorithm;
            }
            throw new IllegalArgumentException();
        }
        catch (IllegalArgumentException ex) {
            throw new DeMailParsingException(SVPFactory.createMessageCode((String)"de_mail_dkim_algorithm_not_valid", (Object[])new Object[]{DeMailDKIMHeader.doPreventNull(this.getAlgorithm())}));
        }
    }

    public static String doPreventNull(String value) {
        return value != null ? value : "<NULL>";
    }
}

