/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail.dkim;

import de.governikus.csl.demail.dkim.TagValue;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DKIMHeader {
    private static final String VERSION = "v";
    private static final String ALGORITHM = "a";
    private static final String SIGNATURE = "b";
    private static final String BODY_HASH = "bh";
    private static final String CANONICALIZATION = "c";
    private static final String HEADERS = "h";
    private static final String SIGNATURE_TIME = "t";
    private static final String SIGNATURE_EXPIRATION_TIME = "x";
    private final String rawHeaderLine;
    private final String headerName;
    private final Map<String, String> nameValueMap;

    public DKIMHeader(String headerLine) throws IllegalArgumentException {
        this.rawHeaderLine = headerLine;
        this.nameValueMap = new HashMap<String, String>();
        int colon = this.rawHeaderLine.indexOf(58);
        this.headerName = this.rawHeaderLine.substring(0, colon);
        for (String headerValue : this.rawHeaderLine.substring(colon + 1).split(";")) {
            if (headerValue.trim().length() <= 0) continue;
            TagValue tagValue = new TagValue(headerValue);
            this.nameValueMap.put(tagValue.getTag(), tagValue.getValue());
        }
    }

    public String toString() {
        return this.getRawHeaderLine();
    }

    public String getRawHeaderLine() {
        return this.rawHeaderLine;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public Collection<String> getTagNames() {
        return this.nameValueMap.keySet();
    }

    public String getTagValue(String name) {
        return this.nameValueMap.get(name);
    }

    public String getAlgorithm() {
        return this.getTagValue(ALGORITHM);
    }

    public byte[] getBodyHash() {
        byte[] bhBytes = null;
        if (this.getTagValue(BODY_HASH) != null) {
            String bh = this.getTagValue(BODY_HASH).replaceAll("\\s", "");
            bhBytes = Base64.getMimeDecoder().decode(bh);
        }
        return bhBytes;
    }

    public String getCanonicalization() {
        return this.getTagValue(CANONICALIZATION);
    }

    public List<String> getHeaders() {
        ArrayList<String> headerList = new ArrayList<String>();
        String headers = this.getTagValue(HEADERS);
        if (headers != null) {
            for (String header : headers.split(":")) {
                headerList.add(header.trim());
            }
        }
        return headerList;
    }

    public byte[] getSignatureBytes() {
        String s = this.getSignature();
        if (s == null) {
            return null;
        }
        return Base64.getMimeDecoder().decode(s);
    }

    public String getSignature() {
        String signature = this.getTagValue(SIGNATURE);
        if (signature != null) {
            signature = signature.replaceAll("\\s", "");
        }
        return signature;
    }

    public String getVersion() {
        return this.getTagValue(VERSION);
    }

    public Date getSigningTime() {
        try {
            return new Date(Long.parseLong(this.getTagValue(SIGNATURE_TIME)) * 1000L);
        }
        catch (NullPointerException | NumberFormatException ex) {
            return null;
        }
    }

    public Date getSignatureExpirationTime() {
        try {
            return new Date(Long.parseLong(this.getTagValue(SIGNATURE_EXPIRATION_TIME)) * 1000L);
        }
        catch (NullPointerException | NumberFormatException ex) {
            return null;
        }
    }
}

