/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail.criteria;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.demail.DeMailAlgorithmMapper;
import de.governikus.csl.demail.DeMailParsingException;
import de.governikus.csl.demail.DeMailSignature;
import de.governikus.csl.demail.dkim.DeMailDKIMHeader;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.DeMailMimeMessageVerificationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import java.util.ArrayList;

public class DKIMSignatureStructureCheck
extends AbstractValidationCriterion<DeMailSignature, DeMailMimeMessageVerificationResult, SignatureValidationContext> {
    public void verify(DeMailSignature signature, DeMailMimeMessageVerificationResult result, SignatureValidationContext context) {
        ArrayList<ValidationResult> parseErrorList = new ArrayList<ValidationResult>();
        try {
            signature.getDeMailMimeMessage().checkDeMailVersion();
        }
        catch (DeMailParsingException ex) {
            parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)ex.getMessageCode()));
        }
        DeMailDKIMHeader dkimHeader = signature.getDeMailMimeMessage().getDeMailDKIMHeader();
        try {
            dkimHeader.checkCanonicalization();
        }
        catch (DeMailParsingException ex) {
            parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)ex.getMessageCode()));
        }
        try {
            dkimHeader.checkDKIMVersion();
        }
        catch (DeMailParsingException ex) {
            parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)ex.getMessageCode()));
        }
        try {
            Algorithm algorithm = DeMailAlgorithmMapper.mapAlgorithm(dkimHeader.getAlgorithm());
            if (algorithm == null) {
                throw new IllegalArgumentException();
            }
            boolean isSignatureAlgorithm = algorithm instanceof SignatureAlgorithm;
            if (isSignatureAlgorithm) {
                try {
                    dkimHeader.checkSignature();
                }
                catch (DeMailParsingException ex) {
                    parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)ex.getMessageCode()));
                }
            }
        }
        catch (IllegalArgumentException ex) {
            ValidationMessageCode vmCode = SVPFactory.createMessageCode((String)"de_mail_dkim_algorithm_not_valid", (Object[])new Object[]{DeMailDKIMHeader.doPreventNull(dkimHeader.getAlgorithm())});
            parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)vmCode));
        }
        try {
            dkimHeader.checkBodyHash();
        }
        catch (DeMailParsingException ex) {
            parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)ex.getMessageCode()));
        }
        try {
            dkimHeader.checkSignedHeaders();
        }
        catch (DeMailParsingException ex) {
            parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)ex.getMessageCode()));
        }
        if (!parseErrorList.isEmpty()) {
            ValidationResult validationResult = (ValidationResult)parseErrorList.get(0);
            for (ValidationResult tempResult : parseErrorList) {
                if (tempResult.getMajor().compareTo((Enum)validationResult.getMajor()) > 0) {
                    validationResult.setMajor(tempResult.getMajor());
                    validationResult.setMinor(tempResult.getMinor());
                }
                validationResult.getMessages().addAll(tempResult.getMessages());
            }
            signature.setParseError((de.governikus.csl.uom.validate.commons.ValidationResult)validationResult);
            return;
        }
        signature.setParseError((de.governikus.csl.uom.validate.commons.ValidationResult)SVPFactory.createResultOk());
    }
}

