/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail.criteria;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.demail.DeMailDocumentValidationResult;
import de.governikus.csl.demail.DeMailMimeDocument;
import de.governikus.csl.demail.DeMailMimeMessage;
import de.governikus.csl.demail.DeMailParsingException;
import de.governikus.csl.demail.dkim.DeMailDKIMHeader;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.criteria.AbstractObjectValidationCriterion;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Arrays;

public class CheckHeaderHash
extends AbstractObjectValidationCriterion<DeMailMimeDocument, DeMailDocumentValidationResult> {
    public void validate(DeMailMimeDocument document, DeMailDocumentValidationResult result, DocumentValidationContext documentValidationContext) {
        DeMailDKIMHeader deMailDKIMHeader;
        ArrayList<ValidationResult> parseErrorList;
        block18: {
            parseErrorList = new ArrayList<ValidationResult>();
            DeMailMimeMessage deMailMimeMessage = document.getDeMailMimeMessage();
            deMailDKIMHeader = deMailMimeMessage.getDeMailDKIMHeader();
            try {
                Algorithm algorithm = deMailDKIMHeader.getMappedAlgorithm();
                if (!(algorithm instanceof DigestAlgorithm)) break block18;
                DigestAlgorithm digestAlgorithm = (DigestAlgorithm)algorithm;
                try {
                    byte[] signedHeaderData = deMailMimeMessage.getDKIMSignedHeaderData();
                    MessageDigest messageDigestInstance = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm.getJCAName());
                    byte[] digest = messageDigestInstance.digest(signedHeaderData);
                    if (!Arrays.equals(deMailDKIMHeader.getSignatureBytes(), digest)) {
                        parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.HASH_FAILURE));
                    }
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                    parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"signature_hash_algorithm_missing"}));
                }
            }
            catch (DeMailParsingException ex) {
                ValidationMessageCode vmCode = SVPFactory.createMessageCode((String)"de_mail_dkim_algorithm_not_valid", (Object[])new Object[]{DeMailDKIMHeader.doPreventNull(deMailDKIMHeader.getAlgorithm())});
                parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)vmCode));
            }
        }
        try {
            document.getDeMailMimeMessage().checkDeMailVersion();
        }
        catch (DeMailParsingException ex) {
            parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)ex.getMessageCode()));
        }
        try {
            deMailDKIMHeader.checkCanonicalization();
        }
        catch (DeMailParsingException ex) {
            parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)ex.getMessageCode()));
        }
        try {
            deMailDKIMHeader.checkDKIMVersion();
        }
        catch (DeMailParsingException ex) {
            parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)ex.getMessageCode()));
        }
        try {
            deMailDKIMHeader.checkBodyHash();
        }
        catch (DeMailParsingException ex) {
            parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)ex.getMessageCode()));
        }
        try {
            deMailDKIMHeader.checkSignedHeaders();
        }
        catch (DeMailParsingException ex) {
            parseErrorList.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)ex.getMessageCode()));
        }
        if (!parseErrorList.isEmpty()) {
            ValidationResult validationResult = (ValidationResult)parseErrorList.get(0);
            for (ValidationResult tempResult : parseErrorList) {
                if (tempResult.getMajor().compareTo((Enum)validationResult.getMajor()) > 0) {
                    validationResult.setMajor(tempResult.getMajor());
                    validationResult.setMinor(tempResult.getMinor());
                }
                validationResult.getMessages().addAll(tempResult.getMessages());
            }
            result.setMessageHeaderDigestCheck(validationResult);
            return;
        }
        result.setMessageHeaderDigestCheck(SVPFactory.createResultOk());
    }
}

