/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail.criteria;

import de.governikus.csl.demail.DeMailMimeDocument;
import de.governikus.csl.demail.acknowledge.AcknowledgeMessage;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.AcknowledgeMessageValidationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.criteria.AbstractObjectValidationCriterion;
import java.security.MessageDigest;

public class CheckDeMailContent
extends AbstractObjectValidationCriterion<AcknowledgeMessage, AcknowledgeMessageValidationResult> {
    public void validate(AcknowledgeMessage document, AcknowledgeMessageValidationResult result, DocumentValidationContext documentValidationContext) {
        DeMailMimeDocument confirmedMail = document.getConfirmedMail();
        if (confirmedMail != null) {
            byte[] bodyHash = document.getDeMailBodyHash();
            if (!(bodyHash != null && bodyHash.length != 0 || document.isUsualDefaultNamespace())) {
                ValidationMessageCode vmCode = SVPFactory.createMessageCode((String)"de_mail_acknowledged_message_unusual_default_namespace");
                result.setContentMessageHashCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)vmCode));
            } else {
                byte[] bodyHash2 = confirmedMail.getDeMailMimeMessage().getDeMailDKIMHeader().getBodyHash();
                if (MessageDigest.isEqual(bodyHash, bodyHash2)) {
                    result.setContentMessageHashCheck(SVPFactory.createResultOk());
                } else {
                    result.setContentMessageHashCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.HASH_FAILURE));
                }
            }
            String originalId = document.getDeMailMessageID();
            String confirmedId = confirmedMail.getDeMailMimeMessage().getDeMailMessageID();
            if (originalId == null || "".equals(originalId.trim())) {
                ValidationMessageCode vmCode = SVPFactory.createMessageCode((String)"de_mail_missing_optional_private_id");
                result.setContentMessageIDCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, null, (ValidationMessageCode)vmCode));
            } else if (originalId.equals(confirmedId)) {
                result.setContentMessageIDCheck(SVPFactory.createResultOk());
            } else {
                result.setContentMessageIDCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)null));
            }
        } else {
            result.setContentMessageHashCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, null, (String[])new String[]{"de_mail_acknowledged_message_missing"}));
            result.setContentMessageIDCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, null, (String[])new String[]{"de_mail_acknowledged_message_missing"}));
        }
    }
}

