/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail.criteria;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.demail.DeMailDocumentValidationResult;
import de.governikus.csl.demail.DeMailMimeDocument;
import de.governikus.csl.demail.DeMailMimeMessage;
import de.governikus.csl.demail.DeMailParsingException;
import de.governikus.csl.demail.dkim.DeMailDKIMHeader;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.criteria.AbstractObjectValidationCriterion;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class CheckBodyHash
extends AbstractObjectValidationCriterion<DeMailMimeDocument, DeMailDocumentValidationResult> {
    public void validate(DeMailMimeDocument document, DeMailDocumentValidationResult result, DocumentValidationContext documentValidationContext) {
        block5: {
            DeMailMimeMessage deMailMimeMessage = document.getDeMailMimeMessage();
            DeMailDKIMHeader deMailDKIMHeader = deMailMimeMessage.getDeMailDKIMHeader();
            try {
                Algorithm algorithm = deMailDKIMHeader.getMappedAlgorithm();
                if (!(algorithm instanceof DigestAlgorithm)) break block5;
                DigestAlgorithm digestAlgorithm = (DigestAlgorithm)algorithm;
                byte[] bodyHash = deMailDKIMHeader.getBodyHash();
                try {
                    byte[] contentData = deMailMimeMessage.getNormalizedBodyData();
                    MessageDigest messageDigestInstance = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm.getJCAName());
                    byte[] digest = messageDigestInstance.digest(contentData);
                    if (MessageDigest.isEqual(bodyHash, digest)) {
                        result.setMessageBodyDigestCheck(SVPFactory.createResultOk());
                        break block5;
                    }
                    result.setMessageBodyDigestCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.HASH_FAILURE));
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                    result.setMessageBodyDigestCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"signature_hash_algorithm_missing"}));
                }
            }
            catch (DeMailParsingException ex) {
                ValidationMessageCode vmCode = SVPFactory.createMessageCode((String)"de_mail_dkim_algorithm_not_valid", (Object[])new Object[]{DeMailDKIMHeader.doPreventNull(deMailDKIMHeader.getAlgorithm())});
                result.setMessageBodyDigestCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)vmCode));
            }
        }
    }
}

