/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail.confirmation;

import de.governikus.csl.demail.DeMailMimeMessageSignatureDataExtractor;
import de.governikus.csl.demail.DeMailMimePlugin;
import de.governikus.csl.demail.DeMailSignature;
import de.governikus.csl.demail.acknowledge.AcknowledgeMessage;
import de.governikus.csl.demail.acknowledge.AcknowledgeMessagePlugin;
import de.governikus.csl.demail.confirmation.DeMailConfirmationDataExtractor;
import de.governikus.csl.demail.confirmation.DeMailConfirmationDocument;
import de.governikus.csl.demail.confirmation.DeMailConfirmationParser;
import de.governikus.csl.demail.criteria.CheckBodyHash;
import de.governikus.csl.demail.criteria.CheckHeaderHash;
import de.governikus.csl.demail.criteria.DKIMSignatureStructureCheck;
import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.DeMailConfirmationValidationResult;
import de.governikus.csl.validate.svp.DeMailMimeMessageVerificationResult;
import de.governikus.csl.validation.AbstractContainerDocumentPlugin;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.ObjectValidationCriterion;
import de.governikus.csl.validation.ObjectValidator;
import de.governikus.csl.validation.SignatureValidator;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.xades.XAdESPlugin;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.MessagingException;

@PluginType(id=Plugin.PluginID.VALIDATE_DEMAIL, type=ValidatePlugin.class)
public class DeMailConfirmationPlugin
extends AbstractContainerDocumentPlugin<DeMailConfirmationDocument, DeMailSignature, DeMailConfirmationValidationResult, DeMailMimeMessageVerificationResult, SignatureValidationContext> {
    private DeMailMimePlugin mimePlugin;
    private AcknowledgeMessagePlugin acknowledgeMessagePlugin;

    public DeMailConfirmationPlugin() {
        super(DeMailSignature.class, SignatureValidationContext.class);
    }

    public DeMailConfirmationPlugin(XAdESPlugin xadesPlugin, DeMailMimePlugin mimePlugin) {
        super(DeMailSignature.class, SignatureValidationContext.class);
        this.mimePlugin = mimePlugin;
        this.acknowledgeMessagePlugin = new AcknowledgeMessagePlugin(mimePlugin, xadesPlugin);
        this.acknowledgeMessagePlugin.setDocumentValidationCriteria(AcknowledgeMessagePlugin.getAllKnownDocumentValidationCriteria());
    }

    public DeMailConfirmationDocument parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        DeMailConfirmationDocument document;
        try {
            DeMailConfirmationParser parser = new DeMailConfirmationParser(this.configuration.getAlgorithmManager());
            document = parser.loadDocument(doc);
        }
        catch (IOException | IllegalArgumentException | IndexOutOfBoundsException | NoSuchProviderException | CertificateException | MessagingException e) {
            throw new ValidatePluginException((ValidatePlugin)this, "Can't parse document", e);
        }
        return document;
    }

    protected DeMailConfirmationValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        DeMailConfirmationValidationResult res = new DeMailConfirmationValidationResult();
        res.setObjectTypeID(this.getID());
        return res;
    }

    protected DeMailMimeMessageVerificationResult createSignatureValidationResultStructure() {
        return null;
    }

    public SignatureValidationContext createContext(DeMailSignature signature, ValidationPolicyType policy) {
        return new SignatureValidationContext(policy);
    }

    public SignatureValidator<?, ? extends DeMailMimeMessageVerificationResult, ? extends SignatureValidationContext> createSignatureValidator(DeMailSignature t, Date validationDate, ValidationPolicyType policy, DocumentValidationContext documentValidationContext) {
        if (t instanceof DeMailSignature) {
            DeMailSignature dmm = t;
            return this.mimePlugin.createSignatureValidator((Signature)dmm, validationDate, policy, documentValidationContext);
        }
        return null;
    }

    public ObjectValidator getDocumentValidatorForContainedDocument(ObjectToValidate<?> content, IncludedFileValidator requestProcessor) {
        if (content instanceof AcknowledgeMessage) {
            AcknowledgeMessage ackMsg = (AcknowledgeMessage)content;
            return this.acknowledgeMessagePlugin.getDocumentValidator(ackMsg, requestProcessor);
        }
        return null;
    }

    public void configure(Configuration config) {
        super.configure(config);
        this.acknowledgeMessagePlugin.configure(config);
    }

    public synchronized void initialize(InstanceProvider instanceProvider) throws Exception {
        super.initialize(instanceProvider);
        if (instanceProvider != null) {
            this.mimePlugin = (DeMailMimePlugin)instanceProvider.getPlugin(Plugin.PluginID.VALIDATE_DEMAIL_MIME, DeMailMimePlugin.class);
            XAdESPlugin xadesPlugin = (XAdESPlugin)instanceProvider.getPlugin(Plugin.PluginID.VALIDATE_XADES, XAdESPlugin.class);
            this.acknowledgeMessagePlugin = new AcknowledgeMessagePlugin(this.mimePlugin, xadesPlugin);
            this.acknowledgeMessagePlugin.setDocumentValidationCriteria(AcknowledgeMessagePlugin.getAllKnownDocumentValidationCriteria());
        }
    }

    public DataExtractor<? super DeMailSignature, ? super DeMailMimeMessageVerificationResult> getSignatureDataExtractor() {
        return new DeMailMimeMessageSignatureDataExtractor();
    }

    public DataExtractor<? super DeMailConfirmationDocument, ? super DeMailConfirmationValidationResult> getDocumentDataExtractor() {
        return new DeMailConfirmationDataExtractor();
    }

    public static List<ObjectValidationCriterion<? super DeMailConfirmationDocument, ? super DeMailConfirmationValidationResult>> getAllKnownDocumentValidationCriteria() {
        ArrayList<ObjectValidationCriterion<? super DeMailConfirmationDocument, ? super DeMailConfirmationValidationResult>> criterionList = new ArrayList<ObjectValidationCriterion<? super DeMailConfirmationDocument, ? super DeMailConfirmationValidationResult>>();
        criterionList.add((ObjectValidationCriterion<? super DeMailConfirmationDocument, ? super DeMailConfirmationValidationResult>)new CheckBodyHash());
        criterionList.add((ObjectValidationCriterion<? super DeMailConfirmationDocument, ? super DeMailConfirmationValidationResult>)new CheckHeaderHash());
        return criterionList;
    }

    public static List<ValidationCriterion<? super DeMailSignature, ? super DeMailMimeMessageVerificationResult, ? super SignatureValidationContext>> getAllKnownSignatureValidationCriteria() {
        ArrayList<ValidationCriterion<? super DeMailSignature, ? super DeMailMimeMessageVerificationResult, ? super SignatureValidationContext>> criterionList = new ArrayList<ValidationCriterion<? super DeMailSignature, ? super DeMailMimeMessageVerificationResult, ? super SignatureValidationContext>>();
        criterionList.add((ValidationCriterion<? super DeMailSignature, ? super DeMailMimeMessageVerificationResult, ? super SignatureValidationContext>)new DKIMSignatureStructureCheck());
        return criterionList;
    }
}

