/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail.confirmation;

import de.governikus.csl.demail.DeMailMimeDocument;
import de.governikus.csl.demail.DeMailMimeMessage;
import de.governikus.csl.demail.DeMailMimeParser;
import de.governikus.csl.demail.DeMailParserBase;
import de.governikus.csl.demail.MimeBodypartExtractor;
import de.governikus.csl.demail.acknowledge.AcknowledgeMessage;
import de.governikus.csl.demail.confirmation.DeMailConfirmationDocument;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.xades.DocumentParser;
import de.governikus.csl.xades.XAdESDocument;
import de.governikus.csl.xades.XAdESParser2;
import de.governikus.csl.xades.XAdESSignature;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.List;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class DeMailConfirmationParser
extends DeMailParserBase<DeMailConfirmationDocument> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeMailConfirmationParser.class);
    private AlgorithmManager algorithmManager;

    public DeMailConfirmationParser(AlgorithmManager algorithmManager) {
        this.algorithmManager = algorithmManager;
    }

    public DeMailConfirmationDocument loadDocument(SignedData sda) throws IOException, MessagingException, CertificateException, NoSuchProviderException {
        DeMailConfirmationDocument result = new DeMailConfirmationDocument();
        result.setName(sda.getSignature().getName());
        try (InputStream is = sda.getSignature().getInputStream();){
            this.parse(is, sda, result);
        }
        return result;
    }

    private void parse(InputStream is, SignedData sda, DeMailConfirmationDocument result) throws MessagingException, IOException, CertificateException, NoSuchProviderException {
        DeMailMimeMessage deMailMimeMessage = new DeMailMimeMessage();
        deMailMimeMessage.parseAsDeMail(is, true);
        this.parseDeMailSignature(deMailMimeMessage, result);
        if (result.getSignatures() == null || result.getSignatures().isEmpty()) {
            return;
        }
        AcknowledgeMessage ackMsg = null;
        try {
            MimeBodypartExtractor bodyExtractor = new MimeBodypartExtractor(deMailMimeMessage.getMimeMessage());
            org.w3c.dom.Document body = bodyExtractor.getFirstTextXmlBodyPart();
            XAdESParser2 parser = new XAdESParser2(this.algorithmManager);
            ackMsg = new AcknowledgeMessage();
            DocumentParser.markIds((Node)body);
            parser.loadDocument(body, (XAdESDocument)ackMsg, null);
            Date signingTime = ackMsg.getTime();
            List signatures = ackMsg.getSignatures();
            if (signatures != null) {
                for (XAdESSignature so : signatures) {
                    if (!ackMsg.isUsualDefaultNamespace()) {
                        ValidationMessageCode vmCode = SVPFactory.createMessageCode((String)"de_mail_acknowledged_message_unusual_default_namespace");
                        so.setParseError((ValidationResult)SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)vmCode));
                    }
                    if (signingTime != null) {
                        if (so.getSigningTime() != null) continue;
                        so.setSigningTime(SVPFactory.createTypedDate((Date)signingTime, (DateType)DateType.CLAIMED_SIGNING_TIME));
                        continue;
                    }
                    if (so.getSigningTime() != null) continue;
                    so.setParseError((ValidationResult)SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE));
                }
            }
            ackMsg.setName("Acknowledge message");
            result.setAcknowledgeMessage(ackMsg);
        }
        catch (Exception e) {
            LOGGER.debug("Error while parsing document.", (Throwable)e);
        }
        List contents = sda.getContents();
        if (contents != null && !contents.isEmpty()) {
            final Document contentDoc = (Document)contents.get(0);
            DeMailMimeParser mimeParser = new DeMailMimeParser();
            DeMailMimeDocument confirmedMailDocument = mimeParser.loadDocument(new SignedData(){

                public Document getSignature() {
                    return contentDoc;
                }

                public List<? extends Document> getContents() {
                    return null;
                }

                public List<byte[]> getHashValues() {
                    return null;
                }
            });
            if (ackMsg != null && confirmedMailDocument != null) {
                ackMsg.setConfirmedMail(confirmedMailDocument);
            }
        }
    }
}

