/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail.confirmation;

import de.governikus.csl.demail.DeMailMimeMessage;
import de.governikus.csl.demail.DispatchOption;
import de.governikus.csl.demail.confirmation.DeMailConfirmationDocument;
import de.governikus.csl.validate.svp.DeMailConfirmationValidationResult;
import de.governikus.csl.validate.svp.DeMailMessageHeaderData;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import java.util.List;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeMailConfirmationDataExtractor
implements DataExtractor<DeMailConfirmationDocument, DeMailConfirmationValidationResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeMailConfirmationDataExtractor.class);

    public void extractData(DeMailConfirmationDocument source, DeMailConfirmationValidationResult destination) {
        destination.setObjectName(source.getName());
        DeMailMimeMessage deMailMimeMessage = source.getDeMailMimeMessage();
        if (deMailMimeMessage != null) {
            DeMailMessageHeaderData deMailMessageHeaderData = new ObjectFactory().createDeMailMessageHeaderData();
            destination.setDeMailMessageHeaderData(deMailMessageHeaderData);
            deMailMessageHeaderData.setDeMailMessageType(deMailMimeMessage.getDeMailMessageType());
            try {
                deMailMessageHeaderData.setSubject(deMailMimeMessage.getSubject());
            }
            catch (MessagingException e) {
                LOGGER.info("Can't get Subject from DeMail", (Throwable)e);
            }
            deMailMessageHeaderData.setDeMailAccountHolder(deMailMimeMessage.getDeMailAccountHolder());
            deMailMessageHeaderData.setFromString(deMailMimeMessage.getFromString());
            deMailMessageHeaderData.setChosenRecipient(deMailMimeMessage.getChosenRecipient());
            deMailMessageHeaderData.setDate(deMailMimeMessage.getDate());
            List<DispatchOption> dispatchOptions = deMailMimeMessage.getDispatchOptions();
            if (dispatchOptions != null) {
                deMailMessageHeaderData.getDispatchOptions().addAll(dispatchOptions);
            }
            deMailMessageHeaderData.setAuthenticationLevel(deMailMimeMessage.getAuthenticationLevel());
            deMailMessageHeaderData.setAuthenticationMechanism(deMailMimeMessage.getAuthenticationMechanism());
            deMailMessageHeaderData.setPrivateID(deMailMimeMessage.getPrivateID());
            deMailMessageHeaderData.setDeMailMessageID(deMailMimeMessage.getDeMailMessageID());
            deMailMessageHeaderData.setOriginatorProvider(deMailMimeMessage.getOriginatorProvider());
            deMailMessageHeaderData.setDeMailVersion(deMailMimeMessage.getDeMailVersion());
            deMailMessageHeaderData.setDeMailNotificationType(deMailMimeMessage.getDeMailNotificationType());
        }
    }
}

