/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail.acknowledge;

import de.governikus.csl.demail.DeMailMimeDocument;
import de.governikus.csl.demail.DeMailMimePlugin;
import de.governikus.csl.demail.acknowledge.AcknowledgeMessage;
import de.governikus.csl.demail.criteria.CheckDeMailContent;
import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.AcknowledgeMessageValidationResult;
import de.governikus.csl.validate.svp.XAdESSignatureValidationResult;
import de.governikus.csl.validation.AbstractContainerDocumentPlugin;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.ObjectValidationCriterion;
import de.governikus.csl.validation.ObjectValidator;
import de.governikus.csl.validation.SignatureValidator;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.dataExtractor.DefaultContentSignatureDataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.xades.XAdESPlugin;
import de.governikus.csl.xades.XAdESSignature;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@PluginType(id=Plugin.PluginID.VALIDATE_DEMAIL_ACKNOWLEDGE, type=ValidatePlugin.class)
public class AcknowledgeMessagePlugin
extends AbstractContainerDocumentPlugin<AcknowledgeMessage, XAdESSignature, AcknowledgeMessageValidationResult, XAdESSignatureValidationResult, SignatureValidationContext> {
    private XAdESPlugin xadesPlugin;
    private DeMailMimePlugin mimePlugin;

    public AcknowledgeMessagePlugin() {
        super(XAdESSignature.class, SignatureValidationContext.class);
    }

    public AcknowledgeMessagePlugin(DeMailMimePlugin mimePlugin, XAdESPlugin xadesPlugin) {
        super(XAdESSignature.class, SignatureValidationContext.class);
        this.mimePlugin = mimePlugin;
        this.xadesPlugin = xadesPlugin;
    }

    public AcknowledgeMessage parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        return null;
    }

    public SignatureValidator<?, ? extends XAdESSignatureValidationResult, ?> createSignatureValidator(XAdESSignature signature, Date validationDate, ValidationPolicyType policy, DocumentValidationContext documentContext) {
        return this.xadesPlugin.createSignatureValidator((Signature)signature, validationDate, policy, documentContext);
    }

    protected AcknowledgeMessageValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        AcknowledgeMessageValidationResult result = new AcknowledgeMessageValidationResult();
        result.setObjectTypeID(Plugin.PluginID.VALIDATE_DEMAIL_ACKNOWLEDGE.getID());
        return result;
    }

    protected XAdESSignatureValidationResult createSignatureValidationResultStructure() {
        return new XAdESSignatureValidationResult();
    }

    public SignatureValidationContext createContext(XAdESSignature signature, ValidationPolicyType policy) {
        return new SignatureValidationContext(policy);
    }

    public ObjectValidator getDocumentValidatorForContainedDocument(ObjectToValidate<?> content, IncludedFileValidator requestProcessor) {
        if (content instanceof DeMailMimeDocument) {
            return this.mimePlugin.getDocumentValidator((ObjectToValidate)((DeMailMimeDocument)content), requestProcessor);
        }
        return null;
    }

    public synchronized void initialize(InstanceProvider instanceProvider) throws Exception {
        super.initialize(instanceProvider);
        if (instanceProvider != null) {
            this.mimePlugin = (DeMailMimePlugin)instanceProvider.getPlugin(Plugin.PluginID.VALIDATE_DEMAIL_MIME, DeMailMimePlugin.class);
            this.xadesPlugin = (XAdESPlugin)instanceProvider.getPlugin(Plugin.PluginID.VALIDATE_XADES, XAdESPlugin.class);
        }
    }

    public DataExtractor<? super XAdESSignature, ? super XAdESSignatureValidationResult> getSignatureDataExtractor() {
        return new DefaultContentSignatureDataExtractor();
    }

    public static List<ObjectValidationCriterion<? super AcknowledgeMessage, ? super AcknowledgeMessageValidationResult>> getAllKnownDocumentValidationCriteria() {
        ArrayList<ObjectValidationCriterion<? super AcknowledgeMessage, ? super AcknowledgeMessageValidationResult>> criterionList = new ArrayList<ObjectValidationCriterion<? super AcknowledgeMessage, ? super AcknowledgeMessageValidationResult>>();
        criterionList.add((ObjectValidationCriterion<? super AcknowledgeMessage, ? super AcknowledgeMessageValidationResult>)new CheckDeMailContent());
        return criterionList;
    }
}

