/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail.acknowledge;

import de.governikus.csl.demail.DeMailMimeDocument;
import de.governikus.csl.demail.dkim.DeMailDKIMHeader;
import de.governikus.csl.uom.validate.commons.ContainerObjectToValidate;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.xades.XAdESDocument;
import de.governikus.csl.xades.XAdESSignature;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;

public class AcknowledgeMessage
extends XAdESDocument
implements ContainerObjectToValidate<XAdESSignature> {
    private static final XPathExpression XPATH_X_DE_MAIL_MSG_ID;
    private static final XPathExpression XPATH_TIME;
    private static final XPathExpression XPATH_HASH;
    private static final XPathExpression XPATH_NAMESPACE;
    private static final String DEFAULT_NAMESPACE = "urn:de-mail";
    private static final String TELEKOM_NAMESPACE = "http://telekom.com/demail";
    private String deMailMessageID;
    private byte[] bodyHash;
    private Date date;
    private String namespace;
    private DeMailMimeDocument confirmedMail;

    public String getDeMailMessageID() {
        if (this.deMailMessageID == null) {
            this.deMailMessageID = this.evaluateAsString(XPATH_X_DE_MAIL_MSG_ID);
        }
        return this.deMailMessageID;
    }

    public byte[] getDeMailBodyHash() {
        block3: {
            if (this.bodyHash == null) {
                String content = this.evaluateAsString(XPATH_HASH);
                try {
                    this.bodyHash = Base64.getMimeDecoder().decode(content);
                }
                catch (IllegalArgumentException ex) {
                    DeMailDKIMHeader dkimHeader = new DeMailDKIMHeader("X-De-Mail-Integrity: " + content);
                    this.bodyHash = dkimHeader.getBodyHash();
                    if (this.bodyHash != null) break block3;
                    throw new IllegalArgumentException("Cannot process acknowledge message hash field as DKIM signature header!");
                }
            }
        }
        return this.bodyHash;
    }

    public String getDefaultNamespace() {
        if (this.namespace == null) {
            try {
                Node rootNode = (Node)XPATH_NAMESPACE.evaluate(this.document, XPathConstants.NODE);
                if (rootNode != null) {
                    this.namespace = rootNode.getNamespaceURI();
                }
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return this.namespace;
    }

    public boolean isUsualDefaultNamespace() {
        String uri = this.getDefaultNamespace();
        if (uri != null) {
            return DEFAULT_NAMESPACE.equals(uri) || TELEKOM_NAMESPACE.equals(uri);
        }
        return false;
    }

    public Date getTime() {
        if (this.date == null) {
            this.date = this.parseAsDateTime(this.evaluateAsString(XPATH_TIME));
        }
        if (this.date == null) {
            this.date = this.parseAsInvalidMentanaCustomFormat(this.evaluateAsString(XPATH_TIME));
        }
        return this.date;
    }

    private Date parseAsDateTime(String s) {
        try {
            return DatatypeConverter.parseDateTime((String)s).getTime();
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    private Date parseAsInvalidMentanaCustomFormat(String s) {
        SimpleDateFormat df = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:s' 'Z", Locale.US);
        try {
            return df.parse(s);
        }
        catch (ParseException ignore) {
            return null;
        }
    }

    protected String evaluateAsString(XPathExpression xPathExpression) {
        try {
            String string = (String)xPathExpression.evaluate(this.document, XPathConstants.STRING);
            if (string != null) {
                return string.trim();
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        throw new IllegalArgumentException("XPath expression evaluated to null");
    }

    public List<? extends ObjectToValidate<?>> getContainedObjectsToValidate() {
        if (this.confirmedMail != null) {
            return Collections.singletonList(this.confirmedMail);
        }
        return null;
    }

    public DeMailMimeDocument getConfirmedMail() {
        return this.confirmedMail;
    }

    public void setConfirmedMail(DeMailMimeDocument confirmedMail) {
        this.confirmedMail = confirmedMail;
    }

    static {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            XPATH_NAMESPACE = xPath.compile("/*[name()='Acknowledge-Message']");
            XPATH_TIME = xPath.compile("/*[name()='Acknowledge-Message']/*[name()='Time']");
            XPATH_HASH = xPath.compile("/*[name()='Acknowledge-Message']/*[name()='Hash']");
            XPATH_X_DE_MAIL_MSG_ID = xPath.compile("/*[name()='Acknowledge-Message']/*[name()='Metadata']/*[name()='Metadate'][translate(*[name()='Name'],'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=\"x-de-mail-message-id\"]/*[name()='Value']");
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("XPath expression does not compile", e);
        }
    }
}

