/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail;

import de.bos_bremen.ci.StreamUtil;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class MimeBodypartExtractor {
    private final MimeMultipart multiMimepart;

    public MimeBodypartExtractor(MimeMessage msg) throws MessagingException, IOException {
        if (!(msg.getContent() instanceof MimeMultipart)) {
            throw new MessagingException("Invalid MIME message, confirmation messages must be of type MimeMultipart !");
        }
        this.multiMimepart = (MimeMultipart)msg.getContent();
    }

    public Document getFirstTextXmlBodyPart() throws MessagingException, IOException {
        DataHandler dh = this.getFirstBodyPartForContentType("text/xml");
        InputStream is = dh.getInputStream();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
            dbf.setNamespaceAware(true);
            Document document = dbf.newDocumentBuilder().parse(is);
            return document;
        }
        catch (Exception e) {
            throw new MessagingException("Cannot parse DeMail body as XML", e);
        }
        finally {
            StreamUtil.close((Closeable)is);
        }
    }

    public DataHandler getFirstBodyPartForContentType(String type) throws MessagingException, IOException {
        for (int j = 0; j < this.multiMimepart.getCount(); ++j) {
            BodyPart bodyPart = this.multiMimepart.getBodyPart(j);
            if (!bodyPart.isMimeType(type)) continue;
            return bodyPart.getDataHandler();
        }
        throw new MessagingException("No body part found for content type " + type);
    }
}

