/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.core.impl.BaseSignedContentPart;
import de.governikus.csl.demail.DeMailMimeDocument;
import de.governikus.csl.demail.DeMailMimeMessage;
import de.governikus.csl.demail.DeMailParsingException;
import de.governikus.csl.demail.DeMailSignature;
import de.governikus.csl.demail.dkim.DeMailDKIMHeader;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.uom.impl.ByteArrayStreamProvider;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.utils.AbstractDocumentParser;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeMailParserBase<T>
extends AbstractDocumentParser<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeMailParserBase.class);

    protected void parseDeMailSignature(DeMailMimeMessage deMailMimeMessage, DeMailMimeDocument document) throws IOException {
        document.setDeMailMimeMessage(deMailMimeMessage);
        DeMailDKIMHeader deMailDKIMHeader = deMailMimeMessage.getDeMailDKIMHeader();
        Algorithm algorithm = null;
        try {
            algorithm = deMailDKIMHeader.getMappedAlgorithm();
        }
        catch (DeMailParsingException deMailParsingException) {
            // empty catch block
        }
        byte[] signatureBytes = deMailDKIMHeader.getSignatureBytes();
        if (algorithm instanceof SignatureAlgorithm && signatureBytes != null) {
            ArrayList<DeMailSignature> signatures;
            DeMailSignature deMailSignature = new DeMailSignature(deMailMimeMessage);
            Date parseDate = deMailDKIMHeader.getSigningTime();
            if (parseDate == null) {
                parseDate = deMailMimeMessage.getDate();
            }
            if (parseDate != null) {
                deMailSignature.setSigningTime(SVPFactory.createTypedDate((Date)parseDate, (DateType)DateType.CLAIMED_SIGNING_TIME));
            }
            byte[] signedHeaderData = deMailMimeMessage.getDKIMSignedHeaderData();
            deMailSignature.setSignedContent((Document)new ByteArrayDocument(signedHeaderData));
            deMailSignature.setSignatureValue(signatureBytes);
            deMailSignature.setSignatureAlgorithm((SignatureAlgorithm)algorithm);
            byte[] digest = deMailDKIMHeader.getBodyHash();
            byte[] contentData = deMailMimeMessage.getNormalizedBodyData();
            BaseSignedContentPart scp = new BaseSignedContentPart((StreamProvider)new ByteArrayStreamProvider(contentData), digest, ((SignatureAlgorithm)algorithm).getDigestAlgorithm());
            scp.setContentName(document.getName());
            deMailSignature.setSignedContentParts(Collections.singletonList(scp));
            X509Certificate signingCertificate = deMailMimeMessage.getDeMailSignatureCertificate();
            if (signingCertificate != null) {
                deMailSignature.setSigningCertificate(new X509CertificateImpl(signingCertificate));
            }
            if ((signatures = document.getSignatures()) == null) {
                signatures = new ArrayList<DeMailSignature>();
                document.setSignatures(signatures);
            }
            signatures.add(deMailSignature);
        }
    }
}

