/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail;

import de.governikus.csl.demail.DeMailMimeDocument;
import de.governikus.csl.demail.DeMailMimeMessageDataExtractor;
import de.governikus.csl.demail.DeMailMimeMessageSignatureDataExtractor;
import de.governikus.csl.demail.DeMailMimeParser;
import de.governikus.csl.demail.DeMailSignature;
import de.governikus.csl.demail.criteria.CheckBodyHash;
import de.governikus.csl.demail.criteria.CheckHeaderHash;
import de.governikus.csl.demail.criteria.DKIMSignatureStructureCheck;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.validate.svp.DeMailMimeDocumentValidationResult;
import de.governikus.csl.validate.svp.DeMailMimeMessageVerificationResult;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.ObjectValidationCriterion;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;

@PluginType(id=Plugin.PluginID.VALIDATE_DEMAIL_MIME, type=ValidatePlugin.class)
public class DeMailMimePlugin
extends AbstractDocumentPlugin<DeMailMimeDocument, DeMailSignature, DeMailMimeDocumentValidationResult, DeMailMimeMessageVerificationResult, SignatureValidationContext> {
    public DeMailMimePlugin() {
        super(DeMailSignature.class, SignatureValidationContext.class);
    }

    public DeMailMimeDocument parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        try {
            DeMailMimeParser parser = new DeMailMimeParser();
            return parser.loadDocument(doc);
        }
        catch (IOException | IllegalArgumentException | IndexOutOfBoundsException | NoSuchProviderException | CertificateException | MessagingException e) {
            throw new ValidatePluginException((ValidatePlugin)this, "Can't parse document", e);
        }
    }

    protected DeMailMimeDocumentValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        DeMailMimeDocumentValidationResult rs = new DeMailMimeDocumentValidationResult();
        rs.setObjectTypeID(this.getID());
        return rs;
    }

    protected DeMailMimeMessageVerificationResult createSignatureValidationResultStructure() {
        return new DeMailMimeMessageVerificationResult();
    }

    public SignatureValidationContext createContext(DeMailSignature signature, ValidationPolicyType policy) {
        return new SignatureValidationContext(policy);
    }

    public DataExtractor<? super DeMailSignature, ? super DeMailMimeMessageVerificationResult> getSignatureDataExtractor() {
        return new DeMailMimeMessageSignatureDataExtractor();
    }

    public DataExtractor<? super DeMailMimeDocument, ? super DeMailMimeDocumentValidationResult> getDocumentDataExtractor() {
        return new DeMailMimeMessageDataExtractor();
    }

    public static List<ObjectValidationCriterion<? super DeMailMimeDocument, ? super DeMailMimeDocumentValidationResult>> getAllKnownDocumentValidationCriteria() {
        ArrayList<ObjectValidationCriterion<? super DeMailMimeDocument, ? super DeMailMimeDocumentValidationResult>> criterionList = new ArrayList<ObjectValidationCriterion<? super DeMailMimeDocument, ? super DeMailMimeDocumentValidationResult>>();
        criterionList.add((ObjectValidationCriterion<? super DeMailMimeDocument, ? super DeMailMimeDocumentValidationResult>)new CheckBodyHash());
        criterionList.add((ObjectValidationCriterion<? super DeMailMimeDocument, ? super DeMailMimeDocumentValidationResult>)new CheckHeaderHash());
        return criterionList;
    }

    public static List<ValidationCriterion<? super DeMailSignature, ? super DeMailMimeMessageVerificationResult, ? super SignatureValidationContext>> getAllKnownSignatureValidationCriteria() {
        ArrayList<ValidationCriterion<? super DeMailSignature, ? super DeMailMimeMessageVerificationResult, ? super SignatureValidationContext>> criterionList = new ArrayList<ValidationCriterion<? super DeMailSignature, ? super DeMailMimeMessageVerificationResult, ? super SignatureValidationContext>>();
        criterionList.add((ValidationCriterion<? super DeMailSignature, ? super DeMailMimeMessageVerificationResult, ? super SignatureValidationContext>)new DKIMSignatureStructureCheck());
        return criterionList;
    }
}

