/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail;

import de.governikus.csl.demail.DeMailMimeDocument;
import de.governikus.csl.demail.DeMailMimeMessage;
import de.governikus.csl.demail.DeMailParserBase;
import de.governikus.csl.uom.SignedData;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import javax.mail.MessagingException;

public class DeMailMimeParser
extends DeMailParserBase<DeMailMimeDocument> {
    public DeMailMimeDocument loadDocument(SignedData sda) throws IOException, MessagingException, CertificateException, NoSuchProviderException {
        DeMailMimeDocument result = new DeMailMimeDocument();
        result.setName(sda.getSignature().getName());
        try (InputStream is = sda.getSignature().getInputStream();){
            this.parse(is, result);
        }
        return result;
    }

    private void parse(InputStream is, DeMailMimeDocument result) throws MessagingException, IOException, CertificateException, NoSuchProviderException {
        DeMailMimeMessage deMailMimeMessage = new DeMailMimeMessage();
        deMailMimeMessage.parseAsDeMail(is, false);
        this.parseDeMailSignature(deMailMimeMessage, result);
    }
}

