/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail;

import de.governikus.csl.demail.DeMailMimeDocument;
import de.governikus.csl.demail.DeMailMimeMessage;
import de.governikus.csl.demail.DispatchOption;
import de.governikus.csl.validate.svp.DeMailMessageHeaderData;
import de.governikus.csl.validate.svp.DeMailMimeDocumentValidationResult;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import java.util.List;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeMailMimeMessageDataExtractor
implements DataExtractor<DeMailMimeDocument, DeMailMimeDocumentValidationResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeMailMimeMessageDataExtractor.class);

    public void extractData(DeMailMimeDocument source, DeMailMimeDocumentValidationResult destination) {
        destination.setObjectName(source.getName());
        DeMailMimeMessage deMailMimeMessage = source.getDeMailMimeMessage();
        if (deMailMimeMessage != null) {
            DeMailMessageHeaderData deMailMessageHeaderData = new ObjectFactory().createDeMailMessageHeaderData();
            destination.setDeMailMessageHeaderData(deMailMessageHeaderData);
            deMailMessageHeaderData.setDeMailMessageType(deMailMimeMessage.getDeMailMessageType());
            try {
                deMailMessageHeaderData.setSubject(deMailMimeMessage.getSubject());
            }
            catch (MessagingException e) {
                LOGGER.info("Can't get Subject from DeMail", (Throwable)e);
            }
            deMailMessageHeaderData.setDeMailAccountHolder(deMailMimeMessage.getDeMailAccountHolder());
            deMailMessageHeaderData.setFromString(deMailMimeMessage.getFromString());
            deMailMessageHeaderData.setChosenRecipient(deMailMimeMessage.getChosenRecipient());
            deMailMessageHeaderData.setDate(deMailMimeMessage.getDate());
            List<DispatchOption> dispatchOptions = deMailMimeMessage.getDispatchOptions();
            if (dispatchOptions != null) {
                deMailMessageHeaderData.getDispatchOptions().addAll(dispatchOptions);
            }
            deMailMessageHeaderData.setAuthenticationLevel(deMailMimeMessage.getAuthenticationLevel());
            deMailMessageHeaderData.setAuthenticationMechanism(deMailMimeMessage.getAuthenticationMechanism());
            deMailMessageHeaderData.setPrivateID(deMailMimeMessage.getPrivateID());
            deMailMessageHeaderData.setDeMailMessageID(deMailMimeMessage.getDeMailMessageID());
            deMailMessageHeaderData.setOriginatorProvider(deMailMimeMessage.getOriginatorProvider());
            deMailMessageHeaderData.setDeMailVersion(deMailMimeMessage.getDeMailVersion());
            deMailMessageHeaderData.setDeMailNotificationType(deMailMimeMessage.getDeMailNotificationType());
        }
    }
}

