/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail;

import de.governikus.csl.demail.DeMailMessageType;
import de.governikus.csl.demail.DeMailParsingException;
import de.governikus.csl.demail.DeMailUtil;
import de.governikus.csl.demail.DispatchOption;
import de.governikus.csl.demail.NotificationType;
import de.governikus.csl.demail.dkim.DeMailDKIMHeader;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;

public class DeMailMimeMessage {
    private static final String[] SUPPORTED_DE_MAIL_VERSIONS = new String[]{"1.0", "1.1", "1.2"};
    private static final String RFC5322_DATEPATTERN = "EEE, dd MMM yyyy HH:mm:ss Z";
    private static final String DEMAIL_SIGNED_HEADERS_ENCODING = "ISO-8859-15";
    private DeMailDKIMHeader deMailDKIMHeader;
    private Date date;
    private X509Certificate signatureCertificate;
    private byte[] signedHeaderData;
    private byte[] normalizedBodyData;
    private MimeMessage mimeMessage;
    private CertificateFactory certFactory;
    protected Map<String, String> firstHeaderLinesMap;
    protected Map<String, String> firstHeaderValuesMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseAsDeMail(InputStream mimeStream, boolean hasToBeConfirmation) throws MessagingException, IOException, CertificateException, NoSuchProviderException {
        this.certFactory = CryptoProviderUtil.getCertificateFactoryInstance((String)"X509");
        try {
            this.mimeMessage = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), mimeStream);
            String[] headers = this.mimeMessage.getHeader("X-de-mail-originator-provider");
            if (headers == null || headers.length == 0) {
                throw new MessagingException("No De-Mail specific header entry X-de-mail-originator-provider found");
            }
        }
        finally {
            if (mimeStream != null) {
                IOUtils.closeQuietly((InputStream)mimeStream);
            }
        }
        this.parseHeaderValues();
        if (hasToBeConfirmation) {
            if (!this.getDeMailMessageType().isConfirmation()) {
                throw new MessagingException("De-mail message is not of required type 'confirmation': The type is '" + this.getDeMailMessageType().name() + "'!");
            }
        } else if (this.getDeMailMessageType().isConfirmation()) {
            throw new MessagingException("De-mail message is of type 'confirmation', but it shouldn't!");
        }
        this.parseHeaderLines();
        this.parseDKIMHeaderData();
        this.parseDate();
        this.parseDeMailSignedHeaderData();
        this.normalizeContentData();
        this.parseDeMailSignatureCertificate();
    }

    public MimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    private synchronized void parseHeaderLines() throws MessagingException {
        this.firstHeaderLinesMap = new HashMap<String, String>();
        Enumeration allHeaderLines = this.mimeMessage.getAllHeaderLines();
        while (allHeaderLines.hasMoreElements()) {
            String headerKey;
            String headerLine = (String)allHeaderLines.nextElement();
            int pos = headerLine.indexOf(":");
            if (pos <= 0 || this.firstHeaderLinesMap.containsKey(headerKey = headerLine.substring(0, pos).toLowerCase(Locale.ENGLISH))) continue;
            this.firstHeaderLinesMap.put(headerKey, headerLine);
        }
    }

    public String getFirstHeaderLine(String headerKey) {
        return this.firstHeaderLinesMap.get(headerKey.toLowerCase(Locale.ENGLISH));
    }

    private synchronized void parseHeaderValues() throws MessagingException {
        this.firstHeaderValuesMap = new HashMap<String, String>();
        Enumeration allHeaderLines = this.mimeMessage.getAllHeaders();
        while (allHeaderLines.hasMoreElements()) {
            Header header = (Header)allHeaderLines.nextElement();
            String headerKey = header.getName().toLowerCase(Locale.ENGLISH);
            String headerVal = header.getValue();
            if (headerVal != null && Boolean.parseBoolean(System.getProperty("vii.demail.decode822_header", "true"))) {
                headerVal = DeMailUtil.decodeRFC822(headerVal);
            }
            if (this.firstHeaderValuesMap.containsKey(headerKey)) continue;
            this.firstHeaderValuesMap.put(headerKey, headerVal);
        }
    }

    private String getFirstHeaderValue(String headerKey) {
        return this.firstHeaderValuesMap.get(headerKey.toLowerCase(Locale.ENGLISH));
    }

    public final boolean hasHeader(String name) {
        return this.getFirstHeaderValue(name) != null;
    }

    public void checkDeMailVersion() throws DeMailParsingException {
        String deMailVersion = this.getDeMailVersion();
        for (String version : SUPPORTED_DE_MAIL_VERSIONS) {
            if (!version.equals(deMailVersion)) continue;
            return;
        }
        throw new DeMailParsingException(SVPFactory.createMessageCode((String)"de_mail_version_not_supported", (Object[])new Object[]{DeMailDKIMHeader.doPreventNull(deMailVersion)}));
    }

    public String getDeMailVersion() {
        return this.getFirstHeaderValue("X-de-mail-version");
    }

    public String getDeMailIntegrityLine() {
        return this.getFirstHeaderLine("X-de-mail-integrity");
    }

    public DeMailMessageType getDeMailMessageType() {
        return DeMailMessageType.getForType((String)this.getFirstHeaderValue("X-de-mail-message-type"));
    }

    public String getDeMailAccountHolder() {
        return this.getFirstHeaderValue("X-de-mail-account-holder");
    }

    public Date getDate() {
        return this.date;
    }

    private synchronized void parseDate() {
        String dateHeaderValue = this.getFirstHeaderValue("Date");
        if (dateHeaderValue == null) {
            return;
        }
        try {
            this.date = new SimpleDateFormat(RFC5322_DATEPATTERN, Locale.US).parse(dateHeaderValue);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Header Date has illegal format", e);
        }
    }

    public X509Certificate getDeMailSignatureCertificate() {
        return this.signatureCertificate;
    }

    public DeMailDKIMHeader getDeMailDKIMHeader() {
        return this.deMailDKIMHeader;
    }

    public byte[] getDKIMSignedHeaderData() {
        return this.signedHeaderData;
    }

    private synchronized void parseDKIMHeaderData() throws IllegalArgumentException, DeMailParsingException {
        if (this.deMailDKIMHeader == null) {
            String integrityLine = this.getDeMailIntegrityLine();
            if (integrityLine == null) {
                throw new DeMailParsingException(SVPFactory.createMessageCode((String)"de_mail_dkim_missing_dkim"));
            }
            this.deMailDKIMHeader = new DeMailDKIMHeader(integrityLine);
        }
    }

    private synchronized void parseDeMailSignedHeaderData() throws UnsupportedEncodingException {
        int signatureBegin;
        StringBuilder sb = new StringBuilder();
        for (String signedHeader : this.getDeMailDKIMHeader().getHeaders()) {
            String headerLine = this.getFirstHeaderLine(signedHeader);
            if (headerLine == null) continue;
            sb.append(headerLine + "\r\n");
        }
        String integrityLine = this.getDeMailIntegrityLine();
        int signatureEnd = integrityLine.indexOf(59, signatureBegin = integrityLine.indexOf("b=") + 2);
        if (signatureEnd == -1) {
            signatureEnd = integrityLine.length();
        }
        String dkimHeaderLineWithoutSignatureValue = integrityLine.substring(0, signatureBegin) + integrityLine.substring(signatureEnd);
        sb.append(dkimHeaderLineWithoutSignatureValue);
        this.signedHeaderData = sb.toString().getBytes(DEMAIL_SIGNED_HEADERS_ENCODING);
    }

    private synchronized void parseDeMailSignatureCertificate() {
        String certString = this.getFirstHeaderValue("X-de-mail-signature-certificate");
        if (certString == null) {
            return;
        }
        byte[] certBinary = Base64.getMimeDecoder().decode(certString.replaceAll("\\s", ""));
        try {
            this.signatureCertificate = (X509Certificate)this.certFactory.generateCertificate(new ByteArrayInputStream(certBinary));
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Header value X-de-mail-signature-certificate is malformed", e);
        }
    }

    private synchronized void normalizeContentData() throws IOException, MessagingException {
        int n;
        byte[] body = null;
        try (InputStream is = this.mimeMessage.getRawInputStream();){
            body = IOUtils.toByteArray((InputStream)is);
        }
        for (n = body.length; n > 0 && (body[n - 1] == 10 || body[n - 1] == 13); --n) {
        }
        this.normalizedBodyData = new byte[n + 2];
        System.arraycopy(body, 0, this.normalizedBodyData, 0, n);
        this.normalizedBodyData[n] = 13;
        this.normalizedBodyData[n + 1] = 10;
    }

    public byte[] getNormalizedBodyData() {
        return this.normalizedBodyData;
    }

    public String getDeMailMessageID() {
        return this.getFirstHeaderValue("X-de-mail-message-id");
    }

    public String getFromString() {
        return this.getFirstHeaderValue("From");
    }

    public String getChosenRecipient() {
        return this.getFirstHeaderValue("X-de-mail-chosen-recipient");
    }

    public String getActualRecipients() {
        return this.getFirstHeaderValue("X-de-mail-actual-recipients");
    }

    public String getAuthenticationLevel() {
        return this.getFirstHeaderValue("X-de-mail-auth-level");
    }

    public String getAuthenticationMechanism() {
        return this.getFirstHeaderValue("X-de-mail-auth-mechanism");
    }

    public List<DispatchOption> getDispatchOptions() {
        ArrayList<DispatchOption> options = new ArrayList<DispatchOption>();
        for (DispatchOption option : DispatchOption.values()) {
            if (!"yes".equalsIgnoreCase(this.getFirstHeaderValue(option.getHeaderName()))) continue;
            options.add(option);
        }
        return options;
    }

    public String getPrivateID() {
        return this.getFirstHeaderValue("X-de-mail-private-id");
    }

    public String getOriginatorProvider() {
        return this.getFirstHeaderValue("X-de-mail-originator-provider");
    }

    public String getSubject() throws MessagingException {
        String subject = this.mimeMessage.getSubject();
        if (subject == null) {
            return null;
        }
        return DeMailUtil.decodeRFC822(subject);
    }

    public NotificationType getDeMailNotificationType() {
        try {
            return NotificationType.getType((String)this.getFirstHeaderValue("X-de-mail-notification-type"));
        }
        catch (IllegalArgumentException ex) {
            return NotificationType.UNKNOWN_VALUE;
        }
    }
}

