/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.demail;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.AlgorithmService;
import java.util.Locale;

public final class DeMailAlgorithmMapper {
    private static final String CHARS_TO_REMOVE = "[^\\p{Alpha}\\p{Digit}]";

    public static Algorithm mapAlgorithm(String dkimAlgorithmDefinition) {
        if (dkimAlgorithmDefinition == null) {
            throw new IllegalArgumentException("DKIM algorithm definition not found!");
        }
        String[] algoNames = dkimAlgorithmDefinition.split("/");
        if (algoNames.length == 1) {
            String hashAlgorithm = algoNames[0].replaceAll(CHARS_TO_REMOVE, "").toLowerCase(Locale.ENGLISH);
            return AlgorithmService.getDigestForJCAName((String)hashAlgorithm);
        }
        if (algoNames.length == 2) {
            String hashAlgorithm = algoNames[0].replaceAll(CHARS_TO_REMOVE, "").toLowerCase(Locale.ENGLISH);
            String sigAlgorithm = algoNames[1].replaceAll(CHARS_TO_REMOVE, "").toLowerCase(Locale.ENGLISH);
            if (sigAlgorithm.equals("rsassapss")) {
                sigAlgorithm = "RSAandMGF1";
            }
            return AlgorithmService.getSignatureForJCAName((String)(hashAlgorithm + "With" + sigAlgorithm));
        }
        throw new IllegalArgumentException("DKIM algorithm definition not valid!");
    }
}

