/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.verify.model.formular.process.impl;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.gui.view.component.ContentFileChooser;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.formular.process.impl.AbstractProcessFormular;
import de.bos_bremen.ecard.client.verify.model.formular.process.VerifyProcessFormular;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

public class VerifyFormular
extends AbstractProcessFormular
implements VerifyProcessFormular {
    private List<ProcessSignedFile> selectedFiles;
    private String verifyReportTargetFolder;
    private EnumMap<StepFactory.StepName, Boolean> skippStep = new EnumMap(StepFactory.StepName.class);
    private TargetFolderType verifyReportTargetfolderType;
    private Boolean verifyOnline = Boolean.TRUE;
    private String localCopyFolder;
    private SubsequentProcess currentSubsequentProcess;

    public VerifyFormular() {
    }

    public VerifyFormular(VerifyFormular formular) {
        super((AbstractProcessFormular)formular);
        this.selectedFiles = formular.selectedFiles != null ? new ArrayList<ProcessSignedFile>(formular.selectedFiles) : new ArrayList();
        this.skippStep = formular.skippStep != null ? new EnumMap<StepFactory.StepName, Boolean>(formular.skippStep) : new EnumMap(StepFactory.StepName.class);
        this.verifyReportTargetFolder = formular.verifyReportTargetFolder;
        this.verifyReportTargetfolderType = formular.verifyReportTargetfolderType;
    }

    public void addSelectedFile(ProcessSignedFile file) {
        if (this.selectedFiles == null) {
            this.selectedFiles = new ArrayList<ProcessSignedFile>();
        }
        this.selectedFiles.add(file);
        this.notifyAllChangeListener(null, file, StepFactory.StepName.selectfiles);
    }

    public boolean containSelectedFiles(ProcessSignedFile newProcessFile) {
        if (this.selectedFiles != null && !this.selectedFiles.isEmpty()) {
            for (ProcessSignedFile processFile : this.selectedFiles) {
                boolean currentDetachAndNewFileEquals;
                boolean processFilesEquals = processFile.getFile() != null && newProcessFile.getFile() != null && processFile.getFile().equals((Object)newProcessFile.getFile());
                boolean detachFilesEquals = false;
                boolean currentFileAndNewDetchEquals = processFile.getFile() != null && newProcessFile.getDetachedFile() != null && processFile.getFile().equals((Object)newProcessFile.getDetachedFile());
                boolean bl = currentDetachAndNewFileEquals = processFile.getDetachedFile() != null && newProcessFile.getFile() != null && processFile.getDetachedFile().equals(newProcessFile.getFile());
                if (!processFilesEquals && !detachFilesEquals && !currentFileAndNewDetchEquals && !currentDetachAndNewFileEquals) continue;
                return true;
            }
        }
        return false;
    }

    public List<ProcessSignedFile> getSelectedFiles() {
        return this.selectedFiles;
    }

    public boolean removeSelectedFile(ProcessSignedFile fileToRemove) {
        boolean removed;
        if (this.selectedFiles == null) {
            this.selectedFiles = new ArrayList<ProcessSignedFile>();
        }
        if (removed = this.selectedFiles.remove(fileToRemove)) {
            this.notifyAllChangeListener(fileToRemove, null, StepFactory.StepName.selectfiles);
        }
        return removed;
    }

    public void removeAllFiles() {
        ArrayList<ProcessSignedFile> liste = new ArrayList<ProcessSignedFile>();
        if (this.selectedFiles != null) {
            for (ProcessSignedFile psf : this.selectedFiles) {
                liste.add(psf);
            }
        } else {
            this.selectedFiles = new ArrayList<ProcessSignedFile>();
        }
        for (ProcessSignedFile psf : liste) {
            this.removeSelectedFile(psf);
        }
    }

    public void setSelectedFiles(List<File> files, boolean replaceFiles) {
        if (replaceFiles || this.selectedFiles == null) {
            this.selectedFiles = new ArrayList<ProcessSignedFile>();
        }
        if (files != null) {
            File file;
            int i;
            ArrayList<File> tempFiles = new ArrayList<File>(files);
            for (i = 0; i < files.size(); ++i) {
                file = files.get(i);
                boolean isDetached = Utils.isDetachedSignature((File)file);
                boolean exception = false;
                if (!exception && isDetached) {
                    tempFiles.remove(file);
                    ProcessSignedFile processFile = new ProcessSignedFile(file);
                    String contentFilename = this.getContentFileName(file);
                    File possibleContentFile = new File(contentFilename);
                    File contentFile = null;
                    int fileIndex = -1;
                    fileIndex = this.containsContentFile(tempFiles, possibleContentFile);
                    if (fileIndex != -1) {
                        contentFile = possibleContentFile;
                        tempFiles.remove(fileIndex);
                    } else {
                        contentFile = this.getContentFile(files, file);
                    }
                    if (contentFile != null) {
                        processFile.setDetachedFile(contentFile);
                    }
                    if (this.containSelectedFiles(processFile)) continue;
                    this.selectedFiles.add(processFile);
                    continue;
                }
                if (!exception) continue;
                tempFiles.remove(file);
            }
            for (i = 0; i < tempFiles.size(); ++i) {
                file = (File)tempFiles.get(i);
                ProcessSignedFile processFile = new ProcessSignedFile(file);
                if (this.containSelectedFiles(processFile)) continue;
                this.selectedFiles.add(processFile);
            }
        }
        this.notifyAllChangeListener(null, this.selectedFiles, StepFactory.StepName.selectfiles);
    }

    private File getContentFile(List<File> files, File signedFile) {
        if (files != null && signedFile != null) {
            String contentFilename = this.getContentFileName(signedFile);
            File possibleContentFile = new File(contentFilename);
            ContentFileChooser chooser = new ContentFileChooser();
            if (possibleContentFile.exists()) {
                chooser.setSelectedFile(new File(contentFilename));
            } else {
                chooser.setCurrentDirectory(signedFile.getParentFile());
            }
            chooser.setDialogTitle(signedFile.getName() + " - " + Messages.getString((String)"step.selectsignedfiles.selectcontentfile.title"));
            int answer = chooser.showDialog((Component)Document.getInstance().getFrame(), Messages.getString((String)"step.selectsignedfiles.selectcontentfile.title"));
            File contentFile = null;
            if (answer == 0) {
                contentFile = chooser.getSelectedFile();
            }
            return contentFile;
        }
        return null;
    }

    private String getContentFileName(File signedFile) {
        if (signedFile.getName().toLowerCase().endsWith("_signed.xml")) {
            return signedFile.getAbsolutePath().substring(0, signedFile.getAbsolutePath().toLowerCase().lastIndexOf("_signed.xml")) + ".xml";
        }
        return signedFile.getAbsolutePath().substring(0, signedFile.getAbsolutePath().lastIndexOf("."));
    }

    private int containsContentFile(List<File> inOutFiles, File possibleContentFile) {
        int fileIndex = -1;
        for (int i = 0; inOutFiles != null && i < inOutFiles.size(); ++i) {
            File file = inOutFiles.get(i);
            if (!file.getAbsoluteFile().equals(possibleContentFile.getAbsoluteFile())) continue;
            fileIndex = i;
            break;
        }
        return fileIndex;
    }

    @Override
    public String getVerifyReportTargetFolder() {
        return this.verifyReportTargetFolder;
    }

    @Override
    public TargetFolderType getVerifyReportTargetFolderType() {
        return this.verifyReportTargetfolderType;
    }

    @Override
    public void setVerifyOnline(boolean online) {
    }

    @Override
    public void setVerifyReportTargetFolder(String reportTargetFolder) {
        this.verifyReportTargetFolder = reportTargetFolder;
    }

    @Override
    public void setVerifyReportTargetFolderType(TargetFolderType targetFolderType) {
        this.verifyReportTargetfolderType = targetFolderType;
    }

    @Override
    public Boolean verifyOnline() {
        return this.verifyOnline;
    }

    public void skipStep(boolean useDefaults, StepFactory.StepName stepName) {
        this.skippStep.put(stepName, useDefaults);
    }

    public Boolean skipStep(StepFactory.StepName stepName) {
        if (this.skippStep.containsKey(stepName)) {
            return this.skippStep.get(stepName);
        }
        return Boolean.FALSE;
    }

    public void setDefault() {
        this.setSelectedFiles(new ArrayList<File>(), true);
        this.setVerifyReportTargetFolder("");
        this.setVerifyReportTargetFolderType(TargetFolderType.sameAsSourceFolder);
        EnumMap<StepFactory.StepName, Boolean> oldSkippStep = new EnumMap<StepFactory.StepName, Boolean>(StepFactory.StepName.class);
        oldSkippStep.putAll(this.skippStep);
        for (StepFactory.StepName key : oldSkippStep.keySet()) {
            if (!Boolean.TRUE.equals(this.skippStep.get(key))) continue;
            this.skippStep.remove(key);
            this.skipStep(false, key);
        }
    }

    public void notifyAllChangeListener() {
        this.notifyAllChangeListener(null, Boolean.TRUE, StepFactory.StepName.selectfiles);
    }

    public void setFileAsSeen(ProcessSignedFile file) throws SignerException {
        try {
            file.setSeen(true);
        }
        finally {
            this.notifyAllChangeListener();
        }
    }

    @Override
    public String getLocalCopyFolder() {
        return this.localCopyFolder;
    }

    @Override
    public void setLocalCopyFolder(String targetFolder) {
        String oldValue = this.localCopyFolder;
        this.localCopyFolder = targetFolder;
        this.notifyAllChangeListener(oldValue, targetFolder, StepFactory.StepName.selecttargetfolder);
    }

    public SubsequentProcess getSubsequentProcess() {
        return this.currentSubsequentProcess;
    }

    public void setSubsequentProcess(SubsequentProcess subsequentProcess) {
        this.currentSubsequentProcess = subsequentProcess;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("\nVerifyFormular");
        List<ProcessSignedFile> selected = this.getSelectedFiles();
        stringBuilder.append("\nSelectedFiles:");
        if (selected == null || selected.isEmpty()) {
            stringBuilder.append("---");
        } else {
            for (ProcessSignedFile processSignedFile : this.selectedFiles) {
                stringBuilder.append(processSignedFile.getFile().getAbsolutePath() + ";");
            }
        }
        stringBuilder.append("\n");
        stringBuilder.append("ReportTargetFolder:" + this.getVerifyReportTargetFolder() + "\n");
        stringBuilder.append("ReportTargetFolderType:" + this.getVerifyReportTargetFolderType() + "\n");
        return stringBuilder.toString();
    }
}

