/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.verify.gui.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.step.working.WorkingStep;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.step.WorkingStepView;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.verify.control.process.impl.VerifyConfig;
import de.governikus.csl.server.CertificateValidationServer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VerifyView
extends WorkingStepView {
    private static final Logger LOG = LogManager.getLogger(VerifyView.class);
    private static final long serialVersionUID = 1L;
    private static final JPanel centerPanel = new JPanel();
    private JLabel verifyServerText;

    public VerifyView(WorkingStep workingstep) {
        super(workingstep, centerPanel);
    }

    protected void initGUI(JPanel contentPanel) {
        super.initGUI(contentPanel);
        this.setLayout(new BorderLayout());
        this.add(contentPanel, "Center");
        Font labelFont = UIManager.getFont("Label.font").deriveFont(1);
        Color labelColor = SignerTheme.GRAY_5;
        JPanel verifyServerPanel = new JPanel(new GridBagLayout());
        verifyServerPanel.setBorder((Border)CurvedBorder.EMPTY_BORDER);
        JLabel verifyServerLabel = new JLabel(Messages.getString((String)"verification.server.label"));
        verifyServerLabel.setFont(labelFont);
        verifyServerLabel.setForeground(labelColor);
        this.verifyServerText = new JLabel();
        this.setVerifyServerLabelText();
        this.verifyServerText.setFocusable(true);
        this.verifyServerText.addFocusListener(ComponentUtils.createFocusListenerFor((JPanel)verifyServerPanel));
        verifyServerLabel.setLabelFor(this.verifyServerText);
        Insets insets = new Insets(10, 3, 10, 3);
        verifyServerPanel.add((Component)verifyServerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, insets, 0, 0));
        verifyServerPanel.add((Component)this.verifyServerText, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.add(verifyServerPanel, "South");
    }

    private void setVerifyServerLabelText() {
        CertificateValidationServer cvs = ((VerifyConfig)this.lastStep.getParent().getConfig()).getCertificateValidationServer();
        if (cvs.getUrl() == null || cvs.getUrl().isEmpty()) {
            this.verifyServerText.setText(Messages.getString((String)"verification.server.offline"));
        } else {
            this.verifyServerText.setText(cvs.getUrl());
            this.verifyServerText.setToolTipText(cvs.getUrl());
        }
    }

    public void configChanged() {
        super.configChanged();
        this.setVerifyServerLabelText();
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            LOG.debug("set active verify last step: {}", (Object)this.lastStep.getStepName());
            LOG.info("\n---------------- Validieren/Validieren ... ---------------------------");
        }
        this.setVerifyServerLabelText();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.removeAll();
        this.stepContentPanel.removeAll();
        this.initGUI(this.stepContentPanel);
        this.revalidate();
    }
}

