/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.verify.gui.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.action.DropSelectedFileHandler;
import de.bos_bremen.ecard.client.action.RemoveFileHandler;
import de.bos_bremen.ecard.client.action.SelectedFileHandler;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.view.component.ContentFileChooser;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.DescriptionPanel;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.gui.view.component.table.FileDropTargetHandler;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableFactory;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableI;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableListenerFactory;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableModelI;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.verify.control.step.SelectFiles;
import de.governikus.utils.secutils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.NodeList;

public class SelectFilesView
extends JPanel
implements StepChangedListener,
DropSelectedFileHandler,
RemoveFileHandler,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(SelectFilesView.class);
    private final transient SelectFiles selectFilesStep;
    private transient ProcessFileTableI processFileTable;
    private static final List<String> DSIG_NS = Arrays.asList("http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2009/xmldsig11#", "http://www.w3.org/2010/xmldsig2#");

    public SelectFilesView(SelectFiles step) {
        this.selectFilesStep = step;
        this.initGUI();
        this.selectFilesStep.addStateChangeListener(this);
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)this);
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        DescriptionPanel descPanel = new DescriptionPanel("verify.step.selectfiles");
        this.add((Component)descPanel, "North");
        this.processFileTable = ProcessFileTableFactory.createProcessFileTable((ProcessName)this.selectFilesStep.getParent().getProcessName());
        ((JTable)this.processFileTable).addMouseListener(ProcessFileTableListenerFactory.createProcessFileTableMouseListener((ProcessI)this.selectFilesStep.getParent()));
        ((JTable)this.processFileTable).addKeyListener(ProcessFileTableListenerFactory.createProcessFileTableKeyListener((ProcessI)this.selectFilesStep.getParent()));
        final JScrollPane scrollPane = new JScrollPane((JTable)this.processFileTable);
        scrollPane.setBorder((Border)CurvedBorder.DEFAULT_BORDER);
        ((JTable)this.processFileTable).addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                scrollPane.setBorder((Border)CurvedBorder.FOCUSED_BORDER);
            }

            @Override
            public void focusLost(FocusEvent e) {
                scrollPane.setBorder((Border)CurvedBorder.DEFAULT_BORDER);
            }
        });
        String mnemonic = Messages.getResource((String)"view.step.selectfiles.list.header.mnemonic");
        if (mnemonic != null) {
            KeyStroke ks = KeyStroke.getKeyStroke("alt " + mnemonic.charAt(0));
            int condition = 2;
            scrollPane.getInputMap(condition).put(ks, "selectTable");
        }
        scrollPane.getActionMap().put("selectTable", new SetFocusOnTableAction());
        this.add((Component)scrollPane, "Center");
        new DropTarget(scrollPane, (DropTargetListener)new FileDropTargetHandler((DropSelectedFileHandler)this));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(2, 1));
        this.add((Component)buttonPanel, "West");
        Document documentInstance = Document.getInstance();
        IconButton selectFilesButtonAdd = new IconButton();
        selectFilesButtonAdd.setAction(documentInstance.getActionFactory().createSelectSignedFile((SelectedFileHandler)this, "action.selectfile"));
        if (documentInstance.getProductFunctions().getLicence("process/verify/sourcefolder/addfiles").isVisible()) {
            buttonPanel.add((Component)selectFilesButtonAdd);
            selectFilesButtonAdd.getAction().setEnabled(documentInstance.getProductFunctions().getLicence("process/verify/sourcefolder/addfiles").isEditable());
        }
        IconButton selectFilesButtonRemove = new IconButton();
        selectFilesButtonRemove.setAction(documentInstance.getActionFactory().createRemoveFile((RemoveFileHandler)this, "action.removefile"));
        KeyStroke deleteKeyStroke = KeyStroke.getKeyStroke("DELETE");
        this.getInputMap(1).put(deleteKeyStroke, "deleteAction");
        this.getActionMap().remove("deleteAction");
        this.getActionMap().put("deleteAction", selectFilesButtonRemove.getAction());
        if (documentInstance.getProductFunctions().getLicence("process/verify/sourcefolder/removefiles").isVisible()) {
            buttonPanel.add((Component)selectFilesButtonRemove);
            selectFilesButtonRemove.getAction().setEnabled(documentInstance.getProductFunctions().getLicence("process/verify/sourcefolder/removefiles").isEditable());
        }
        if (!documentInstance.getProductFunctions().getLicence(this.selectFilesStep.getLicenceTypKey()).useInProcess()) {
            this.selectFilesStep.removeAllFiles();
        }
        this.stateChanged(null);
        JComponentUtils.setLookByLicence((JComponent)this, (LicenceTyp)this.selectFilesStep.getLicenceTyp());
    }

    public void stateChanged(ChangeEvent event) {
        List<ProcessSignedFile> dataVector = this.selectFilesStep.getFiles();
        ((ProcessFileTableModelI)this.processFileTable.getModel()).setDataVector(dataVector.toArray());
        this.processFileTable.setColumnWidth();
    }

    public File getLastFolder() {
        String lastUsedFolder = this.selectFilesStep.getApplicationProperties().getProperty("last_folder", null);
        File lastFolder = null;
        if (lastUsedFolder != null) {
            lastFolder = new File(lastUsedFolder);
        }
        return lastFolder;
    }

    public void setFileToLoad(File fileToLoad) {
        if (fileToLoad == null) {
            return;
        }
        if (!fileToLoad.isFile()) {
            LOG.warn("{} is not a file", (Object)fileToLoad.getName());
            return;
        }
        if (this.fileExists(fileToLoad)) {
            LOG.warn("{} is exists", (Object)fileToLoad.getName());
            return;
        }
        ProcessSignedFile processFile = this.createProcessSignedFile(fileToLoad);
        this.selectFilesStep.addFile(processFile);
        this.selectFilesStep.setApplicationProperty("last_folder", fileToLoad.getAbsolutePath());
    }

    public void setFilesToLoad(File[] filesToLoad) {
        if (filesToLoad == null || filesToLoad.length == 0) {
            return;
        }
        for (File file : filesToLoad) {
            this.setFileToLoad(file);
        }
    }

    public LicenceTyp getLicenceTyp() {
        return Document.getInstance().getProductFunctions().getLicence("process/verify/sourcefolder/addfiles");
    }

    private ProcessSignedFile createProcessSignedFile(File file) {
        boolean isDetached = Utils.isDetachedSignature((File)file);
        String[] xmlSigRefs = null;
        if (!isDetached) {
            xmlSigRefs = this.parseXMLReferenceNames(file);
            isDetached = this.isDetachedXML(xmlSigRefs);
        }
        ProcessSignedFile psf = new ProcessSignedFile(file);
        if (isDetached) {
            File contentFile = null;
            String contentFilename = file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf("."));
            File possibleContentFile = new File(contentFilename);
            if (xmlSigRefs != null) {
                contentFilename = this.parseXMLReferenceName(xmlSigRefs);
                possibleContentFile = new File(psf.getFile().getParentFile().getAbsolutePath(), contentFilename);
            }
            ContentFileChooser chooser = new ContentFileChooser();
            chooser.setCurrentDirectory(file.getParentFile());
            chooser.setPreferredSize(GUIUtils.createRelativeToParent((Dimension)Document.getInstance().getFrame().getMinimumSize(), (double)0.9, (double)0.6));
            if (possibleContentFile.exists()) {
                chooser.setSelectedFile(new File(contentFilename));
            }
            chooser.setDialogTitle(file.getName() + " - " + Messages.getString((String)"step.selectsignedfiles.selectcontentfile.title"));
            int answer = chooser.showDialog((Component)Document.getInstance().getFrame(), Messages.getString((String)"step.selectsignedfiles.selectcontentfile.title"));
            if (answer == 0) {
                contentFile = chooser.getSelectedFile();
                psf.setDetachedFile(contentFile);
            }
        }
        return psf;
    }

    private boolean isDetachedXML(String[] refList) {
        if (refList != null) {
            for (int i = 0; i < refList.length; ++i) {
                if (refList[i].charAt(0) == '#') continue;
                return true;
            }
        }
        return false;
    }

    private String[] parseXMLReferenceNames(File file) {
        String[] stringArray;
        FileInputStream is = new FileInputStream(file);
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)builderFactory);
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            org.w3c.dom.Document document = builder.parse(is);
            NodeList ndList = document.getElementsByTagNameNS("*", "Reference");
            String[] ret = new String[ndList.getLength()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = DSIG_NS.contains(ndList.item(i).getNamespaceURI()) ? ndList.item(i).getAttributes().getNamedItem("URI").getNodeValue() : "#";
            }
            stringArray = ret;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
                return null;
            }
        }
        ((InputStream)is).close();
        return stringArray;
    }

    private String parseXMLReferenceName(String[] refList) {
        if (refList != null) {
            for (int i = 0; i < refList.length; ++i) {
                if (refList[i].startsWith("#")) continue;
                if (refList[i].contains("\\")) {
                    return refList[i].substring(refList[i].lastIndexOf("\\") + 1, refList[i].length());
                }
                if (refList[i].contains("/")) {
                    return refList[i].substring(refList[i].lastIndexOf("/") + 1, refList[i].length());
                }
                return refList[i];
            }
        }
        return "";
    }

    private boolean fileExists(File file) {
        String absoluteName = file.getAbsolutePath();
        List<ProcessSignedFile> files = this.selectFilesStep.getFiles();
        for (ProcessSignedFile pfs : files) {
            if (!pfs.getFile().getAbsolutePath().equals(absoluteName)) continue;
            return true;
        }
        return false;
    }

    public Object[] getFilesToRemove() {
        int[] selectedRows = this.processFileTable.getSelectedValues();
        Object[] objectsToRemove = new Object[selectedRows.length];
        List<ProcessSignedFile> alleFiles = this.selectFilesStep.getFiles();
        for (int i = 0; i < selectedRows.length; ++i) {
            objectsToRemove[i] = alleFiles.get(selectedRows[i]);
        }
        return objectsToRemove;
    }

    public void removeFiles(Object[] files) {
        LOG.debug("removeFiles for {} elemente", (Object)files.length);
        for (Object obj : files) {
            if (!(obj instanceof ProcessSignedFile)) continue;
            ProcessSignedFile objProcessSignedFile = (ProcessSignedFile)obj;
            this.selectFilesStep.removeFile(objProcessSignedFile);
        }
        this.processFileTable.clearSelection();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.removeAll();
        this.initGUI();
        this.revalidate();
    }

    public void setActive(boolean active) {
        if (!active) {
            return;
        }
        LOG.debug("set active {}", (Object)this.selectFilesStep.getStepName());
        LOG.info("\n---------------- Validieren/Dateiauswahl : ausgew\u00e4hlt ---------------------------");
    }

    private class SetFocusOnTableAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SelectFilesView.this.processFileTable.requestFocusInWindow();
            ((JTable)SelectFilesView.this.processFileTable).getSelectionModel().setSelectionInterval(0, 0);
        }
    }
}

