/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.verify.gui.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.SelectTargetFolderHandler;
import de.bos_bremen.ecard.client.control.step.SkippableStep;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.gui.IconScalingUtils;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.CuttingLabel;
import de.bos_bremen.ecard.client.gui.view.component.DescriptionPanel;
import de.bos_bremen.ecard.client.gui.view.component.GridBagPanel;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.SkipStepHandler;
import de.bos_bremen.ecard.client.gui.view.component.SkipStepPanel;
import de.bos_bremen.ecard.client.gui.view.component.buttons.CurvedToggleIconButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.LinkButton;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import de.bos_bremen.ecard.client.verify.control.process.impl.VerifyConfig;
import de.bos_bremen.ecard.client.verify.control.step.Options;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptionsView
extends JPanel
implements StepChangedListener,
ActionListener,
SelectTargetFolderHandler,
PropertyChangeListener,
SkipStepHandler {
    private static final Logger LOG = LogManager.getLogger(OptionsView.class);
    private static final long serialVersionUID = 1L;
    private final transient Options optionsStep;
    private JLabel verifyOnline;
    private LinkButton verifyserverProvider;
    private JPanel verifyServerPanel;
    private JLabel verifyServerError;
    private Font errorFont;
    private CurvedToggleIconButton selectSameAsSourceButton;
    private CurvedToggleIconButton selectSpecialFolderButton;
    private CuttingLabel specialFolderLabel;
    private CurvedToggleIconButton selectLocalCopyFolderButton;
    private CurvedToggleIconButton deleteLocalCopyFolderButton;
    private CuttingLabel localCopyFolderLabel;
    private static final String PROCESS_VERIFY_OPTIONS = "process/verify/options";
    private static final String ACTION_SELECTTARGETFOLDER = "action.selecttargetfolder";

    public OptionsView(Options step) {
        this.optionsStep = step;
        this.initGUI();
        this.optionsStep.addStateChangeListener(this);
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)this);
    }

    private void createComponents() {
        Document documentInstance = Document.getInstance();
        this.selectSameAsSourceButton = new CurvedToggleIconButton("action.selecttargetfoldersameassource");
        this.selectSameAsSourceButton.addKeyListener(this.createKeyAdapterFor(this.selectSameAsSourceButton));
        this.selectSameAsSourceButton.setAction(documentInstance.getActionFactory().createSelectTargetFolderSameAsSource((SelectTargetFolderHandler)this, "action.selecttargetfoldersameassource"));
        String mnemonic = Messages.getResource((String)"action.selecttargetfoldersameassource.mnemonic");
        KeyStroke shortcut = KeyStroke.getKeyStroke("alt " + mnemonic.charAt(0));
        this.selectSameAsSourceButton.getInputMap(2).put(shortcut, "useSame");
        this.selectSameAsSourceButton.getActionMap().put("useSame", this.selectSameAsSourceButton.getAction());
        this.selectSpecialFolderButton = new CurvedToggleIconButton(ACTION_SELECTTARGETFOLDER);
        this.selectSpecialFolderButton.addKeyListener(this.createKeyAdapterFor(this.selectSpecialFolderButton));
        this.selectSpecialFolderButton.setAction(documentInstance.getActionFactory().createSelectTargetFolder((SelectTargetFolderHandler)this, ACTION_SELECTTARGETFOLDER));
        mnemonic = Messages.getResource((String)"action.selecttargetfolder.mnemonic");
        shortcut = KeyStroke.getKeyStroke("alt " + mnemonic.charAt(0));
        this.selectSpecialFolderButton.getInputMap(2).put(shortcut, "useSpecial");
        this.selectSpecialFolderButton.getActionMap().put("useSpecial", this.selectSpecialFolderButton.getAction());
        JLabel folderLabel = new JLabel(Messages.getString((String)"step.options.folder") + "   ");
        folderLabel.setHorizontalAlignment(11);
        this.specialFolderLabel = new CuttingLabel();
        this.specialFolderLabel.setFocusable(false);
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.selectSpecialFolderButton);
        bg.add((AbstractButton)this.selectSameAsSourceButton);
        switch (this.optionsStep.getVerifyReportTargetFolderType()) {
            case oneSpecial: {
                bg.setSelected(this.selectSpecialFolderButton.getModel(), true);
                break;
            }
            default: {
                bg.setSelected(this.selectSameAsSourceButton.getModel(), true);
            }
        }
        this.verifyOnline = new JLabel(Messages.getString((String)"step.options.methods.validate.online"));
        this.verifyOnline.setFocusable(true);
        this.verifyOnline.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)this.verifyOnline));
        this.verifyserverProvider = new LinkButton(Messages.getString((String)"step.options.methods.verificationprovider"));
        this.verifyserverProvider.setMnemonic(Messages.getString((String)"step.options.methods.verificationprovider.mnemonic").charAt(0));
        InputMap inputMap = this.verifyserverProvider.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(this.verifyserverProvider.getMnemonic(), 512), "providerConfigure");
        ActionMap actionMap = this.verifyserverProvider.getActionMap();
        actionMap.put("providerConfigure", new ProviderConfigureAction());
        this.verifyserverProvider.setToolTipText(Messages.getString((String)"step.options.methods.verificationprovider.tooltip"));
        this.verifyserverProvider.setBackground(Color.WHITE);
        this.verifyserverProvider.setFocusPainted(false);
        this.verifyserverProvider.addActionListener((ActionListener)new ProviderConfigureAction());
        this.verifyServerPanel = new JPanel(new FlowLayout(0));
        this.verifyServerPanel.setBorder((Border)CurvedBorder.EMPTY_BORDER);
        this.verifyServerPanel.add((Component)this.verifyserverProvider);
        this.verifyserverProvider.addFocusListener(ComponentUtils.createFocusListenerFor((JPanel)this.verifyServerPanel));
        this.verifyserverProvider.addMouseListener((MouseListener)ComponentUtils.createMouseAdapterForLink((LinkButton)this.verifyserverProvider));
        this.verifyServerError = new JLabel();
        this.verifyServerError.setBorder((Border)CurvedBorder.EMPTY_BORDER);
        this.verifyServerError.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)this.verifyServerError));
        this.errorFont = (Font)UIManager.get("TitledBorder.font");
        this.verifyServerError.setFont(this.errorFont);
        this.verifyServerError.setForeground(SignerTheme.COLOR_RED);
        this.verifyServerError.setText(Messages.getString((String)"step.options.verifyserver.ok"));
        this.selectLocalCopyFolderButton = new CurvedToggleIconButton();
        this.selectLocalCopyFolderButton.setAction(documentInstance.getActionFactory().createSelectLocalCopyFolder((SelectTargetFolderHandler)this, ACTION_SELECTTARGETFOLDER));
        this.deleteLocalCopyFolderButton = new CurvedToggleIconButton();
        this.deleteLocalCopyFolderButton.setBorder((Border)CurvedBorder.EMPTY_BORDER);
        ImageIcon imageIcon = IconScalingUtils.createMultiResIcon((String)"action.localcopy.icon");
        this.deleteLocalCopyFolderButton.setIcon((Icon)imageIcon);
        this.deleteLocalCopyFolderButton.addActionListener(actionEvent -> {
            this.setLocalCopyFolder(null);
            this.selectLocalCopyFolderButton.setSelected(false);
        });
        this.localCopyFolderLabel = new CuttingLabel();
        this.localCopyFolderLabel.setCutMode(JComponentUtils.CutMode.MODE_MIDDLE);
    }

    protected void initGUI() {
        this.createComponents();
        this.setLayout(new BorderLayout());
        DescriptionPanel descPanel = new DescriptionPanel("verify.step.options");
        this.add((Component)descPanel, "North");
        JPanel content = this.createContentPanel2();
        this.add((Component)content, "Center");
        SkipStepPanel skipStepPanel = new SkipStepPanel((SkipStepHandler)this);
        skipStepPanel.getSkipStep().setSelected(this.optionsStep.isSaveAsStandard());
        this.add((Component)skipStepPanel, "South");
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        LicenceTyp targetfolderLicence = productFunctions.getLicence("process/verify/options/targetfolder");
        if (!targetfolderLicence.useInProcess()) {
            this.optionsStep.setVerifyReportTargetFolderType(null);
        }
        this.optionsStep.setVerifyOnline(true);
        this.stateChanged(null);
        JComponentUtils.setLookByLicence((JComponent)this, (LicenceTyp)this.optionsStep.getLicenceTyp());
    }

    private JPanel createContentPanel2() {
        LicenceTyp localcopyfolderLicence;
        LicenceTyp targetfolderLicence;
        JPanel methodsPanel = new JPanel(new GridBagLayout());
        methodsPanel = ComponentUtils.setTitledFocusableBorder((JPanel)methodsPanel, (String)Messages.getString((String)"config.dialog.step.options.methods.title"));
        int column = 1;
        int row = 1;
        Insets insetsLeft = new Insets(0, 15, 0, 0);
        methodsPanel.add((Component)this.verifyOnline, new GridBagConstraints(column, row, 1, 1, 1.0, 1.0, 17, 0, insetsLeft, 0, 0));
        methodsPanel.add((Component)this.verifyServerPanel, new GridBagConstraints(++column, row, 2, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        column = 1;
        methodsPanel.add((Component)this.verifyServerError, new GridBagConstraints(column, ++row, 3, 1, 1.0, 1.0, 17, 1, insetsLeft, 0, 0));
        JLabel infoOffline = new JLabel(Messages.getString((String)"step.options.methods.validate.offline"));
        infoOffline.setFocusable(true);
        infoOffline.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)infoOffline));
        methodsPanel.add((Component)infoOffline, new GridBagConstraints(column, ++row, 3, 1, 1.0, 1.0, 17, 1, insetsLeft, 0, 0));
        GridBagPanel targetDirContent = this.createTargetDirContentPanel();
        targetDirContent.setBorder((Border)ComponentUtils.createTitledCurvedBorder((String)"step.options.targetdir"));
        targetDirContent.setFocusable(true);
        GridBagPanel localCopyContent = this.createLocalCopyContentPanel();
        localCopyContent.setBorder((Border)ComponentUtils.createTitledCurvedBorderForTitle((String)Messages.getString((String)"step.selecttargetfolder.localcopy.description.header")));
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        LicenceTyp onlineverifyLicence = productFunctions.getLicence("process/verify/options/onlineverify");
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        if (onlineverifyLicence.isVisible()) {
            content.add((Component)methodsPanel, "North");
            this.verifyOnline.setEnabled(onlineverifyLicence.isEditable());
        }
        if ((targetfolderLicence = productFunctions.getLicence("process/verify/options/targetfolder")).isVisible()) {
            content.add((Component)targetDirContent, "Center");
        }
        if ((localcopyfolderLicence = productFunctions.getLicence("process/verify/options/localcopyfolder")).isVisible()) {
            content.add((Component)localCopyContent, targetfolderLicence.isVisible() ? "South" : "Center");
            if (!localcopyfolderLicence.useInProcess()) {
                this.selectLocalCopyFolderButton.setEnabled(false);
                this.deleteLocalCopyFolderButton.setEnabled(false);
            }
        }
        return content;
    }

    private GridBagPanel createLocalCopyContentPanel() {
        LicenceTyp localcopyfolderLicence = Document.getInstance().getProductFunctions().getLicence("process/verify/options/localcopyfolder");
        GridBagPanel content = new GridBagPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        JComponentUtils.setLookByLicence((JComponent)this.selectLocalCopyFolderButton, (LicenceTyp)localcopyfolderLicence, (JPanel)content, (GridBagConstraints)gbc);
        gbc.gridx = 3;
        JComponentUtils.setLookByLicence((JComponent)this.deleteLocalCopyFolderButton, (LicenceTyp)localcopyfolderLicence, (JPanel)content, (GridBagConstraints)gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        JComponentUtils.setLookByLicence((JComponent)this.localCopyFolderLabel, (LicenceTyp)localcopyfolderLicence, (JPanel)content, (GridBagConstraints)gbc);
        content.setColumnMinWidth(0, 50);
        content.setColumnMinWidth(2, 50);
        content.setRowMinHeight(0, 20);
        content.setRowMinHeight(2, 10);
        content.setRowMinHeight(4, 10);
        content.setRowMinHeight(5, 20);
        return content;
    }

    private GridBagPanel createTargetDirContentPanel() {
        GridBagPanel targetPanel = new GridBagPanel();
        targetPanel.setFocusable(true);
        targetPanel.setBorder((Border)ComponentUtils.createTitledCurvedBorder((String)"step.options.targetdir"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        LicenceTyp targetfolderLicenceTyp = productFunctions.getLicence("process/verify/options/targetfolder");
        JComponentUtils.setLookByLicence((JComponent)this.selectSameAsSourceButton, (LicenceTyp)targetfolderLicenceTyp, (JPanel)targetPanel, (GridBagConstraints)gbc);
        gbc.gridy = 3;
        JComponentUtils.setLookByLicence((JComponent)this.selectSpecialFolderButton, (LicenceTyp)targetfolderLicenceTyp, (JPanel)targetPanel, (GridBagConstraints)gbc);
        gbc.gridy = 5;
        JComponentUtils.setLookByLicence((JComponent)this.specialFolderLabel, (LicenceTyp)targetfolderLicenceTyp, (JPanel)targetPanel, (GridBagConstraints)gbc);
        targetPanel.setColumnMinWidth(0, 50);
        targetPanel.setColumnMinWidth(3, 50);
        targetPanel.setRowMinHeight(0, 20);
        targetPanel.setRowMinHeight(2, 20);
        targetPanel.setRowMinHeight(4, 10);
        targetPanel.setRowMinHeight(5, 20);
        targetPanel.setRowMinHeight(7, 20);
        return targetPanel;
    }

    public void stateChanged(ChangeEvent event) {
        if (this.optionsStep.getForm() != null && this.optionsStep.getVerifyReportTargetFolderType() != null) {
            if (event != null) {
                String localCopyTarget = this.optionsStep.getLocalCopyFolder();
                this.setLocalCopyFolder(localCopyTarget);
            } else {
                this.selectSpecialFolderButton.setSelected(false);
                this.localCopyFolderLabel.setText(null);
            }
            switch (this.optionsStep.getVerifyReportTargetFolderType()) {
                case oneSpecial: {
                    File target = new File(this.optionsStep.getVerifyReportTargetDir());
                    this.setTargetFolder(target.getAbsolutePath());
                    break;
                }
                default: {
                    this.setSameAsSource();
                }
            }
        }
        this.verifyserverProvider.setEnabled(true);
        this.setVerifyServerErrorText();
    }

    private void setVerifyServerErrorText() {
        boolean isVerifyServerSet = ((VerifyConfig)this.optionsStep.getParent().getConfig()).isVerifyServerSet();
        if (!isVerifyServerSet) {
            this.verifyServerError.setFocusable(true);
            this.verifyServerError.setFont(this.errorFont);
            this.verifyServerError.setForeground(SignerTheme.COLOR_RED);
            this.verifyServerError.setText(Messages.getString((String)"step.options.verifyserver.error"));
        } else {
            this.verifyServerError.setFocusable(false);
            this.verifyServerError.setText(Messages.getString((String)"step.options.verifyserver.ok"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public File getLastFolder() {
        String userHome = System.getProperty("user.home");
        String lastUsedDir = this.optionsStep.getApplicationProperties().getProperty("last_folder", null);
        if (lastUsedDir == null) {
            lastUsedDir = userHome;
        }
        return new File(lastUsedDir);
    }

    public void setSameAsSource() {
        this.optionsStep.setVerifyReportTargetFolderType(TargetFolderType.sameAsSourceFolder);
        this.optionsStep.setVerifyReportTargetDir("");
        this.specialFolderLabel.setText("");
        this.selectSameAsSourceButton.setSelected(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.removeAll();
        this.initGUI();
        this.revalidate();
    }

    public SkippableStep getSkippableStep() {
        return this.optionsStep;
    }

    public boolean getSkipStep() {
        return this.optionsStep.skipStep();
    }

    public void setSkipStep(boolean skip) {
        this.optionsStep.skipStep(skip);
    }

    public boolean isStepComplete() {
        return this.optionsStep.isStateComplete();
    }

    public void setActive(boolean active) {
        if (!active) {
            return;
        }
        LOG.debug("set active: {}", (Object)this.optionsStep.getStepName());
        LOG.info("\n---------------- Validieren/Optionen ... ---------------------------");
        TargetFolderType type = this.optionsStep.getVerifyReportTargetFolderType();
        switch (type) {
            case oneSpecial: {
                File targetDir = new File(this.optionsStep.getVerifyReportTargetDir());
                this.setTargetFolder(targetDir.getAbsolutePath());
                break;
            }
            default: {
                this.setSameAsSource();
            }
        }
        LOG.info("\n---------------- Validieren/Optionen : ausgew\u00e4hlt ---------------------------");
    }

    public void setTargetFolder(String targetDir) {
        if (targetDir == null) {
            return;
        }
        this.optionsStep.setVerifyReportTargetFolderType(TargetFolderType.oneSpecial);
        this.optionsStep.setVerifyReportTargetDir(targetDir);
        this.specialFolderLabel.setText(targetDir);
        this.selectSpecialFolderButton.setSelected(true);
        this.selectSpecialFolderButton.setToolTipText(MultiLineTooltips.wrapToolTip((String)targetDir, (int)80));
        this.optionsStep.setApplicationProperty("last_folder", targetDir);
    }

    public void setLocalCopyFolder(String localCopyDir) {
        if (localCopyDir == null) {
            return;
        }
        this.optionsStep.setLocalCopyFolder(localCopyDir);
        this.optionsStep.setApplicationProperty("last_localcopy_folder", localCopyDir);
        this.localCopyFolderLabel.setText(localCopyDir);
    }

    public File getLastLocalCopyFolder() {
        String userHome = System.getProperty("user.home");
        String lastUsedDir = this.optionsStep.getApplicationProperties().getProperty("last_localcopy_folder", null);
        if (lastUsedDir == null) {
            lastUsedDir = userHome;
        }
        return new File(lastUsedDir);
    }

    private KeyListener createKeyAdapterFor(final CurvedToggleIconButton button) {
        button.setFocusTraversalKeysEnabled(false);
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isConsumed()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 9: {
                        if (keyEvent.isShiftDown()) {
                            button.getParent().transferFocusBackward();
                            keyEvent.consume();
                            break;
                        }
                        if (OptionsView.this.selectSameAsSourceButton.hasFocus()) {
                            OptionsView.this.selectSpecialFolderButton.requestFocus();
                            OptionsView.this.selectSpecialFolderButton.transferFocus();
                            keyEvent.consume();
                            break;
                        }
                        button.transferFocus();
                        keyEvent.consume();
                        break;
                    }
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        if (OptionsView.this.selectSameAsSourceButton.hasFocus()) {
                            OptionsView.this.selectSpecialFolderButton.requestFocus();
                            keyEvent.consume();
                            break;
                        }
                        OptionsView.this.selectSameAsSourceButton.requestFocus();
                        keyEvent.consume();
                        break;
                    }
                }
            }
        };
    }

    private class ProviderConfigureAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private ProviderConfigureAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            actionEvent.setSource(OptionsView.this.optionsStep.getParent().getProcessName());
            Document.getInstance().getActionFactory().getConfigureAction().actionPerformed(actionEvent);
        }
    }
}

