/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.verify.gui.dialog.config.components;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.SelectedCertificateHandler;
import de.bos_bremen.ecard.client.action.SelectedFileHandler;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.components.ServerPanel;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VerifyServerPanel
extends ServerPanel {
    private IconButton showDefaultCertificateButton;
    private Certificate defaultCertificate;
    private IconButton showCertificateButton;
    private Certificate alternativeCertificate;
    private static final String NO_CERTIFICATE_LOADED = "Kein Zertifikat geladen";

    public VerifyServerPanel(LicenceTyp licenceTyp) {
        super(licenceTyp);
    }

    protected void addAdditionalContent() {
        LOG.trace("");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel defaultCertLabel = new JLabel(Messages.getString((String)"config.dialog.verificationserver.certificate"));
        defaultCertLabel.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)defaultCertLabel));
        defaultCertLabel.setFocusable(true);
        this.showDefaultCertificateButton = new IconButton();
        this.showDefaultCertificateButton.setAction((Action)Document.getInstance().getActionFactory().createShowCertificateAction((SelectedCertificateHandler)new DefaultSelectedCertificate()));
        this.showDefaultCertificateButton.setEnabled(false);
        IconButton chooseDefaultCertificateButton = new IconButton();
        chooseDefaultCertificateButton.setAction((Action)Document.getInstance().getActionFactory().createLoadSoftwareKeyStore((SelectedFileHandler)new DefaultSelectedFile(), false, true));
        Insets insets = new Insets(5, 5, 5, 5);
        int column = 0;
        int row = 0;
        panel.add((Component)defaultCertLabel, new GridBagConstraints(column, row, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        panel.add((Component)this.showDefaultCertificateButton, new GridBagConstraints(column + 1, row, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        panel.add((Component)chooseDefaultCertificateButton, new GridBagConstraints(column + 2, row, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        JLabel cert2Label = new JLabel(Messages.getString((String)"config.dialog.verificationserver.certificate2"));
        cert2Label.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)cert2Label));
        cert2Label.setFocusable(true);
        this.showCertificateButton = new IconButton();
        this.showCertificateButton.setAction((Action)Document.getInstance().getActionFactory().createShowCertificateAction((SelectedCertificateHandler)new SelectedCertificate()));
        this.showCertificateButton.setEnabled(false);
        IconButton chooseCertificateButton = new IconButton();
        chooseCertificateButton.setAction((Action)Document.getInstance().getActionFactory().createLoadSoftwareKeyStore((SelectedFileHandler)new SelectedFile(), false, true));
        column = 0;
        row = 1;
        panel.add((Component)cert2Label, new GridBagConstraints(column, row, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        panel.add((Component)this.showCertificateButton, new GridBagConstraints(column + 1, row, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        panel.add((Component)chooseCertificateButton, new GridBagConstraints(column + 2, row, 1, 1, 1.0, 0.0, 10, 0, insets, 0, 0));
        JLabel chooseDescription = JComponentUtils.createLabel((String)"config.dialog.verificationserver.choosecertificate.label");
        chooseDescription.setFocusable(true);
        chooseDescription.setText("<html>" + chooseDescription.getText() + "</html>");
        chooseDescription.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)chooseDescription));
        Insets insetsLeftRight = new Insets(5, 20, 5, 20);
        this.content.add((Component)chooseDescription, new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 17, 2, insetsLeftRight, 0, 0));
        this.content.add((Component)panel, new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 17, 2, insetsLeftRight, 0, 0));
    }

    public String getDefaultCertificate() {
        LOG.trace("CVS-View -> aktuell gueltiges Zertifikat");
        if (this.defaultCertificate == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(this.defaultCertificate.getEncoded());
    }

    public String getAlternativeCertificate() {
        LOG.trace("CVS-View -> alternatives Zertifikat");
        if (this.alternativeCertificate == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(this.alternativeCertificate.getEncoded());
    }

    public void setDefaultCertificate(String certBase64) {
        LOG.trace("CVS-View <- aktuel gueltiges Zertifikat");
        if (certBase64 == null || certBase64.trim().isEmpty()) {
            this.defaultCertificate = null;
            return;
        }
        try {
            certBase64 = certBase64.replaceAll("[\r\n]", "");
            this.defaultCertificate = this.loadCertificateAsBase64DERFormat(this.showDefaultCertificateButton, new ByteArrayInputStream(Base64.getDecoder().decode(certBase64)));
        }
        catch (ParseException e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    public void setAlternativeCertificate(String certBase64) {
        LOG.trace("CVS-View <- alternatives Zertifikat");
        if (certBase64 == null || certBase64.trim().isEmpty()) {
            this.alternativeCertificate = null;
            return;
        }
        try {
            this.alternativeCertificate = this.loadCertificateAsBase64DERFormat(this.showCertificateButton, new ByteArrayInputStream(Base64.getDecoder().decode(certBase64)));
        }
        catch (ParseException e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    private Certificate loadCertificateAsBase64DERFormat(IconButton iconButton, InputStream inS) throws ParseException {
        try {
            if (inS != null) {
                Certificate certificate = new Certificate(inS);
                iconButton.setText(certificate.getSubjectCommonName());
                iconButton.setEnabled(true);
                return certificate;
            }
        }
        catch (Exception e) {
            iconButton.setText(NO_CERTIFICATE_LOADED);
            iconButton.setEnabled(false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate loadCertificateBASE64FormatAsBase64(IconButton iconButton, InputStream inS) throws ParseException {
        try {
            if (inS != null) {
                X509Certificate generateCertificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(inS);
                this.alternativeCertificate = new Certificate((Source)new BSource(generateCertificate.getEncoded()));
                iconButton.setText(this.alternativeCertificate.getSubjectCommonName());
                iconButton.setEnabled(true);
                Certificate certificate = this.alternativeCertificate;
                return certificate;
            }
        }
        catch (CertificateException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        finally {
            if (this.alternativeCertificate == null) {
                iconButton.setText(NO_CERTIFICATE_LOADED);
                iconButton.setEnabled(false);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Certificate loadCertificateAsBase64(IconButton iconButton, File inCertificateFile) {
        FileInputStream inS;
        if (inCertificateFile == null) {
            return null;
        }
        try {
            inS = new FileInputStream(inCertificateFile);
            try {
                Certificate result = this.loadCertificateAsBase64DERFormat(iconButton, inS);
                if (result != null) {
                    Certificate certificate2 = result;
                    return certificate2;
                }
            }
            finally {
                ((InputStream)inS).close();
            }
        }
        catch (ParseException | IOException ex) {
            LOG.error(ex.getMessage());
        }
        try {
            inS = new FileInputStream(inCertificateFile);
            try {
                Certificate certificate = this.loadCertificateBASE64FormatAsBase64(iconButton, inS);
                return certificate;
            }
            finally {
                ((InputStream)inS).close();
            }
        }
        catch (ParseException | IOException ex) {
            LOG.error(ex.getMessage());
            return null;
        }
    }

    class DefaultSelectedCertificate
    implements SelectedCertificateHandler {
        DefaultSelectedCertificate() {
        }

        public KeyProvider getSelectedKeyProvider() {
            return null;
        }

        public FlatCertificate getSelectedCertificate() {
            return VerifyServerPanel.this.defaultCertificate;
        }

        public KeyUsage getKeyUsage() {
            return KeyUsage.VERIFY;
        }
    }

    class DefaultSelectedFile
    implements SelectedFileHandler {
        DefaultSelectedFile() {
        }

        public void setFileToLoad(File fileToLoad) {
            VerifyServerPanel.this.defaultCertificate = VerifyServerPanel.this.loadCertificateAsBase64(VerifyServerPanel.this.showDefaultCertificateButton, fileToLoad);
        }

        public void setFilesToLoad(File[] filesToLoad) {
        }

        public File getLastFolder() {
            return null;
        }
    }

    class SelectedCertificate
    implements SelectedCertificateHandler {
        SelectedCertificate() {
        }

        public KeyProvider getSelectedKeyProvider() {
            return null;
        }

        public FlatCertificate getSelectedCertificate() {
            return VerifyServerPanel.this.alternativeCertificate;
        }

        public KeyUsage getKeyUsage() {
            return KeyUsage.VERIFY;
        }
    }

    class SelectedFile
    implements SelectedFileHandler {
        SelectedFile() {
        }

        public void setFileToLoad(File fileToLoad) {
            VerifyServerPanel.this.alternativeCertificate = VerifyServerPanel.this.loadCertificateAsBase64(VerifyServerPanel.this.showCertificateButton, fileToLoad);
        }

        public void setFilesToLoad(File[] filesToLoad) {
        }

        public File getLastFolder() {
            return null;
        }
    }
}

