/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.verify.gui.dialog.config.components;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.buttons.AccessibleRadioButton;
import de.bos_bremen.ecard.client.gui.view.component.label.AccessibleJLabel;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import de.governikus.csl.VerifyProtocolType;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyProtocolPanel
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VerifyProtocolPanel.class);
    private AccessibleRadioButton htmlProtocolTypeCheckBox;
    private AccessibleRadioButton pdfProtocolTypeCheckBox;
    private AccessibleRadioButton xmlProtocolTypeCheckBox;
    private Component protocolTypeLabel;
    private JCheckBox useSuffixCheckBox;
    private static final long serialVersionUID = -8423098621254713057L;

    public VerifyProtocolPanel() {
        log.trace("");
        this.initComponents();
        this.initGUI();
    }

    private void initComponents() {
        log.trace("");
        this.protocolTypeLabel = new AccessibleJLabel(Messages.getString((String)"config.dialog.verificationserver.protocol.message") + ":");
        this.htmlProtocolTypeCheckBox = new AccessibleRadioButton("HTML");
        this.htmlProtocolTypeCheckBox.setSelected(true);
        this.pdfProtocolTypeCheckBox = new AccessibleRadioButton("PDF");
        this.xmlProtocolTypeCheckBox = new AccessibleRadioButton("XML");
        this.htmlProtocolTypeCheckBox.addChangeListener(this.createChangeListener());
        this.pdfProtocolTypeCheckBox.addChangeListener(this.createChangeListener());
        this.xmlProtocolTypeCheckBox.addChangeListener(this.createChangeListener());
        String licenceTypKey = "process/verify/options/protocoltype";
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        LicenceTyp pdfLicenceType = productFunctions.getLicence(licenceTypKey + "/pdf");
        LicenceTyp htmlLicenceType = productFunctions.getLicence(licenceTypKey + "/html");
        LicenceTyp xmlLicenceType = productFunctions.getLicence(licenceTypKey + "/xml");
        JComponentUtils.setLookByLicence((JComponent)this.htmlProtocolTypeCheckBox, (LicenceTyp)htmlLicenceType);
        JComponentUtils.setLookByLicence((JComponent)this.pdfProtocolTypeCheckBox, (LicenceTyp)pdfLicenceType);
        JComponentUtils.setLookByLicence((JComponent)this.xmlProtocolTypeCheckBox, (LicenceTyp)xmlLicenceType);
        this.useSuffixCheckBox = new JCheckBox(this.getSuffixCheckBoxText());
        this.useSuffixCheckBox.getModel().setSelected(false);
        licenceTypKey = "process/verify/options/use_protocoll_suffix";
        LicenceTyp protocollSuffixType = productFunctions.getLicence(licenceTypKey);
        log.info("licence: process/verify/options/use_protocoll_suffix = {}", (Object)protocollSuffixType.name());
    }

    private ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() == null) {
                    return;
                }
                Object object = e.getSource();
                if (!(object instanceof AccessibleRadioButton)) {
                    return;
                }
                AccessibleRadioButton rButton = (AccessibleRadioButton)object;
                if (rButton.getModel().isSelected()) {
                    VerifyProtocolPanel.this.useSuffixCheckBox.setText(VerifyProtocolPanel.this.getSuffixCheckBoxText());
                    VerifyProtocolPanel.this.useSuffixCheckBox.repaint();
                }
            }
        };
    }

    private void initGUI() {
        log.trace("");
        ComponentUtils.setTitledFocusableBorder((JPanel)this, (String)Messages.getString((String)"config.dialog.verificationserver.protocol.title"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        int column = 0;
        this.add(this.protocolTypeLabel, new GridBagConstraints(column, row, 1, 1, 1.0, 0.0, 21, 0, new Insets(5, 20, 10, 5), 0, 0));
        ++row;
        JPanel protocolTypePanel = new JPanel(new FlowLayout(0, 25, 0));
        protocolTypePanel.add((Component)this.htmlProtocolTypeCheckBox);
        protocolTypePanel.add((Component)this.pdfProtocolTypeCheckBox);
        protocolTypePanel.add((Component)this.xmlProtocolTypeCheckBox);
        this.add((Component)protocolTypePanel, new GridBagConstraints(column, row, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.htmlProtocolTypeCheckBox);
        bg.add((AbstractButton)this.pdfProtocolTypeCheckBox);
        bg.add((AbstractButton)this.xmlProtocolTypeCheckBox);
        JPanel protocolSuffixPanel = ComponentUtils.layoutCheckbox((JCheckBox)this.useSuffixCheckBox, (JPanel)new JPanel(new FlowLayout(0, 25, 0)));
        this.add((Component)protocolSuffixPanel, new GridBagConstraints(column, ++row, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
    }

    public VerifyProtocolType getVerifyProtocolType() {
        log.trace("CVS-View -> Protokolltype ...");
        if (this.pdfProtocolTypeCheckBox.isSelected()) {
            return VerifyProtocolType.pdf;
        }
        if (this.xmlProtocolTypeCheckBox.isSelected()) {
            return VerifyProtocolType.xml;
        }
        return VerifyProtocolType.html;
    }

    public void setVerifyProtocolType(VerifyProtocolType verifyProtocolType) {
        log.trace("CVS-View <- Protokolltype : {}", (Object)verifyProtocolType);
        if (verifyProtocolType == null) {
            this.htmlProtocolTypeCheckBox.setSelected(true);
            return;
        }
        switch (verifyProtocolType) {
            case pdf: {
                this.pdfProtocolTypeCheckBox.setSelected(true);
                break;
            }
            case xml: {
                this.xmlProtocolTypeCheckBox.setSelected(true);
                break;
            }
            default: {
                this.htmlProtocolTypeCheckBox.setSelected(true);
            }
        }
    }

    public void setUseSpecialProtocolSuffix(boolean useSuffix) {
        this.useSuffixCheckBox.getModel().setSelected(useSuffix);
    }

    public boolean isUseSpecialProtocollSuffix() {
        return this.useSuffixCheckBox.getModel().isSelected();
    }

    private String getSuffixCheckBoxText() {
        return MessageFormat.format(Messages.getString((String)"config.dialog.verificationserver.protocol.suffix"), "_validation-protocol.", this.getVerifyProtocolType().name());
    }
}

