/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.verify.gui.dialog.config.components;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ProcessConfigComponent;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.verify.control.process.impl.VerifyConfig;
import de.bos_bremen.ecard.client.verify.gui.dialog.config.components.VerifyProtocolPanel;
import de.bos_bremen.ecard.client.verify.gui.dialog.config.components.VerifyServerPanel;
import de.governikus.csl.VerifyProtocolType;
import de.governikus.csl.server.CertificateValidationServer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateValidationServerConfig
extends ProcessConfigComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateValidationServerConfig.class);
    private JPanel content;
    private final ProcessI process;
    private LicenceTyp licenceTyp = null;
    private LicenceTyp serverLicenceTyp = null;
    private LicenceTyp protocolTypeLicenceTyp = null;
    private VerifyServerPanel verifyServerPanel;
    private VerifyProtocolPanel verifyProtocolPanel;

    public CertificateValidationServerConfig(ProcessI process, LicenceTyp licenceTyp, LicenceTyp serverLicenceTyp, LicenceTyp protocolTypeLicenceTyp) {
        log.trace("");
        this.process = process;
        this.licenceTyp = licenceTyp;
        this.serverLicenceTyp = serverLicenceTyp;
        this.protocolTypeLicenceTyp = protocolTypeLicenceTyp;
        this.initContent();
        this.initGUI();
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)((Object)this));
    }

    protected void initContent() {
        this.content = new JPanel();
        this.content.setLayout(new BorderLayout());
    }

    private void initGUI() {
        log.trace("init {} ...", (Object)this.getTitle());
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 10, 5);
        JComponentUtils.setLookByLicence((JComponent)this.createProtocolTypePanel(), (LicenceTyp)this.protocolTypeLicenceTyp, (JPanel)p, (GridBagConstraints)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, insets, 0, 0));
        JComponentUtils.setLookByLicence((JComponent)this.createVerifyServerPanel(), (LicenceTyp)this.serverLicenceTyp, (JPanel)p, (GridBagConstraints)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, insets, 0, 0));
        this.content.add((Component)p, "North");
    }

    private JPanel createVerifyServerPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.verifyServerPanel = new VerifyServerPanel(this.serverLicenceTyp);
        panel.add(this.verifyServerPanel.getView());
        return panel;
    }

    private JPanel createProtocolTypePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.verifyProtocolPanel = new VerifyProtocolPanel();
        panel.add(this.verifyProtocolPanel);
        return panel;
    }

    public JPanel getView() {
        return this.content;
    }

    public VerifyProtocolType getVerifyProtocolType() {
        return this.verifyProtocolPanel.getVerifyProtocolType();
    }

    public void setVerifyProtocolType(VerifyProtocolType verifyProtocolType) {
        this.verifyProtocolPanel.setVerifyProtocolType(verifyProtocolType);
    }

    public String getVerifyServerHost() {
        return this.verifyServerPanel.getServerHost();
    }

    public void setVerifyServerHost(String host) {
        this.verifyServerPanel.setServerHost(host);
    }

    public String getVerifyServerDefaultCertificate() {
        return this.verifyServerPanel.getDefaultCertificate();
    }

    public String getVerifyServerAlternativeCertificate() {
        return this.verifyServerPanel.getAlternativeCertificate();
    }

    public void setVerifyServerDefaultCertificate(String certBase64) {
        this.verifyServerPanel.setDefaultCertificate(certBase64);
    }

    public void setVerifyServerCertificate(String certBase64) {
        this.verifyServerPanel.setAlternativeCertificate(certBase64);
    }

    public String getHelpContext() {
        return Messages.getResource((String)"config.dialog.verificationserver.helpcontext");
    }

    public Icon getIcon() {
        return ComponentUtils.getIcon((String)"config.dialog.server");
    }

    public String getTitle() {
        return Messages.getString((String)"config.dialog.verificationserver");
    }

    public void load() {
        log.trace("load VerifyConfig -> CVS-View {} ...", (Object)this.getTitle());
        VerifyConfig verifyConfig = (VerifyConfig)this.process.getConfig();
        this.setValidationServiceInView(verifyConfig.getCertificateValidationServer());
    }

    public void save() {
        log.trace("save CVS-View {} -> VerifyConfig ...", (Object)this.getTitle());
        VerifyConfig verifyConfig = (VerifyConfig)this.process.getConfig();
        verifyConfig.setValidationService(this.getValidationServiceFromView());
    }

    public LicenceTyp getLicenceTyp() {
        return this.licenceTyp;
    }

    public void setLicenceTyp(LicenceTyp licenceTyp) {
        this.licenceTyp = licenceTyp;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        log.trace("event source : {}", evt.getSource());
        this.content.removeAll();
        this.initGUI();
        this.content.revalidate();
    }

    private void setValidationServiceInView(CertificateValidationServer cvs) {
        log.trace("CVS-View {} <- CVS-Model", (Object)this.getTitle());
        this.verifyServerPanel.setServerHost(cvs.getUrl());
        this.verifyServerPanel.setDefaultCertificate(cvs.getDefaultCertificateBase64());
        this.verifyServerPanel.setAlternativeCertificate(cvs.getCertificateBase64());
        this.verifyProtocolPanel.setVerifyProtocolType(cvs.getVerifyProtocolType());
        this.verifyProtocolPanel.setUseSpecialProtocolSuffix(cvs.isUseSpecialProtocolSuffix());
    }

    private CertificateValidationServer getValidationServiceFromView() {
        log.trace("CVS-View {} -> CVS-Model", (Object)this.getTitle());
        CertificateValidationServer service = new CertificateValidationServer();
        service.setUrl(this.verifyServerPanel.getServerHost());
        service.setDefaultCertificateBase64(this.verifyServerPanel.getDefaultCertificate());
        service.setCertificateBase64(this.verifyServerPanel.getAlternativeCertificate());
        service.setVerifyProtocolType(this.verifyProtocolPanel.getVerifyProtocolType());
        service.setUseSpecialProtocolSuffix(this.verifyProtocolPanel.isUseSpecialProtocollSuffix());
        return service;
    }
}

