/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.verify.gui;

import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import de.bos_bremen.ecard.client.verify.control.process.impl.VerifyProcess;
import de.bos_bremen.ecard.client.verify.model.formular.process.VerifyProcessFormular;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VerifyProcessHelper {
    private static final Logger LOG = LogManager.getLogger(VerifyProcessHelper.class);

    private VerifyProcessHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static ProcessFormular fillVerifyFormular(String[] inputFile, TargetFolderType targetFolderType, String outputFolder, boolean replaceFiles) {
        ProcessFormular processesFormular = null;
        ProcessI process = Document.getInstance().getProcessFactory().getProcess(VerifyProcess.PROCESS_NAME);
        LOG.info("Validierung-Formular ausfuellen...");
        if (process != null && (processesFormular = Document.getInstance().getProcessFactory().getProcessesFormular(process)) instanceof VerifyProcessFormular) {
            VerifyProcessFormular verifyFormular = (VerifyProcessFormular)processesFormular;
            verifyFormular.addBlockRequest();
            ArrayList<File> inputFileList = new ArrayList<File>();
            try {
                VerifyProcessHelper.getInputfiles(inputFile, inputFileList, true);
            }
            catch (SignerException e) {
                LOG.error("", (Throwable)e);
            }
            if (!inputFileList.isEmpty()) {
                verifyFormular.setSelectedFiles(inputFileList, replaceFiles);
            } else if (replaceFiles) {
                verifyFormular.removeAllFiles();
            }
            if (!targetFolderType.equals((Object)TargetFolderType.useDefault)) {
                verifyFormular.setVerifyReportTargetFolderType(TargetFolderType.valueOf((String)targetFolderType.toString()));
            }
            if (!"".equals(outputFolder)) {
                verifyFormular.setVerifyReportTargetFolder(outputFolder);
            }
            verifyFormular.removeBlockRequest();
        }
        LOG.info("Validierung-Formular : {}", processesFormular);
        return processesFormular;
    }

    static List<File> getInputfiles(String[] inputFile, List<File> inOutFileList, boolean openDirectory) throws SignerException {
        for (int i = 0; inputFile != null && i < inputFile.length; ++i) {
            if (inputFile[i].indexOf("://") != -1 && inputFile[i].indexOf("file:") == -1) {
                throw new SignerException(ErrorCode.CANNOT_OPEN_SOURCE, "VerifyProcess can not read web-Locations", null);
            }
            File file = new File(inputFile[i]);
            if (file.isDirectory()) {
                if (openDirectory) {
                    LOG.error("Das Verzeichnis {} wird ausgelesen und allen Inhaltsdateien der Liste hinzugefuegt", (Object)file.getAbsolutePath());
                    File[] dirFiles = file.listFiles();
                    if (dirFiles != null) {
                        if (dirFiles.length == 0) {
                            inOutFileList.add(file);
                            Document.getInstance().reportError(ErrorCode.SOURCE_DIR_EMPTY, false, new Object[]{file.getAbsolutePath()});
                        } else {
                            String[] dirFileNames = new String[dirFiles.length];
                            for (int j = 0; j < dirFiles.length; ++j) {
                                dirFileNames[j] = dirFiles[j].getAbsolutePath();
                            }
                            VerifyProcessHelper.getInputfiles(dirFileNames, inOutFileList, false);
                        }
                    } else {
                        LOG.error("Das Verzeichnis {} hat keine Leseberechtigung", (Object)file.getAbsolutePath());
                        Document.getInstance().reportError(ErrorCode.CANNOT_OPEN_SOURCE, false, new Object[]{file.getAbsolutePath()});
                    }
                } else {
                    LOG.error("Das Verzeichnis {} wird nicht eingebunden, da keine Rekursion unterstuetzt wird.", (Object)file.getAbsolutePath());
                }
            } else {
                inOutFileList.add(file);
            }
            if (file.exists()) continue;
            LOG.error("Die Datei {} existiert nicht und kann daher nicht mit in die Liste uebernommen werden.", (Object)file.getAbsolutePath());
            Document.getInstance().reportError(ErrorCode.FILE_NOT_FOUND, false, new Object[]{file.getAbsolutePath()});
        }
        return inOutFileList;
    }
}

