/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.verify.control.step;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.control.step.WorkingResult;
import de.bos_bremen.ecard.client.control.step.working.WorkingStep;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.ErrorObject;
import de.bos_bremen.ecard.client.model.licence.Licence;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.util.XMLProperties;
import de.bos_bremen.ecard.client.verify.VerifyFunction;
import de.bos_bremen.ecard.client.verify.gui.step.VerifyView;
import de.bos_bremen.ecard.client.verify.model.formular.process.VerifyProcessFormular;
import de.governikus.csl.ECardProgressListener;
import de.governikus.csl.VerifyProtocolType;
import de.governikus.csl.uom.validate.ValidateResponse;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Verify
extends WorkingStep {
    private static final Logger LOG = LogManager.getLogger(Verify.class);

    public Verify() {
        super(StepFactory.StepName.verify);
        LOG.info("");
    }

    public void setJComponent() {
        this.viewPanel = new VerifyView(this);
    }

    public void setDefaults(XMLProperties propertiesForNode) {
        super.setDefaults(propertiesForNode);
        this.notifyAllStateChangeListener(null, propertiesForNode);
    }

    public void run(SubsequentProcess process) {
        LOG.info("------- Start Validieren ... -------");
        this.reset();
        VerifyProcessFormular verifyForm = (VerifyProcessFormular)this.form;
        this.buildWorkingResult();
        Document documentInstance = Document.getInstance();
        if (!this.canMoveToTargetFolder(verifyForm)) {
            this.finished(process, true, documentInstance.getWorkingResults().size());
            return;
        }
        VerifyProtocolType protocolType = VerifyFunction.getProtocolType(this);
        LOG.debug("protocolType: {}", (Object)protocolType);
        String protocolSuffix = VerifyFunction.getProtocolSuffix();
        LOG.debug("protocolSuffix: {}", (Object)protocolSuffix);
        documentInstance.notifyProgressListeners(ECardProgressListener.ProgressType.CALCULATE_HASH_FOR_VERIFICATION, -1);
        List workingResultList = documentInstance.getWorkingResults();
        int errorCounter = 0;
        boolean cancelled = false;
        for (WorkingResult workingResult : workingResultList) {
            documentInstance.resetLastErrorObject();
            if (cancelled) {
                workingResult.setCurrentState(WorkingResult.Status.ABORTED);
                documentInstance.reportError(ErrorCode.FILE_CANCELLED, false, new Object[]{workingResult.getSourceFile()});
                continue;
            }
            if (!this.checkSourceFileBeforeProcess(workingResult, verifyForm.getVerifyReportTargetFolderType())) {
                cancelled = documentInstance.getLastReportedErrorObject().abortError();
                ++errorCounter;
                continue;
            }
            WorkingStep.Repeat currentRepeat = this.canMoveToTargetFolder(verifyForm, workingResult, protocolSuffix);
            if (WorkingStep.Repeat.CANCEL == this.lastRepeat) {
                cancelled = true;
                ++errorCounter;
                continue;
            }
            if (WorkingStep.Repeat.SKIP.equals((Object)currentRepeat) || WorkingStep.Repeat.SKIP_ALL.equals((Object)currentRepeat)) {
                ++errorCounter;
                continue;
            }
            try {
                VerifyFunction.verify(verifyForm, workingResult, protocolType);
                ErrorCode errorCode = this.checkResult(workingResult.getValidateResponse());
                this.setResult(workingResult, errorCode);
            }
            catch (Exception ex) {
                ++errorCounter;
                LOG.error((Object)ex, (Throwable)ex);
                ErrorCode errorCode = ErrorCode.UNKNOWN;
                this.setResult(workingResult, errorCode);
                documentInstance.reportError(errorCode, true, new Object[]{ex.toString()});
                workingResult.setCurrentState(WorkingResult.Status.ERROR);
                cancelled = documentInstance.getLastReportedErrorObject().abortError();
            }
        }
        this.finished(process, cancelled, errorCounter);
        LOG.info("------- Validieren abgeschlossen -------");
    }

    private void setResult(WorkingResult workingResult, ErrorCode errorCode) {
        ErrorObject errorObject = new ErrorObject();
        errorObject.setErrorCode(errorCode);
        errorObject.setErrorMessage(MessageFormat.format(errorObject.getErrorCode().getDescription(), workingResult.getSourceFile().getAbsolutePath()));
        workingResult.setErrorObject(errorObject);
    }

    private ErrorCode checkResult(ValidateResponse response) {
        if (response == null) {
            return ErrorCode.UNKNOWN;
        }
        CumulatedValidationResult result = response.getOverallResult(true);
        if (result == null) {
            return ErrorCode.UNKNOWN;
        }
        return ErrorCode.OK;
    }

    private void reset() {
        this.lastRepeat = null;
        this.fullRepeat = null;
        Document.getInstance().resetLastErrorObject();
    }

    private void finished(SubsequentProcess process, boolean cancelled, int errorCounter) {
        Document documentInstance = Document.getInstance();
        List workingResultList = documentInstance.getWorkingResults();
        documentInstance.notifyProgressListeners(ECardProgressListener.ProgressType.CALCULATE_HASH_FOR_VERIFICATION, 1);
        this.displayFinishDialog(cancelled, errorCounter);
        this.state = WorkingStep.WorkingState.CALLING_SUBSEQUENT_PROCESS;
        if (process != null) {
            super.callSubsequentProcess(process);
        }
        this.state = WorkingStep.WorkingState.FINISHED;
        this.notifyProgressListener(null, workingResultList);
        this.notifyAllStateChangeListener(null, workingResultList);
        LOG.info("Validieren beenden.");
        this.parent.isFinished(true);
    }

    private boolean canMoveToTargetFolder(VerifyProcessFormular verifyFormular) {
        if (verifyFormular.getVerifyReportTargetFolderType() != TargetFolderType.oneSpecial) {
            return true;
        }
        if (Utils.canWrite((String)verifyFormular.getVerifyReportTargetFolder())) {
            return true;
        }
        LOG.trace("");
        Document documentInstance = Document.getInstance();
        documentInstance.reportError(ErrorCode.CANNOT_WRITE_TO_FOLDER, false, new Object[]{verifyFormular.getVerifyReportTargetFolder()});
        List workingResultList = documentInstance.getWorkingResults();
        for (WorkingResult workingResult : workingResultList) {
            workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
            workingResult.setCurrentState(WorkingResult.Status.ERROR);
        }
        return false;
    }

    private WorkingStep.Repeat canMoveToTargetFolder(VerifyProcessFormular verifyFormular, WorkingResult workingResult, String protocolSuffix) {
        Document documentInstance = Document.getInstance();
        LOG.debug("protocolSuffix: {}", (Object)protocolSuffix);
        String resultFileName = workingResult.getSourceFile().getName() + protocolSuffix;
        LOG.debug("Validate ResultFileName: {}", (Object)resultFileName);
        WorkingStep.Repeat currentRepeat = this.canMoveDocumentsToTargetFolder(verifyFormular.getVerifyReportTargetFolderType(), verifyFormular.getVerifyReportTargetFolder(), verifyFormular.getLocalCopyFolder(), (File)workingResult.getSourceFile(), resultFileName, false, true, false);
        LOG.debug("Validate Repeat : {}", (Object)currentRepeat);
        if (WorkingStep.Repeat.CANCEL == currentRepeat || WorkingStep.Repeat.SKIP == currentRepeat || WorkingStep.Repeat.SKIP_ALL == currentRepeat) {
            workingResult.setCurrentState(WorkingResult.Status.ABORTED);
            LOG.trace("reportError...");
            documentInstance.reportError(ErrorCode.FILE_CANCELLED, false, new Object[]{workingResult.getSourceFile()});
        }
        return currentRepeat;
    }

    public SubsequentProcess getDefaultSubsequentProcess() {
        return Config.getInstance().getSubsequentProcess(this.parent.getSubsequentProcessUID());
    }

    public HashMap<String, LicenceTyp> getDefaultLicenceTypes() {
        HashMap<String, LicenceTyp> processLicenceTypes = new HashMap<String, LicenceTyp>();
        processLicenceTypes.put(this.getLicenceTypKey(), LicenceTyp.enable);
        processLicenceTypes.put(Licence.Keys.general_actions_settings_subsequentprocess.toString(), LicenceTyp.enable);
        return processLicenceTypes;
    }
}

