/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.verify.control.step;

import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.formular.steps.SelectSignedFilesFormular;
import de.bos_bremen.ecard.client.model.formular.steps.StepFormular;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.verify.gui.step.SelectFilesView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SelectFiles
extends Step {
    protected SelectSignedFilesFormular formular;

    public SelectFiles() {
        super(StepFactory.StepName.selectfiles);
    }

    public void setJComponent() {
        this.viewPanel = new SelectFilesView(this);
    }

    public List<ProcessSignedFile> getFiles() {
        ArrayList files = null;
        if (this.formular != null) {
            files = this.formular.getSelectedFiles();
        }
        if (files == null) {
            files = new ArrayList();
        }
        return files;
    }

    public void addFile(ProcessSignedFile file) {
        if (file == null) {
            return;
        }
        this.formular.addSelectedFile(file);
    }

    public void addFiles(ProcessSignedFile[] files) {
        if (files == null || files.length == 0) {
            return;
        }
        for (ProcessSignedFile processSignedFile : files) {
            this.formular.addSelectedFile(processSignedFile);
        }
    }

    public boolean removeFile(ProcessSignedFile fileToRemove) {
        return this.formular.removeSelectedFile(fileToRemove);
    }

    public boolean removeAllFiles() {
        if (this.formular == null || this.formular.getSelectedFiles() == null) {
            return false;
        }
        ArrayList filesToRemove = new ArrayList(this.formular.getSelectedFiles());
        for (ProcessSignedFile file : filesToRemove) {
            this.formular.removeSelectedFile(file);
        }
        return true;
    }

    public StepFormular getForm() {
        return this.formular;
    }

    public boolean isStateComplete() {
        return !this.getFiles().isEmpty();
    }

    public void setFileAsSeen(ProcessSignedFile file) {
        try {
            this.formular.setFileAsSeen(file);
        }
        catch (SignerException e) {
            Document.getInstance().reportError(e, false, new Object[0]);
        }
    }

    public boolean setProcessFormular(StepFormular f) {
        if (!(f instanceof SelectSignedFilesFormular)) {
            return false;
        }
        SelectSignedFilesFormular selectSignedFilesFormular = (SelectSignedFilesFormular)f;
        if (!super.setProcessFormular(f)) {
            return false;
        }
        this.formular = selectSignedFilesFormular;
        if (this.formular.getSelectedFiles() != null) {
            this.notifyAllStateChangeListener(this.formular.getSelectedFiles(), null);
        }
        return true;
    }

    public HashMap<String, LicenceTyp> getDefaultLicenceTypes() {
        HashMap<String, LicenceTyp> processLicenceTypes = new HashMap<String, LicenceTyp>();
        processLicenceTypes.put(this.getLicenceTypKey(), LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/addfiles", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/removefiles", LicenceTyp.enable);
        return processLicenceTypes;
    }
}

