/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.verify.control.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.step.SkippableStep;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.formular.steps.StepFormular;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.verify.control.process.impl.VerifyConfig;
import de.bos_bremen.ecard.client.verify.gui.step.OptionsView;
import de.bos_bremen.ecard.client.verify.model.formular.process.impl.VerifyFormular;
import de.bos_bremen.ecard.client.verify.model.formular.steps.VerifyOptionFormular;
import java.io.File;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Options
extends SkippableStep {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Options.class);
    private static final String VERIFY_REPORT_TARGET_DIR_KEY = "verifyReportTargetDir";
    private static final String VERIFY_REPORT_TARGET_FOLDER_TYPE_KEY = "verifyReportTargetFolderType";
    private static final String LOCALCOPY_FOLDER_KEY = "last_localcopy_folder.path";
    private static final String IS_SAVE_AS_STANDARD_PROPERTY = "isSaveAsStandardProperty";

    public Options() {
        super(StepFactory.StepName.options);
    }

    public void setJComponent() {
        this.viewPanel = new OptionsView(this);
    }

    public boolean verifyOnline() {
        return true;
    }

    public void setVerifyOnline(boolean isVerifyOnline) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof VerifyOptionFormular) {
            VerifyOptionFormular verifyOptionFormular = (VerifyOptionFormular)stepFormular;
            verifyOptionFormular.setVerifyOnline(true);
        }
    }

    public String getVerifyReportTargetDir() {
        String verifyReportTargetDir = null;
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof VerifyOptionFormular) {
            VerifyOptionFormular verifyOptionFormular = (VerifyOptionFormular)stepFormular;
            verifyReportTargetDir = verifyOptionFormular.getVerifyReportTargetFolder();
        }
        if (verifyReportTargetDir == null) {
            verifyReportTargetDir = this.stepProperties.getProperty(VERIFY_REPORT_TARGET_DIR_KEY);
        }
        return verifyReportTargetDir;
    }

    public void setVerifyReportTargetDir(String verifyReportTargetDir) {
        this.stepProperties.setProperty(VERIFY_REPORT_TARGET_DIR_KEY, verifyReportTargetDir);
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof VerifyOptionFormular) {
            VerifyOptionFormular verifyOptionFormular = (VerifyOptionFormular)stepFormular;
            verifyOptionFormular.setVerifyReportTargetFolder(verifyReportTargetDir);
        }
    }

    public TargetFolderType getVerifyReportTargetFolderType() {
        TargetFolderType verifyReportTargetFolderType = null;
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof VerifyOptionFormular) {
            VerifyOptionFormular verifyOptionFormular = (VerifyOptionFormular)stepFormular;
            verifyReportTargetFolderType = verifyOptionFormular.getVerifyReportTargetFolderType();
        }
        if (verifyReportTargetFolderType == null) {
            verifyReportTargetFolderType = TargetFolderType.valueOf((String)this.stepProperties.getProperty(VERIFY_REPORT_TARGET_FOLDER_TYPE_KEY, TargetFolderType.sameAsSourceFolder.toString()));
        }
        return verifyReportTargetFolderType;
    }

    public void setVerifyReportTargetFolderType(TargetFolderType targetFolderType) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof VerifyOptionFormular) {
            VerifyOptionFormular verifyOptionFormular = (VerifyOptionFormular)stepFormular;
            verifyOptionFormular.setVerifyReportTargetFolderType(targetFolderType);
        }
        this.stepProperties.put((Object)VERIFY_REPORT_TARGET_FOLDER_TYPE_KEY, (Object)(targetFolderType != null ? targetFolderType.toString() : TargetFolderType.sameAsSourceFolder.toString()));
    }

    public boolean setProcessFormular(StepFormular form) {
        if (!(form instanceof VerifyOptionFormular)) {
            return false;
        }
        if (!super.setProcessFormular(form)) {
            return false;
        }
        this.form = form;
        VerifyOptionFormular verifyOptionFormular = (VerifyOptionFormular)this.form;
        if (verifyOptionFormular.getVerifyReportTargetFolder() == null) {
            String folderStr = this.stepProperties.getProperty(VERIFY_REPORT_TARGET_DIR_KEY);
            verifyOptionFormular.setVerifyReportTargetFolder(folderStr);
            String folderTypeStr = this.stepProperties.getProperty(VERIFY_REPORT_TARGET_FOLDER_TYPE_KEY);
            if (folderTypeStr != null) {
                verifyOptionFormular.setVerifyReportTargetFolderType(TargetFolderType.valueOf((String)folderTypeStr));
            } else {
                verifyOptionFormular.setVerifyReportTargetFolderType(TargetFolderType.sameAsSourceFolder);
            }
        }
        verifyOptionFormular.setVerifyOnline(true);
        return true;
    }

    public boolean isStateComplete() {
        return this.checkTargetFolderSettings();
    }

    private boolean checkServerSettings() {
        boolean onlineOK = false;
        if (Document.getInstance().getProductFunctions().getLicence(this.getLicenceTypKey() + "/onlineverify").useInProcess()) {
            VerifyConfig config = (VerifyConfig)this.getParent().getConfig();
            onlineOK = config.isVerifyServerSet();
        } else {
            onlineOK = true;
        }
        return onlineOK;
    }

    private boolean checkTargetFolderSettings() {
        TargetFolderType typ = this.getVerifyReportTargetFolderType();
        if (typ == TargetFolderType.sameAsSourceFolder) {
            return true;
        }
        if (typ == TargetFolderType.oneSpecial) {
            String path = this.getVerifyReportTargetDir();
            return path != null && new File(path).exists();
        }
        return false;
    }

    public String getInCompleteDetails() {
        if (this.isStateComplete()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean firstEntry = true;
        if (!this.checkTargetFolderSettings()) {
            stringBuilder.append(Messages.getString((String)(StepFactory.StepName.selecttargetfolder.getName() + ".incomplete.tooltip")));
            firstEntry = false;
        }
        if (!this.checkServerSettings()) {
            if (!firstEntry) {
                stringBuilder.append("<br/>");
            }
            stringBuilder.append(Messages.getString((String)(StepFactory.StepName.options.getName() + ".incomplete.tooltip")));
        }
        log.trace(stringBuilder.toString());
        return stringBuilder.toString();
    }

    public HashMap<String, LicenceTyp> getDefaultLicenceTypes() {
        HashMap<String, LicenceTyp> processLicenceTypes = new HashMap<String, LicenceTyp>();
        processLicenceTypes.put(this.getLicenceTypKey(), LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/onlineverify", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/targetfolder", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/localcopyfolder", LicenceTyp.hide_disable);
        return processLicenceTypes;
    }

    public boolean setLocalCopyFolder(String targetFolder) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof VerifyFormular) {
            VerifyFormular verifyFormular = (VerifyFormular)stepFormular;
            verifyFormular.setLocalCopyFolder(targetFolder);
            this.stepProperties.setProperty(LOCALCOPY_FOLDER_KEY, targetFolder != null ? targetFolder : "");
            return true;
        }
        return false;
    }

    public String getLocalCopyFolder() {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof VerifyFormular) {
            VerifyFormular verifyFormular = (VerifyFormular)stepFormular;
            return verifyFormular.getLocalCopyFolder();
        }
        return null;
    }

    public boolean isSaveAsStandard() {
        String saveAsStandard = this.stepProperties.getProperty(IS_SAVE_AS_STANDARD_PROPERTY, Boolean.FALSE.toString());
        return Boolean.valueOf(saveAsStandard);
    }
}

