/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.verify.control.process.impl;

import de.bos_bremen.ecard.client.control.process.ProcessConfigI;
import de.bos_bremen.ecard.client.util.XMLProperties;
import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.VerifyProtocolType;
import de.governikus.csl.server.AuthService;
import de.governikus.csl.server.BNotK;
import de.governikus.csl.server.CertificateValidationServer;
import de.governikus.csl.server.ProxyServer;
import de.governikus.csl.server.SignService;
import de.governikus.csl.server.TimestampService;
import java.util.Properties;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyConfig
implements ProcessConfigI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VerifyConfig.class);
    private static final org.apache.logging.log4j.Logger LOG = LogManager.getLogger(VerifyConfig.class);
    private CertificateValidationServer cvs = new CertificateValidationServer();

    public void load(XMLProperties props) {
        LOG.info("load root/process/verify");
        LOG.trace((Object)props);
        if (props == null) {
            LOG.info("Keine XML root/process/verify zum Laden gegeben.");
            return;
        }
        if (props.isEmpty()) {
            LOG.info("XML root/process/verify ist leer -> CVS ueberschreiben");
        }
        LOG.info("");
        this.cvs = new CertificateValidationServer(props);
        LOG.trace("ValidationProcessor beim Start : set CVS");
        SignerValidationProcessor.getInstance().setServer(this.cvs);
        log.trace("VerifyConfig        <- Model-CVS...");
        log.trace("ValidationProcessor <- Model-CVS : {}", (Object)this.cvs);
    }

    public void store(XMLProperties props) {
        LOG.info("store root/process/verify");
        log.trace("Model-CVS -> XMLProperties: {}", (Object)props);
        XMLProperties verifyServerProperties = new XMLProperties();
        verifyServerProperties.setProperty("url", this.cvs.getUrl() == null ? "" : this.cvs.getUrl());
        verifyServerProperties.setProperty("certificate", this.cvs.getDefaultCertificateBase64() == null ? "" : this.cvs.getDefaultCertificateBase64());
        verifyServerProperties.setProperty("certificate2", this.cvs.getCertificateBase64() == null ? "" : this.cvs.getCertificateBase64());
        props.addAll("verificationserver", (Properties)verifyServerProperties);
        props.setProperty("protocoltype", this.cvs.getVerifyProtocolType().name());
        props.setProperty("useSpecialProtocolSuffix", String.valueOf(this.cvs.isUseSpecialProtocolSuffix()));
    }

    public CertificateValidationServer getCertificateValidationServer() {
        log.trace("Model-CVS -> {}", (Object)this.cvs);
        return this.cvs;
    }

    public void setValidationService(CertificateValidationServer validationService) {
        log.trace("VerifyConfig        <- Model-CVS...");
        log.trace("ValidationProcessor <- Model-CVS : {}", (Object)validationService);
        this.cvs = validationService;
        SignerValidationProcessor oldInstance = SignerValidationProcessor.getInstance();
        BNotK bnotk = oldInstance.getBNotK();
        AuthService authService = oldInstance.getAuthService();
        SignService sService = oldInstance.getSignService();
        TimestampService tsService = oldInstance.getTimestampService();
        SignerValidationProcessor processorNew = SignerValidationProcessor.resetInstance();
        processorNew.setBNotK(bnotk);
        processorNew.setAuthService(authService);
        processorNew.setSignService(sService);
        processorNew.setTimestampService(tsService);
        ProxyServer ps = processorNew.getProxyConfiguration();
        ps.evalAutoConfigUrl(this.cvs.getUrl());
        processorNew.setProxyServer(ps);
        processorNew.setServer(this.cvs);
    }

    public boolean isVerifyServerSet() {
        return this.cvs.isConfigComplete();
    }

    public VerifyProtocolType getVerifyProtocolType() {
        return this.cvs.getVerifyProtocolType();
    }
}

