/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.verify;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.step.WorkingResult;
import de.bos_bremen.ecard.client.control.step.working.WorkingStep;
import de.bos_bremen.ecard.client.gui.dialog.ConnectServerWaitWindow;
import de.bos_bremen.ecard.client.gui.dialog.VerifyTimeDialog;
import de.bos_bremen.ecard.client.gui.dialog.WaitWindow;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.model.PropertyHashedFile;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.ErrorObject;
import de.bos_bremen.ecard.client.verify.control.process.impl.VerifyConfig;
import de.bos_bremen.ecard.client.verify.model.formular.process.VerifyProcessFormular;
import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.VerifyProtocolType;
import de.governikus.csl.inspect.fo.InspectionSheetPDF;
import de.governikus.csl.inspect.html.InspectionSheetHTMLAccordeon;
import de.governikus.csl.request.ValidationOptions;
import de.governikus.csl.request.ValidationRequest;
import de.governikus.csl.server.CertificateValidationServer;
import de.governikus.csl.setup.validation.ValidationProcessorSetup;
import de.governikus.csl.sig_val_report.SignatureValidationReportOutput;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Options;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.core.impl.SimpleSignedData;
import de.governikus.csl.uom.impl.FileDocumentImpl;
import de.governikus.csl.uom.output.LayoutException;
import de.governikus.csl.uom.output.OutputPlugin;
import de.governikus.csl.uom.validate.ValidateProcessor;
import de.governikus.csl.uom.validate.ValidateRequest;
import de.governikus.csl.uom.validate.ValidateResponse;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.PAdESDocumentValidationResult;
import de.governikus.gcf.csl.report.AllSignaturesCheck;
import de.governikus.gcf.csl.report.WholeDocumentSignedCheck;
import java.awt.Component;
import java.awt.Frame;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VerifyFunction {
    private static final Logger LOG = LogManager.getLogger(VerifyFunction.class);

    private VerifyFunction() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verify(VerifyProcessFormular verifyForm, WorkingResult workingResult, VerifyProtocolType protocolType) throws CoreException, IOException, LayoutException {
        workingResult.setCurrentState(WorkingResult.Status.WORKING);
        ConnectServerWaitWindow waitWindow = null;
        waitWindow = new ConnectServerWaitWindow((Component)de.bos_bremen.ecard.client.model.Document.getInstance().getFrame());
        waitWindow.showWindow();
        try {
            File signatureFile = workingResult.getSourceFile().getAbsoluteFile();
            File contentFile = workingResult.getSourceFile().getDetachedFile();
            LOG.info("signatureFile: {}", (Object)signatureFile);
            LOG.info("contentFile: {}", (Object)contentFile);
            ValidationRequest request = VerifyFunction.getValidationRequest(contentFile, signatureFile, waitWindow);
            if (request == null) {
                workingResult.setCurrentState(WorkingResult.Status.ABORTED);
                return;
            }
            ValidateProcessor validationProcessor = SignerValidationProcessor.getInstance().getValidateProcessor();
            ValidateResponse response = validationProcessor.validate((ValidateRequest)request);
            PropertyHashedFile propertyHashedFile = VerifyFunction.createProtocolFile(verifyForm, signatureFile, protocolType, response);
            workingResult.addResultFile((File)propertyHashedFile);
            workingResult.setValidateResponse(response);
        }
        finally {
            waitWindow.closeWindow();
            workingResult.setCurrentState(WorkingResult.Status.FINISHED);
        }
    }

    public static boolean relaySettingIsValid(VerifyProcessFormular verifyFormular) {
        ValidationProcessorSetup setup = SignerValidationProcessor.getInstance().getValidationProcessorSetup();
        CertificateValidationServer server = SignerValidationProcessor.getInstance().getServer();
        boolean isConfigComplete = server != null && server.isConfigComplete();
        boolean bl = isConfigComplete = isConfigComplete && setup.getRelaySigningCertificates() != null && !setup.getRelaySigningCertificates().isEmpty();
        if (!isConfigComplete) {
            de.bos_bremen.ecard.client.model.Document documentInstance = de.bos_bremen.ecard.client.model.Document.getInstance();
            documentInstance.reportError(ErrorCode.CONNECTION_ERROR, false, new Object[]{"RelaySigningCertificate is null"});
            List workingResultList = documentInstance.getWorkingResults();
            for (WorkingResult workingResult : workingResultList) {
                workingResult.setErrorObject(new ErrorObject(ErrorCode.CONNECTION_ERROR, "RelaySigningCertificate is null", false));
                workingResult.setCurrentState(WorkingResult.Status.ERROR);
            }
            return false;
        }
        return true;
    }

    public static String getProtocolSuffix() {
        return SignerValidationProcessor.getInstance().getServer().getProtocolSuffix();
    }

    public static VerifyProtocolType getProtocolType(WorkingStep workingStep) {
        VerifyProtocolType result = switch (((VerifyConfig)workingStep.getParent().getConfig()).getVerifyProtocolType()) {
            case VerifyProtocolType.pdf -> VerifyProtocolType.pdf;
            case VerifyProtocolType.xml -> VerifyProtocolType.xml;
            default -> VerifyProtocolType.html;
        };
        LOG.debug("ProtocolType: {}", (Object)result);
        return result;
    }

    private static ValidationRequest getValidationRequest(File contentFile, File signatureFile, ConnectServerWaitWindow waitWindow) {
        SimpleSignedData data;
        ValidationRequest request = new ValidationRequest();
        ValidationOptions options = new ValidationOptions();
        options.setMaxRecursiveValidationStepsForIncludedFiles(2);
        FileDocumentImpl signature = new FileDocumentImpl(signatureFile, signatureFile.getName());
        if (contentFile != null) {
            FileDocumentImpl content = new FileDocumentImpl(contentFile, contentFile.getName());
            data = new SimpleSignedData((Document)content, (Document)signature);
        } else {
            data = new SimpleSignedData((Document)signature);
        }
        request.setSignedData((SignedData)data);
        Date validationDate = new Date();
        if ((signatureFile.getAbsolutePath().endsWith(".cer") || signatureFile.getAbsolutePath().endsWith(".crt")) && (validationDate = VerifyFunction.getVerificationTime((WaitWindow)waitWindow)) == null) {
            return null;
        }
        options.setValidationDate(validationDate);
        request.setOptions((Options)options);
        return request;
    }

    private static Date getVerificationTime(WaitWindow waitWindow) {
        de.bos_bremen.ecard.client.model.Document documentInstance = de.bos_bremen.ecard.client.model.Document.getInstance();
        Date certificateVerifyTime = new Date();
        boolean hideWaitWindow = false;
        if (waitWindow != null) {
            hideWaitWindow = true;
            waitWindow.closeWindow();
        }
        int showDialog = VerifyTimeDialog.showDialog((Frame)documentInstance.getFrame(), (Date)certificateVerifyTime);
        if (hideWaitWindow) {
            waitWindow.showWindow();
        }
        if (showDialog != 0) {
            return null;
        }
        if (VerifyTimeDialog.isLocalTime()) {
            return new Date();
        }
        return certificateVerifyTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyHashedFile createProtocolFile(VerifyProcessFormular verifyFormular, File signatureFile, VerifyProtocolType protocolType, ValidateResponse response) throws IOException, LayoutException {
        OutputPlugin output = VerifyFunction.createOutputType(protocolType);
        ArrayList<Object> ip = new ArrayList<Object>();
        AllSignaturesCheck allSignaturesCheck = new AllSignaturesCheck();
        ip.add(allSignaturesCheck);
        WholeDocumentSignedCheck wholeDocumentSignedCheck = new WholeDocumentSignedCheck();
        ip.add(wholeDocumentSignedCheck);
        output.setResultInterpreter(ip);
        HashMap<String, Boolean> additionalSettings = new HashMap<String, Boolean>();
        additionalSettings.put("summary_inspection", Boolean.TRUE);
        output.setAdditionalSettings(additionalSettings);
        String targetFileName = signatureFile.getName();
        String targetFileFolder = verifyFormular.getVerifyReportTargetFolderType().equals((Object)TargetFolderType.sameAsSourceFolder) ? signatureFile.getParent() : verifyFormular.getVerifyReportTargetFolder();
        String protocolSuffix = VerifyFunction.getProtocolSuffix();
        File protocolFile = new File(targetFileFolder, targetFileName + protocolSuffix);
        LOG.debug("ProtocolFile: {}", (Object)protocolFile);
        FileOutputStream out = new FileOutputStream(protocolFile);
        try {
            if (protocolType == VerifyProtocolType.xml) {
                SignatureValidationReportOutput sheet = new SignatureValidationReportOutput();
                sheet.layout(response, (OutputStream)out);
            } else {
                output.layout(response, (OutputStream)out);
            }
        }
        finally {
            Utils.closeStream((Closeable)out);
        }
        MajorTotalResult majorTotalResult = MajorTotalResult.NOT_VALIDATED;
        if (protocolType == VerifyProtocolType.xml) {
            CumulatedValidationResult cvr = response.getOverallResult(true);
            majorTotalResult = cvr == null ? MajorTotalResult.NOT_VALIDATED : cvr.getMajor();
            ObjectValidationResult obj = (ObjectValidationResult)response.getDocumentValidationResult();
            if (obj instanceof PAdESDocumentValidationResult) {
                PAdESDocumentValidationResult pdfResult = (PAdESDocumentValidationResult)obj;
                MajorTotalResult pdfMajorTotalResult = wholeDocumentSignedCheck.getInterpretedResult((de.governikus.csl.uom.validate.ObjectValidationResult)pdfResult).getMajor();
                majorTotalResult = MajorTotalResult.max((MajorTotalResult)majorTotalResult, (MajorTotalResult)pdfMajorTotalResult);
            }
        } else {
            majorTotalResult = allSignaturesCheck.getMajorTotalResult();
            majorTotalResult = MajorTotalResult.max((MajorTotalResult)majorTotalResult, (MajorTotalResult)wholeDocumentSignedCheck.getMajorTotalResult());
        }
        byte[] hash = Utils.createSHA256Hash((File)protocolFile);
        return new PropertyHashedFile(protocolFile, hash, majorTotalResult, protocolType.name());
    }

    private static OutputPlugin createOutputType(VerifyProtocolType protocolType) {
        Locale actualLocale = LocaleChanger.getInstance().getActualLocale();
        Object output = protocolType == VerifyProtocolType.pdf ? new InspectionSheetPDF(actualLocale) : (protocolType == VerifyProtocolType.xml ? new SignatureValidationReportOutput() : new InspectionSheetHTMLAccordeon(actualLocale));
        return output;
    }
}

