/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.signservice.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.governikus.csc.cryptohost.model.ResourceReferencesDTO;
import de.governikus.csc.signservice.model.RawSignBatchRequest;
import de.governikus.csc.signservice.model.RawSignBatchResponse;
import de.governikus.csc.signservice.model.SignRequest;
import de.governikus.csc.signservice.model.SignResponse;
import de.governikus.csc.utils.rest.client.JSONBindingResponseHandler;
import de.governikus.csc.utils.rest.client.JSONEntity;
import de.governikus.csc.utils.rest.client.SimpleServiceClient;
import de.governikus.csc.utils.rest.client.URIBuilder;
import de.governikus.csl.transport.AbstractHttpClient;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.HttpResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignServiceClient
extends SimpleServiceClient<SignRequest, SignResponse>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SignServiceClient.class);
    private URI baseURI;

    public SignServiceClient(URI baseURI, HttpClient httpClient) {
        super(baseURI, httpClient, SignResponse.class);
        this.baseURI = baseURI;
    }

    public ResourceReferencesDTO getResourceRefs() throws IOException {
        URI uri = new URIBuilder(this.baseURI).path("resourceRefs").build();
        return (ResourceReferencesDTO)super.get(uri, (HttpResponseHandler)new HttpResponseHandler<ResourceReferencesDTO>(){

            public ResourceReferencesDTO handleResponse(HttpResponse resp) throws IOException {
                AbstractHttpClient.checkResponseErrors((HttpResponse)resp);
                LOG.debug("content: {}", resp.getContent().getClass());
                try (InputStream is = resp.getContent();){
                    ResourceReferencesDTO resourceReferencesDTO = (ResourceReferencesDTO)new ObjectMapper().readValue(is, ResourceReferencesDTO.class);
                    return resourceReferencesDTO;
                }
            }
        }, new HttpHeader[0]);
    }

    public RawSignBatchResponse handleRawSignBatch(RawSignBatchRequest rawSignBatchRequest, String keyid) throws IOException {
        Objects.requireNonNull(rawSignBatchRequest, "rawSignBatchRequest cannot be null !");
        Objects.requireNonNull(keyid, "keyid cannot be null !");
        Object path = "rawsignbatch/keyid";
        if (!keyid.startsWith("/")) {
            path = (String)path + "/";
        }
        path = (String)path + keyid;
        URI uri = new URIBuilder(this.baseURI).path((String)path).build();
        return (RawSignBatchResponse)this.client.put(uri, (HttpRequest)new JSONEntity((Object)rawSignBatchRequest), (HttpResponseHandler)new JSONBindingResponseHandler(RawSignBatchResponse.class), new HttpHeader[]{new HttpHeader("Accept", "application/json")});
    }
}

