/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.signservice.client;

import de.governikus.csc.authentication.keycloak.client.KeycloakAuthClient;
import de.governikus.csc.cryptohost.model.ResourceReferencesDTO;
import de.governikus.csc.signservice.client.SignServiceClient;
import de.governikus.csc.signservice.model.SignRequest;
import de.governikus.csc.signservice.model.SignResponse;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.uom.Document;
import java.io.IOException;
import java.net.URI;
import org.keycloak.jose.jws.JWSInputException;

public class AuthenticatedSignServiceClient
extends SignServiceClient {
    private static final long serialVersionUID = 1L;
    KeycloakAuthClient keycloakAuthClient;

    public AuthenticatedSignServiceClient(URI baseURI, HttpClient httpClient, KeycloakAuthClient keycloakAuthClient) {
        super(baseURI, httpClient);
        this.keycloakAuthClient = keycloakAuthClient;
    }

    public Document handleProfile(Document dataToBeSigned, String profileID) throws IOException {
        try {
            this.setAuthToken(this.keycloakAuthClient.getAccessToken());
        }
        catch (JWSInputException e) {
            throw new IOException("authentication failed", e);
        }
        return super.handleProfile(dataToBeSigned, profileID);
    }

    public SignResponse handleComplex(SignRequest input) throws IOException {
        try {
            this.setAuthToken(this.keycloakAuthClient.getAccessToken());
        }
        catch (JWSInputException e) {
            SignResponse signResponse = new SignResponse();
            signResponse.setFailureData(e.getMessage());
            return signResponse;
        }
        return (SignResponse)super.handleComplex((Object)input);
    }

    @Override
    public ResourceReferencesDTO getResourceRefs() throws IOException {
        try {
            this.setAuthToken(this.keycloakAuthClient.getAccessToken());
        }
        catch (JWSInputException e) {
            throw new IOException("error while retrieving ResourceRefs from sign service {}", e);
        }
        return super.getResourceRefs();
    }
}

