/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.zip;

import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.ReferenceResolver;
import de.governikus.csl.uom.impl.MappingFileReferenceResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.activation.FileTypeMap;

public class ZippedDocument
implements Document {
    private File extractedFile;
    private String name;
    private ReferenceResolver referenceResolver;
    private Map<String, String> fileMap;

    public ZippedDocument(File extractedFile, String name) {
        this(extractedFile, name, Collections.emptyMap());
    }

    public ZippedDocument(File extractedFile, String name, Map<String, String> fileMap) {
        this.extractedFile = extractedFile;
        this.name = name;
        this.fileMap = fileMap;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.extractedFile);
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return FileTypeMap.getDefaultFileTypeMap().getContentType(this.extractedFile);
    }

    public String getId() {
        return this.name;
    }

    public ReferenceResolver getReferenceResolver() {
        if (this.referenceResolver == null) {
            this.referenceResolver = new MappingFileReferenceResolver(this.extractedFile.getParentFile(), this.fileMap);
        }
        return this.referenceResolver;
    }
}

