/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.zip;

import de.governikus.csl.core.impl.BaseObjectToValidate;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.utils.AbstractDocumentParser;
import de.governikus.csl.zip.ZippedDocument;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipParser
extends AbstractDocumentParser<ObjectToValidate<Signature>> {
    private TempDataManager tempDataManager;

    public ZipParser(TempDataManager tempDataManager) {
        this.tempDataManager = tempDataManager;
    }

    public ObjectToValidate<Signature> loadDocument(SignedData sda) throws Exception {
        String normalizedName;
        Document d = sda.getSignature();
        String documentName = d.getName();
        if (documentName != null && !(normalizedName = documentName.toLowerCase(Locale.ENGLISH)).endsWith(".zip") && normalizedName.contains(".")) {
            throw new CoreException("Unsupported file extension");
        }
        ArrayList<ZippedDocument> files = new ArrayList<ZippedDocument>();
        HashMap<String, String> fileMap = new HashMap<String, String>();
        try (InputStream is = d.getInputStream();){
            File tmpFile = null;
            ZipInputStream zip = new ZipInputStream(is, Charset.forName("Cp437"));
            ZipEntry zipEntry = zip.getNextEntry();
            boolean isZip = false;
            while (zipEntry != null) {
                if (zipEntry.isDirectory()) {
                    zipEntry = zip.getNextEntry();
                    continue;
                }
                isZip = true;
                String name = zipEntry.getName();
                tmpFile = this.tempDataManager.createTempFile("content", null);
                fileMap.put(name, tmpFile.getName());
                Files.copy(zip, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                zipEntry = zip.getNextEntry();
                ZippedDocument fdi = new ZippedDocument(tmpFile, name, fileMap);
                files.add(fdi);
            }
            zip.closeEntry();
            zip.close();
            if (!isZip) {
                throw new CoreException("The data isn't a zip archive");
            }
        }
        if (files.isEmpty()) {
            return null;
        }
        BaseObjectToValidate res = new BaseObjectToValidate();
        res.setIncludedFilesToValidate(files);
        res.setName(documentName);
        return res;
    }
}

