/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.zip;

import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.utils.MagicBytes;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.ZipDocumentValidationResult;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.PluginPriority;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.zip.ZipParser;

@PluginType(id=Plugin.PluginID.VALIDATE_ZIP, type=ValidatePlugin.class)
@PluginPriority(priority=-5000L)
public class ZipContainerValidatePlugin
extends AbstractDocumentPlugin<ObjectToValidate<Signature>, Signature, ObjectValidationResult, SignatureValidationResult, SignatureValidationContext> {
    private static final String SUPPORTED_MIME_TYPE = "application/zip";
    private static final String[] SUPPORTED_FILE_EXTENSIONS = new String[]{"zip"};

    public ZipContainerValidatePlugin() {
        super(Signature.class, SignatureValidationContext.class);
    }

    public ObjectToValidate<Signature> parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        ZipParser parser = new ZipParser(tempDataManager);
        try {
            return parser.loadDocument(doc);
        }
        catch (Exception e) {
            throw new ValidatePluginException((ValidatePlugin)this, "Can't parse document", (Throwable)e);
        }
    }

    protected ObjectValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        ZipDocumentValidationResult zipObjectValidationResult = new ZipDocumentValidationResult();
        zipObjectValidationResult.setObjectTypeID(this.getID());
        return zipObjectValidationResult;
    }

    protected SignatureValidationResult createSignatureValidationResultStructure() {
        return new SignatureValidationResult();
    }

    public SignatureValidationContext createContext(Signature signature, ValidationPolicyType policy) {
        return new SignatureValidationContext(policy);
    }

    public String[] getSupportedFileExtensions() {
        return SUPPORTED_FILE_EXTENSIONS;
    }

    public MagicBytes getMagicBytesOfDocumentFormat() {
        return MagicBytes.MAGIC_BYTES_ZIP;
    }

    public boolean supportsMimeType(String mimeType) {
        return SUPPORTED_MIME_TYPE.equals(mimeType);
    }
}

