/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.encrypt.model.formular.process.impl;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.encrypt.model.formular.process.EncryptProcessFormular;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.ProcessFileSeen;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.formular.process.impl.AbstractProcessFormular;
import de.bos_bremen.ecard.client.model.keyprovider.AbstractKeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

public class EncryptFormular
extends AbstractProcessFormular
implements EncryptProcessFormular {
    private List<ProcessFileSeen> selectedFiles;
    private EnumMap<StepFactory.StepName, Boolean> skippStep = new EnumMap(StepFactory.StepName.class);
    private List<KeyProvider> keyProviderList = new ArrayList<KeyProvider>();
    private Boolean createZipArchiv;
    private String targetFolder;
    private TargetFolderType targetFolderType;
    private String localCopyFolder;
    private SubsequentProcess currentSubsequentProcess;
    private Boolean usePassword = false;
    private String serialnumber;

    public EncryptFormular(EncryptFormular formular) {
        super((AbstractProcessFormular)formular);
        this.selectedFiles = formular.selectedFiles != null ? new ArrayList<ProcessFileSeen>(formular.selectedFiles) : new ArrayList();
        this.skippStep = formular.skippStep != null ? new EnumMap<StepFactory.StepName, Boolean>(formular.skippStep) : new EnumMap(StepFactory.StepName.class);
        this.keyProviderList = formular.keyProviderList != null ? new ArrayList<KeyProvider>(formular.keyProviderList) : new ArrayList();
        this.createZipArchiv = formular.createZipArchiv;
        this.targetFolder = formular.targetFolder != null ? formular.targetFolder : null;
        this.targetFolderType = formular.targetFolderType;
        this.usePassword = formular.usePassword != null ? formular.usePassword : null;
    }

    public EncryptFormular() {
    }

    public void addSelectedFile(ProcessFileSeen file) {
        boolean added;
        if (this.selectedFiles == null) {
            this.selectedFiles = new ArrayList<ProcessFileSeen>();
        }
        if (added = this.selectedFiles.add(file)) {
            this.notifyAllChangeListener(null, file, StepFactory.StepName.selectfiles);
        }
    }

    public boolean containSelectedFiles(ProcessFileSeen file) {
        if (this.selectedFiles != null && !this.selectedFiles.isEmpty()) {
            for (ProcessFileSeen aktFile : this.selectedFiles) {
                if (aktFile.getFile() == null || file.getFile() == null || !aktFile.getFile().equals((Object)file.getFile())) continue;
                return true;
            }
        }
        return false;
    }

    public List<ProcessFileSeen> getSelectedFiles() {
        return this.selectedFiles;
    }

    public boolean removeSelectedFile(ProcessFileSeen fileToRemove) {
        boolean remove;
        if (this.selectedFiles == null) {
            this.selectedFiles = new ArrayList<ProcessFileSeen>();
        }
        if (remove = this.selectedFiles.remove(fileToRemove)) {
            this.notifyAllChangeListener(fileToRemove, null, StepFactory.StepName.selectfiles);
        }
        return remove;
    }

    public void removeAllFiles() {
        ArrayList<ProcessFileSeen> liste = new ArrayList<ProcessFileSeen>();
        if (this.selectedFiles != null) {
            for (ProcessFileSeen psf : this.selectedFiles) {
                liste.add(psf);
            }
        } else {
            this.selectedFiles = new ArrayList<ProcessFileSeen>();
        }
        for (ProcessFileSeen psf : liste) {
            this.removeSelectedFile(psf);
        }
    }

    public void setSelectedFiles(List<File> files, boolean replaceFiles) {
        if (replaceFiles || this.selectedFiles == null) {
            this.selectedFiles = new ArrayList<ProcessFileSeen>();
        }
        if (files != null) {
            for (File file : files) {
                ProcessFileSeen processFileSeen = new ProcessFileSeen(file);
                if (this.containSelectedFiles(processFileSeen)) continue;
                this.selectedFiles.add(processFileSeen);
            }
        }
        this.notifyAllChangeListener(null, this.selectedFiles, StepFactory.StepName.selectfiles);
    }

    public void skipStep(boolean useDefaults, StepFactory.StepName stepName) {
        this.skippStep.put(stepName, useDefaults);
    }

    public Boolean skipStep(StepFactory.StepName stepName) {
        if (this.skippStep.containsKey(stepName)) {
            return this.skippStep.get(stepName);
        }
        return Boolean.FALSE;
    }

    public boolean addKeyProvider(KeyProvider provider, KeyUsage keyUsage) {
        if (keyUsage != KeyUsage.ENCRYPT || provider == null) {
            return false;
        }
        if (this.keyProviderList.contains(provider)) {
            return true;
        }
        boolean result = this.keyProviderList.add(provider);
        if (result) {
            this.notifyAllChangeListener(null, provider, StepFactory.StepName.selectcertificates);
        }
        return result;
    }

    public List<KeyProvider> getKeyProvider(KeyUsage keyUsage) {
        if (keyUsage != KeyUsage.ENCRYPT) {
            return null;
        }
        return new ArrayList<KeyProvider>(this.keyProviderList);
    }

    public boolean removeKeyProvider(KeyProvider provider, KeyUsage keyUsage) {
        if (keyUsage != KeyUsage.ENCRYPT) {
            return false;
        }
        ProcessName p = Utils.getActiveProcess();
        if (p == null || "none".equals(p.toString())) {
            LOG.info("no active process -> return");
            return false;
        }
        boolean result = this.keyProviderList.remove(provider);
        if (result) {
            this.notifyAllChangeListener(provider, null, StepFactory.StepName.selectcertificates);
        }
        return result;
    }

    public boolean setSelectedAlias(KeyProvider provider, String alias, KeyUsage keyUsage) {
        if (keyUsage != KeyUsage.ENCRYPT) {
            return false;
        }
        provider.getSelectedAlias();
        if (!this.keyProviderList.contains(provider)) {
            return false;
        }
        int indexOf = this.keyProviderList.indexOf(provider);
        ((AbstractKeyProvider)provider).setSelectedAlias(alias);
        this.keyProviderList.remove(indexOf);
        this.keyProviderList.add(indexOf, provider);
        this.notifyAllChangeListener(provider, null, StepFactory.StepName.selectkeys);
        return true;
    }

    @Override
    public void createZipArchiv(boolean create) {
        this.createZipArchiv = create;
    }

    @Override
    public Boolean createZipArchiv() {
        return this.createZipArchiv;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public TargetFolderType getTargetFolderType() {
        return this.targetFolderType;
    }

    public boolean setTargetFolder(String folder) {
        String oldValue = this.targetFolder;
        this.targetFolder = folder;
        this.notifyAllChangeListener(oldValue, this.targetFolder, StepFactory.StepName.selecttargetfolder);
        return true;
    }

    public boolean setTargetFolderType(TargetFolderType folderType) {
        this.targetFolderType = folderType;
        return true;
    }

    public void setDefault() {
        this.setSelectedFiles(new ArrayList<File>(), true);
        EnumMap<StepFactory.StepName, Boolean> oldSkippStep = new EnumMap<StepFactory.StepName, Boolean>(StepFactory.StepName.class);
        oldSkippStep.putAll(this.skippStep);
        for (StepFactory.StepName key : oldSkippStep.keySet()) {
            if (!this.skippStep.get(key).booleanValue()) continue;
            this.skippStep.remove(key);
            this.skipStep(false, key);
        }
        ArrayList<KeyProvider> oldKeyProviderList = new ArrayList<KeyProvider>();
        oldKeyProviderList.addAll(this.keyProviderList);
        for (KeyProvider provider : oldKeyProviderList) {
            this.removeKeyProvider(provider, KeyUsage.DECRYPT);
        }
        this.createZipArchiv(false);
        this.setTargetFolderType(TargetFolderType.sameAsSourceFolder);
        this.setTargetFolder(null);
    }

    public void notifyAllChangeListener() {
        this.notifyAllChangeListener(null, Boolean.TRUE, StepFactory.StepName.selectfiles);
    }

    public void setFileAsSeen(ProcessFileSeen file) throws SignerException {
        try {
            file.setSeen(true);
        }
        finally {
            this.notifyAllChangeListener();
        }
    }

    public String getLocalCopyFolder() {
        return this.localCopyFolder;
    }

    public void setLocalCopyFolder(String folder) {
        String oldValue = this.localCopyFolder;
        this.localCopyFolder = folder;
        this.notifyAllChangeListener(oldValue, folder, StepFactory.StepName.selecttargetfolder);
    }

    public SubsequentProcess getSubsequentProcess() {
        return this.currentSubsequentProcess;
    }

    public void setSubsequentProcess(SubsequentProcess subsequentProcess) {
        this.currentSubsequentProcess = subsequentProcess;
    }

    @Override
    public void usePassword(boolean value) {
        boolean oldValue = this.usePassword;
        this.usePassword = value;
        this.notifyAllChangeListener(oldValue, value, StepFactory.StepName.selectcertificates);
    }

    @Override
    public Boolean usePassword() {
        return this.usePassword;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("\nEncryptFormular");
        List<ProcessFileSeen> files = this.getSelectedFiles();
        stringBuilder.append("\nSelectedFiles: ");
        if (files == null || files.isEmpty()) {
            stringBuilder.append("---");
        } else {
            for (ProcessFileSeen file : files) {
                stringBuilder.append(file.getFile().getAbsolutePath() + ";");
            }
        }
        stringBuilder.append("\n");
        stringBuilder.append("CreateZipArchiv: " + this.createZipArchiv() + "\n");
        stringBuilder.append("TargetFolderType: " + this.getTargetFolderType() + "\n");
        stringBuilder.append("TargetFolder: " + this.getTargetFolder() + "\n");
        stringBuilder.append("UsePassword: " + this.usePassword() + "\n");
        stringBuilder.append("KeyProviderList: ");
        if (this.keyProviderList == null || this.keyProviderList.isEmpty()) {
            stringBuilder.append("---");
        } else {
            for (KeyProvider key : this.keyProviderList) {
                stringBuilder.append(key.getSelectedAlias() + ";");
            }
        }
        return stringBuilder.toString();
    }

    public void setSerialnumber(String serialnumber) {
        LOG.debug("set serialnumber : {}", (Object)serialnumber);
        this.serialnumber = serialnumber;
    }

    public String getSerialnumber() {
        LOG.debug("get serialnumber : {}", (Object)this.serialnumber);
        return this.serialnumber;
    }
}

