/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.encrypt.gui.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AliasSelectionHandler;
import de.bos_bremen.ecard.client.action.RemoveKeyProvidersHandler;
import de.bos_bremen.ecard.client.control.step.KeyProviderStep;
import de.bos_bremen.ecard.client.control.step.SkippableStep;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.encrypt.control.step.SelectEncryptCertificates;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.step.CertificatesList;
import de.bos_bremen.ecard.client.gui.step.ChooseCertificatesDialog;
import de.bos_bremen.ecard.client.gui.view.component.DescriptionPanel;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.SkipStepHandler;
import de.bos_bremen.ecard.client.gui.view.component.SkipStepPanel;
import de.bos_bremen.ecard.client.gui.view.component.buttons.AccessibleRadioButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IFDCurvedToggleIconButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.keyprovider.AbstractKeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.AliasListener;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderEntry;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderSource;
import de.bos_bremen.ecard.client.model.keyprovider.SoftwareKeyList;
import de.bos_bremen.ecard.client.model.keyprovider.TerminalKey;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.TerminalListener;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.TerminalModel;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SelectCertificatesView
extends JPanel
implements StepChangedListener,
AdjustmentListener,
AliasSelectionHandler,
RemoveKeyProvidersHandler,
ListSelectionListener,
PropertyChangeListener,
SkipStepHandler,
TableModelListener,
ActionListener,
TerminalListener,
AliasListener {
    private static final long serialVersionUID = -344247577760697520L;
    private static final Logger LOG = LogManager.getLogger(SelectCertificatesView.class);
    private final transient SelectEncryptCertificates selectEncryptCertificatesStep;
    private DescriptionPanel descPanel;
    private AccessibleRadioButton usePassword;
    private AccessibleRadioButton useCertificate;
    private final List<IFDCurvedToggleIconButton> ifdList = new ArrayList<IFDCurvedToggleIconButton>();
    private JPanel ifdPanel;
    private JPanel ifdBorderPanel;
    private JScrollPane ifdScrollPane;
    private JPanel certificateBorderPanel;
    private IconButton deleteButton;
    private CertificatesList certList;
    private SkipStepPanel skipStep;
    private ChooseCertificatesDialog dialog;
    private static final String ENCRYPT_KEY_PASSWORD = "process/encrypt/key/password";
    private static final String ENCRYPT_KEY_CERTIFICATE = "process/encrypt/key/certificate";
    private static final String ENCRYPT_KEY_CERTIFICATE_SOFTWARE = "process/encrypt/key/certificate/software";

    public SelectCertificatesView(SelectEncryptCertificates step) {
        LOG.trace("encrypt : selectcertificates");
        this.selectEncryptCertificatesStep = step;
        this.selectEncryptCertificatesStep.addStateChangeListener(this);
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)this);
        this.initKeyProviderList();
        this.initGui();
        this.updateIfdList();
        this.layoutIfdPanel();
        this.layoutGui();
    }

    private void initKeyProviderList() {
        LOG.trace("encrypt : selectcertificates");
        KeyUsage keyUsage = this.selectEncryptCertificatesStep.keyUsage;
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        LicenceTyp softwareLicence = productFunctions.getLicence(ENCRYPT_KEY_CERTIFICATE_SOFTWARE);
        if (softwareLicence.useInProcess()) {
            this.selectEncryptCertificatesStep.getKeyProviderList().add(new SoftwareKeyList((KeyProviderStep)this.selectEncryptCertificatesStep, keyUsage));
        }
        this.selectEncryptCertificatesStep.getKeyProviderList().add(new TerminalKey((TerminalListener)this, (AliasListener)this, (KeyProviderStep)this.selectEncryptCertificatesStep, keyUsage));
    }

    private void initGui() {
        LOG.trace("encrypt : selectcertificates : gui");
        this.descPanel = new DescriptionPanel("step.encrypt.keychooser");
        this.usePassword = new AccessibleRadioButton(Messages.getString((String)"step.encrypt.keychooser.usePassword.text"), Messages.getResource((String)"step.encrypt.keychooser.usePassword.tooltip"));
        this.usePassword.addActionListener((ActionListener)this);
        boolean isUsePassword = this.selectEncryptCertificatesStep.usePassword();
        this.usePassword.setSelected(isUsePassword);
        this.useCertificate = new AccessibleRadioButton(Messages.getString((String)"step.encrypt.keychooser.useCertificate.text"), Messages.getResource((String)"step.encrypt.keychooser.useCertificate.tooltip"));
        this.useCertificate.addActionListener((ActionListener)this);
        this.useCertificate.setSelected(!isUsePassword);
        ButtonGroup encryptChoiceGroup = new ButtonGroup();
        encryptChoiceGroup.add((AbstractButton)this.usePassword);
        encryptChoiceGroup.add((AbstractButton)this.useCertificate);
        this.ifdPanel = new JPanel();
        this.ifdBorderPanel = new JPanel();
        this.ifdBorderPanel = ComponentUtils.setTitledFocusableBorder((JPanel)this.ifdBorderPanel, (String)Messages.getString((String)"step.encrypt.keychooser.title1"));
        this.ifdScrollPane = new JScrollPane();
        this.ifdScrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.ifdScrollPane.setBorder(null);
        this.ifdScrollPane.setVerticalScrollBarPolicy(21);
        Action deleteAction = Document.getInstance().getActionFactory().createRemoveKeyProvidersAction((RemoveKeyProvidersHandler)this);
        this.deleteButton = new IconButton("action.encrypt.delete");
        this.deleteButton.addActionListener((ActionListener)deleteAction);
        KeyStroke deleteKeyStroke = KeyStroke.getKeyStroke(127, 0);
        this.getInputMap(1).put(deleteKeyStroke, "deleteAction");
        this.getActionMap().put("deleteAction", deleteAction);
        this.certList = new CertificatesList(this.selectEncryptCertificatesStep.getKeyProviderToUse(), Messages.getString((String)"step.encrypt.keychooser.list.header"));
        this.certList.addListSelectionListener((ListSelectionListener)this);
        this.certList.getCertTable().getModel().addTableModelListener(this);
        String mnemonic = Messages.getResource((String)"view.step.selectfiles.list.header.mnemonic");
        KeyStroke ks = KeyStroke.getKeyStroke("alt " + mnemonic.charAt(0));
        this.certList.getInputMap(2).put(ks, "selectTable");
        this.certList.getActionMap().put("selectTable", new SetFocusOnTableAction());
        Component root = SwingUtilities.getRoot(this);
        if (root != null && root instanceof JFrame) {
            JFrame jFrame = (JFrame)root;
            if (this.dialog == null) {
                this.dialog = new ChooseCertificatesDialog(jFrame, KeyUsage.ENCRYPT.toString().toLowerCase());
                this.dialog.addOkAction((Action)Document.getInstance().getActionFactory().createAliasSelectionAction((AliasSelectionHandler)this, null));
            }
        }
        this.skipStep = new SkipStepPanel((SkipStepHandler)this);
        this.skipStep.getSkipStep().setSelected(this.selectEncryptCertificatesStep.isSaveAsStandard());
    }

    private void layoutGui() {
        LOG.trace("encrypt : selectcertificates : gui");
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.layoutDescriptionPanel(), "North");
        this.add((Component)this.layoutCenterPanel(), "Center");
        this.add((Component)this.skipStep, "South");
        this.revalidate();
        this.repaint();
    }

    private JPanel layoutCenterPanel() {
        LOG.trace("encrypt : selectcertificates : gui");
        JPanel centerPanel = new JPanel(new GridBagLayout());
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        LicenceTyp passwordLicence = productFunctions.getLicence(ENCRYPT_KEY_PASSWORD);
        LicenceTyp certificateLicence = productFunctions.getLicence(ENCRYPT_KEY_CERTIFICATE);
        int row = 0;
        centerPanel.add((Component)JComponentUtils.setLookByLicence((JComponent)this.layoutPasswordPanel(), (LicenceTyp)passwordLicence), new GridBagConstraints(0, row, 1, 1, 0.2f, 0.2f, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        centerPanel.add((Component)JComponentUtils.setLookByLicence((JComponent)this.layoutCertificatePanel(), (LicenceTyp)certificateLicence), new GridBagConstraints(0, ++row, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return centerPanel;
    }

    private JPanel layoutPasswordPanel() {
        LOG.trace("encrypt : selectcertificates : gui");
        JPanel passwordPanel = new JPanel(new GridBagLayout());
        passwordPanel.setBorder((Border)ComponentUtils.createTitledCurvedBorderForTitle((String)Messages.getString((String)"step.encrypt.keychooser.usePassword.title")));
        passwordPanel.add((Component)this.usePassword, new GridBagConstraints(0, 0, 1, 1, 0.2f, 0.2f, 18, 2, new Insets(0, 15, 0, 0), 0, 0));
        return passwordPanel;
    }

    private JPanel layoutCertificatePanel() {
        LOG.trace("encrypt : selectcertificates : gui");
        this.certificateBorderPanel = this.createCertificatePanel((JButton)this.deleteButton, (JPanel)this.certList);
        JPanel center = new JPanel(new BorderLayout());
        center.add((Component)this.ifdBorderPanel, "North");
        center.add((Component)this.certificateBorderPanel, "Center");
        JPanel certificatePanel = new JPanel(new GridBagLayout());
        certificatePanel.setBorder((Border)ComponentUtils.createTitledCurvedBorderForTitle((String)Messages.getString((String)"step.encrypt.keychooser.useCertificate.title")));
        certificatePanel.add((Component)this.useCertificate, new GridBagConstraints(0, 0, 1, 1, 0.2f, 0.2f, 18, 2, new Insets(0, 15, 0, 0), 0, 0));
        certificatePanel.add((Component)center, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 35, 0, 0), 0, 0));
        return certificatePanel;
    }

    private JPanel layoutDescriptionPanel() {
        LOG.trace("encrypt : selectcertificates : gui");
        JPanel descriptionPanel = new JPanel(new GridBagLayout());
        descriptionPanel.add((Component)this.descPanel, new GridBagConstraints(0, 0, 1, 1, 0.2f, 0.2f, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        return descriptionPanel;
    }

    private boolean isIfdEnabled(KeyProviderEntry entry) {
        LOG.trace("");
        if (entry == null) {
            return false;
        }
        if (entry.getKeyProviderType() == KeyProviderSource.SOFTWARE) {
            LicenceTyp softwareLicence = Document.getInstance().getProductFunctions().getLicence(ENCRYPT_KEY_CERTIFICATE_SOFTWARE);
            return softwareLicence.isEditable();
        }
        if (entry.getKeyProviderType() == KeyProviderSource.CARD) {
            return false;
        }
        return false;
    }

    private JPanel createCertificatePanel(JButton deleteButton, JPanel certList) {
        LOG.trace("encrypt : selectcertificates : gui");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.add((Component)deleteButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 1, new Insets(0, 0, 0, 10), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 10), 0, 0));
        panel.add((Component)certList, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 10), 0, 0));
        return panel;
    }

    private void updateIfdList() {
        LOG.trace("encrypt : selectcertificates");
        this.ifdList.clear();
        for (AbstractKeyProvider keyProvider : this.selectEncryptCertificatesStep.getKeyProviderList()) {
            List buttons = keyProvider.getIFDCurvedToggleIconButton();
            if (buttons == null) continue;
            for (IFDCurvedToggleIconButton button : buttons) {
                this.updateIFDButton(button);
                this.ifdList.add(button);
            }
        }
        LOG.debug("ifdList updated.");
    }

    private void updateIFDButton(IFDCurvedToggleIconButton button) {
        LOG.trace("encrypt : selectcertificates");
        if (button == null) {
            LOG.warn("IFDCurvedToggleIconButton was null!");
            return;
        }
        LOG.debug("encrypt : selectcertificates : {}", (Object)button.getKeyProviderEntry().getKeyProviderType());
        if (button.getKeyProviderEntry().getKeyProviderType() == KeyProviderSource.CARD) {
            LOG.warn("Die Verschluessselung mit der Karte wird nicht mehr unterstuetzt.");
            button.setText(KeyProviderSource.CARD.name());
            return;
        }
        boolean enabled = this.isIfdEnabled(button.getKeyProviderEntry()) && !this.usePassword.isSelected();
        button.setEnabled(enabled);
        if (button.getAction() == null) {
            return;
        }
        button.getAction().setEnabled(enabled);
    }

    private void updateDeleteButton() {
        LOG.trace("encrypt : selectcertificates");
        this.deleteButton.setEnabled(!this.certList.getSelectedKeyProviders().isEmpty());
    }

    private void layoutIfdPanel() {
        LOG.trace("encrypt : selectcertificates");
        LOG.debug("Updating ifdPanel...");
        this.updateButtonPanel(this.ifdBorderPanel, this.ifdPanel, this.ifdList, this.ifdScrollPane);
        LOG.debug("ifdPanel updated.");
    }

    private void updateGui() {
        LOG.trace("encrypt : selectcertificates");
        this.certList.setKeyProviders(this.selectEncryptCertificatesStep.getKeyProviderToUse());
        this.updateDeleteButton();
        if (this.selectEncryptCertificatesStep.getForm() != null) {
            this.changeRadioComponents();
        }
    }

    public void stateChanged(ChangeEvent event) {
        LOG.trace("encrypt : selectcertificates");
        this.updateGui();
        if (!this.selectEncryptCertificatesStep.isStateComplete()) {
            this.selectEncryptCertificatesStep.skipStep(false);
        }
        this.skipStep.stateChanged(null);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        JScrollBar scrollBar = (JScrollBar)e.getSource();
        if (scrollBar.equals(this.ifdScrollPane.getHorizontalScrollBar())) {
            this.adjustScrollPaneSize(this.ifdScrollPane, scrollBar, this.ifdPanel);
        }
    }

    private void addKeyProviderToUse(KeyProvider keyProviderToAdd, String alias) {
        LOG.trace("encrypt : selectcertificates");
        this.selectEncryptCertificatesStep.addKeyProviderToUse(keyProviderToAdd);
        this.selectEncryptCertificatesStep.setSelectedAlias(keyProviderToAdd, alias);
        LOG.debug("KeyProviderToUse added to step: {}", (Object)keyProviderToAdd.getIFDName());
        LOG.debug("selectedAlias: {}", (Object)alias);
    }

    protected void updateButtonPanel(JPanel borderPanel, JPanel panel, List<IFDCurvedToggleIconButton> buttons, JScrollPane scrollPane) {
        LOG.trace("encrypt : selectcertificates");
        if (borderPanel == null || panel == null || buttons == null || scrollPane == null) {
            throw new IllegalArgumentException("unallowed null value");
        }
        LOG.trace("encrypt : selectcertificates : buttons size : {}", (Object)buttons.size());
        borderPanel.removeAll();
        panel.removeAll();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 5, 0, 5);
        for (int i = 0; i < buttons.size(); ++i) {
            if (i == buttons.size() - 1) {
                gbc.weightx = 1.0;
            }
            LOG.debug("Speicherort [{}] : {}", (Object)i, (Object)buttons.get(i).getText());
            if (buttons.get(i).getText().equals(KeyProviderSource.CARD.name())) {
                gbc.insets = new Insets(0, 10, 0, 0);
                panel.add((Component)this.createErrorLabel(), gbc);
                continue;
            }
            panel.add((Component)buttons.get(i), gbc);
        }
        scrollPane.setViewportView(panel);
        this.adjustScrollPaneSize(scrollPane, scrollPane.getHorizontalScrollBar(), panel);
        borderPanel.setLayout(new GridBagLayout());
        borderPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JLabel createErrorLabel() {
        String errorMessage = Messages.getString((String)"encrypt.selectcertificates.card.not.supported");
        LOG.debug(errorMessage);
        JLabel label = new JLabel(errorMessage);
        label.setFocusable(true);
        label.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)label));
        return label;
    }

    protected void adjustScrollPaneSize(JScrollPane scrollPane, JScrollBar scrollBar, JPanel panel) {
        Dimension preferredPanelSize = panel.getPreferredSize();
        int height = (int)preferredPanelSize.getHeight();
        height = (int)((double)height + scrollBar.getPreferredSize().getHeight());
        scrollPane.setMinimumSize(new Dimension((int)preferredPanelSize.getWidth(), height));
        scrollPane.setPreferredSize(scrollPane.getMinimumSize());
    }

    public void aliasSelected(String alias) {
        LOG.warn("The aliasSelected(String alias) method should not be called in this class as it is not implemented!");
    }

    public void aliasWasSelected() {
        LOG.trace("encrypt : selectcertificates");
        KeyProvider selectedKeyProvider = this.dialog.getCurrentlySelectedKeyProvider();
        if (selectedKeyProvider == null) {
            LOG.warn("An alias was selected even though no KeyProvider was chosen!");
            return;
        }
        selectedKeyProvider.setSelectedAlias(this.dialog.getSelectedAlias());
        this.dialog.setKeyProvider(null);
        this.dialog.setVisible(false);
        this.addKeyProviderToUse(selectedKeyProvider, this.dialog.getSelectedAlias());
    }

    public void removeSelectedKeyProviders() {
        LOG.trace("encrypt : selectcertificates");
        LOG.debug("Removing selected KeyProviders...");
        List selectedKeyProviders = this.certList.getSelectedKeyProviders();
        if (selectedKeyProviders != null && !selectedKeyProviders.isEmpty()) {
            for (KeyProvider keyProvider : selectedKeyProviders) {
                if (keyProvider == null) continue;
                this.selectEncryptCertificatesStep.removeKeyProviderToUse(keyProvider);
            }
            LOG.debug("{}{}", (Object)selectedKeyProviders.size(), (Object)" selected KeyProvider(s) was/were removed.");
        } else {
            LOG.debug("No KeyProviders were selected.");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        LOG.trace("encrypt : selectcertificates");
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm != null && this.certList != null && this.certList.isSelectionModelTheSame(lsm) && !lsm.getValueIsAdjusting()) {
            this.updateDeleteButton();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LOG.trace("encrypt : selectcertificates");
        this.reinitGUI();
    }

    private void reinitGUI() {
        LOG.trace("encrypt : selectcertificates");
        this.initGui();
        this.updateIfdList();
        this.layoutIfdPanel();
        this.layoutGui();
        this.updateGui();
    }

    public SkippableStep getSkippableStep() {
        return this.selectEncryptCertificatesStep;
    }

    public boolean getSkipStep() {
        return this.selectEncryptCertificatesStep.skipStep();
    }

    public void setSkipStep(boolean skip) {
        this.selectEncryptCertificatesStep.skipStep(skip);
        this.stateChanged(null);
    }

    public boolean isStepComplete() {
        LOG.trace("encrypt : selectcertificates");
        if (this.usePassword.isSelected()) {
            return true;
        }
        return this.selectEncryptCertificatesStep.isStateComplete();
    }

    public void setActive(boolean active) {
        LOG.trace("encrypt : selectcertificates");
        if (!active) {
            return;
        }
        LOG.debug("set active : encrypt : selectcertificates");
        LOG.info("\n---------------- Verschl\u00fcsseln/Schl\u00fcssel w\u00e4hlen ... ---------------------------");
        SwingUtilities.invokeLater(() -> {
            if (this.ifdList.isEmpty()) {
                return;
            }
            for (IFDCurvedToggleIconButton button : this.ifdList) {
                if (!button.isEnabled() || !button.isVisible() || !button.isFocusable()) continue;
                LOG.info("Speicherort : {}", (Object)button.getText());
                break;
            }
        });
        LOG.info("\n---------------- Verschl\u00fcsseln/Schl\u00fcssel w\u00e4hlen : ausgew\u00e4hlt ---------------------------");
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.ifdList.isEmpty()) {
            return;
        }
        if (this.certList.getCertTable().getRowCount() == 0) {
            for (IFDCurvedToggleIconButton button : this.ifdList) {
                if (!button.isEnabled() || !button.isVisible() || !button.isFocusable()) continue;
                LOG.info("Speicherort : {}", (Object)button.getText());
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selectEncryptCertificatesStep.usePassword(this.usePassword.isSelected());
        this.stateChanged(null);
    }

    private void changeRadioComponents() {
        if (this.selectEncryptCertificatesStep.usePassword()) {
            this.usePassword.setSelected(true);
            this.selectEncryptCertificatesStep.usePassword(true);
            JComponentUtils.disableAllComponents((JComponent)this.certificateBorderPanel);
            JComponentUtils.disableAllComponents((JComponent)this.ifdPanel);
        } else {
            this.useCertificate.setSelected(true);
            this.selectEncryptCertificatesStep.usePassword(false);
            JComponentUtils.enableAllComponents((JComponent)this.certificateBorderPanel);
            JComponentUtils.enableAllComponents((JComponent)this.ifdPanel);
            for (IFDCurvedToggleIconButton button : this.ifdList) {
                this.updateIFDButton(button);
            }
        }
    }

    private void makeAliasSelection(KeyProvider keyProvider) {
        if (keyProvider == null) {
            return;
        }
        LOG.info("select KeyProvider : {}", (Object)keyProvider.getIFDName());
        List aliases = keyProvider.getAllAliases();
        if (aliases.isEmpty()) {
            return;
        }
        if (aliases.size() == 1) {
            keyProvider.setSelectedAlias((String)aliases.get(0));
            this.addKeyProviderToUse(keyProvider, (String)aliases.get(0));
        } else {
            this.showChooser(keyProvider);
        }
    }

    private void showChooser(KeyProvider keyProvider) {
        this.dialog.setLocation(this.getLocationOnScreen());
        this.dialog.setKeyProvider(keyProvider);
        this.dialog.setVisible(true);
    }

    public void terminalAdded(TerminalModel terminal) {
        LOG.debug("Terminal hinzugefuegt : {}", (Object)terminal.getName());
        this.reinitGUI();
    }

    public void terminalRemoved(TerminalModel terminal) {
        LOG.debug("Terminal entfernt : {}", (Object)terminal.getName());
        this.ifdStatusChanged(terminal);
        this.reinitGUI();
    }

    public void selectAlias(AbstractKeyProvider keyProvider) {
        LOG.debug("Select KeyProvider : {}", (Object)keyProvider.getIFDName());
        this.selectEncryptCertificatesStep.setSelectedKeyProvider(keyProvider);
        this.makeAliasSelection((KeyProvider)keyProvider);
    }

    private void ifdStatusChanged(TerminalModel terminal) {
        List keyProvidersToUse = this.selectEncryptCertificatesStep.getKeyProviderToUse();
        if (keyProvidersToUse == null || keyProvidersToUse.isEmpty()) {
            return;
        }
        for (KeyProvider keyProvider : keyProvidersToUse) {
            if (keyProvider == null || keyProvider.getTerminalModel() == null || !keyProvider.getTerminalModel().equals((Object)terminal)) continue;
            LOG.info("Removing keyProviderToUse {}{}", (Object)keyProvider.getIFDName(), (Object)"...");
            this.selectEncryptCertificatesStep.removeKeyProviderToUse(keyProvider);
        }
    }

    private class SetFocusOnTableAction
    extends AbstractAction {
        private static final long serialVersionUID = -6664838861129574418L;

        @Override
        public void actionPerformed(ActionEvent arg0) {
        }
    }
}

