/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.encrypt.gui.dialog.config.components;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.encrypt.control.process.impl.EncryptConfig;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ProcessConfigComponent;
import de.bos_bremen.ecard.client.gui.view.component.GridBagPanel;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptConfigPanel
extends ProcessConfigComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptConfigPanel.class);
    private final ProcessI process;
    private JPanel content;
    private JCheckBox useDeleteSource;
    private LicenceTyp licenceTyp = null;

    public EncryptConfigPanel(ProcessI process, LicenceTyp licenceTyp) {
        this.process = process;
        this.licenceTyp = licenceTyp;
        this.initGUI();
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)((Object)this));
    }

    private void initGUI() {
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)this.getDeleteSourcePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.content = new JPanel(new GridBagLayout());
        this.content.add((Component)result, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JComponent getDeleteSourcePanel() {
        double[] colWeights = new double[]{1.0};
        GridBagPanel result = new GridBagPanel(colWeights);
        result.setBorder((Border)ComponentUtils.createTitledCurvedBorder((String)"encrypt.delete_source"));
        JLabel description = new JLabel(Messages.getString((String)"config.dialog.encrypt.delete_source.label"));
        description.setFocusable(true);
        description.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)description));
        this.useDeleteSource = new JCheckBox(" " + Messages.getString((String)"config.dialog.encrypt.delete_source.title"));
        JPanel useDeleteSourceCheckBoxPanel = ComponentUtils.layoutCheckbox((JCheckBox)this.useDeleteSource);
        Insets insets = new Insets(5, 20, 10, 5);
        result.addComponent((Container)result, (Component)description, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, insets, 0, 0));
        result.addComponent((Container)result, (Component)useDeleteSourceCheckBoxPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        return result;
    }

    public String getHelpContext() {
        return Messages.getString((String)"config.dialog.encrypt.helpcontext");
    }

    public Icon getIcon() {
        return ComponentUtils.getIcon((String)"config.dialog.encrypt");
    }

    public String getTitle() {
        return Messages.getString((String)"config.dialog.encrypt");
    }

    public void load() {
        log.trace("load {} : EncryptConfig -> GUI ...", (Object)this.getTitle());
        EncryptConfig encryptConfig = (EncryptConfig)this.process.getConfig();
        this.useDeleteSource.setSelected(encryptConfig.useDeleteSource());
    }

    public void save() {
        log.trace("save {} : GUI -> EncryptConfig ...", (Object)this.getTitle());
        EncryptConfig encryptConfig = (EncryptConfig)this.process.getConfig();
        encryptConfig.useDeleteSource(this.useDeleteSource.isSelected());
    }

    public JComponent getView() {
        return this.content;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.content.removeAll();
        this.initGUI();
        this.content.revalidate();
    }

    public LicenceTyp getLicenceTyp() {
        return this.licenceTyp;
    }

    public void setLicenceTyp(LicenceTyp licenceTyp) {
        this.licenceTyp = licenceTyp;
    }
}

