/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.encrypt.gui;

import de.bos_bremen.ecard.client.AbstractProcessHelper;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.encrypt.control.process.impl.EncryptProcess;
import de.bos_bremen.ecard.client.encrypt.model.formular.process.EncryptProcessFormular;
import de.bos_bremen.ecard.client.model.BooleanTriState;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.HashedFile;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptProcessHelper
extends AbstractProcessHelper {
    private static final Logger LOG = LogManager.getLogger(EncryptProcessHelper.class);

    public ProcessFormular fillEncryptFormular(String serialnumber, String[] inputFile, TargetFolderType targetFolderType, String outputFolder, BooleanTriState createZipArchiv, BooleanTriState usePassword, boolean replaceFiles) {
        ProcessFormular processesFormular = null;
        ProcessI process = Document.getInstance().getProcessFactory().getProcess(EncryptProcess.PROCESS_NAME);
        if (process != null && (processesFormular = Document.getInstance().getProcessFactory().getProcessesFormular(process)) instanceof EncryptProcessFormular) {
            EncryptProcessFormular encryptFormular = (EncryptProcessFormular)processesFormular;
            encryptFormular.addBlockRequest();
            encryptFormular.setSerialnumber(serialnumber);
            ArrayList inputFileList = new ArrayList();
            try {
                this.getInputfiles(inputFile, inputFileList, true);
            }
            catch (SignerException e) {
                LOG.error("", (Throwable)e);
            }
            if (!inputFileList.isEmpty()) {
                ArrayList<HashedFile> inputFiles = new ArrayList<HashedFile>();
                for (ProcessSignedFile processSignedFile : inputFileList) {
                    inputFiles.add(processSignedFile.getFile());
                }
                encryptFormular.setSelectedFiles(inputFiles, replaceFiles);
            } else if (replaceFiles) {
                encryptFormular.removeAllFiles();
            }
            if (!targetFolderType.equals((Object)TargetFolderType.useDefault)) {
                encryptFormular.setTargetFolderType(TargetFolderType.valueOf((String)targetFolderType.toString()));
            }
            if (!"".equals(outputFolder)) {
                encryptFormular.setTargetFolder(outputFolder);
            }
            if (!BooleanTriState.useDefault.equals((Object)createZipArchiv)) {
                encryptFormular.createZipArchiv(BooleanTriState.yes.equals((Object)createZipArchiv));
            }
            if (!BooleanTriState.useDefault.equals((Object)usePassword)) {
                encryptFormular.usePassword(BooleanTriState.yes.equals((Object)usePassword));
            }
            encryptFormular.removeBlockRequest();
        }
        LOG.info("fillEncryptFormular:return {}", processesFormular);
        return processesFormular;
    }
}

