/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.encrypt.control.step;

import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.encrypt.gui.step.SelectFilesView;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.ProcessFileSeen;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.formular.steps.SelectFilesFormular;
import de.bos_bremen.ecard.client.model.formular.steps.StepFormular;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SelectFiles
extends Step {
    protected SelectFilesFormular formular;

    public SelectFiles() {
        super(StepFactory.StepName.selectfiles);
    }

    public void setJComponent() {
        this.viewPanel = new SelectFilesView(this);
    }

    public List<ProcessFileSeen> getFiles() {
        ArrayList files = null;
        if (this.formular != null) {
            files = this.formular.getSelectedFiles();
        }
        if (files == null) {
            files = new ArrayList();
        }
        return files;
    }

    public void addFile(ProcessFileSeen file) {
        if (file == null) {
            return;
        }
        this.formular.addSelectedFile(file);
        this.notifyAllStateChangeListener(null, file);
    }

    public void addFiles(ProcessFileSeen[] files) {
        if (files == null || files.length == 0) {
            return;
        }
        for (ProcessFileSeen processSignedFile : files) {
            this.formular.addSelectedFile(processSignedFile);
        }
    }

    public boolean removeFile(ProcessFileSeen fileToRemove) {
        return this.formular.removeSelectedFile(fileToRemove);
    }

    public boolean removeAllFiles() {
        if (this.formular == null || this.formular.getSelectedFiles() == null) {
            return false;
        }
        ArrayList<ProcessFileSeen> filesToRemove = new ArrayList<ProcessFileSeen>();
        for (ProcessFileSeen pfs : this.formular.getSelectedFiles()) {
            filesToRemove.add(pfs);
        }
        for (ProcessFileSeen file : filesToRemove) {
            this.formular.removeSelectedFile(file);
        }
        return true;
    }

    public StepFormular getForm() {
        return this.formular;
    }

    public boolean setProcessFormular(StepFormular f) {
        if (!(f instanceof SelectFilesFormular)) {
            return false;
        }
        SelectFilesFormular selectFilesFormular = (SelectFilesFormular)f;
        if (!super.setProcessFormular(f)) {
            return false;
        }
        this.formular = selectFilesFormular;
        if (this.formular.getSelectedFiles() != null) {
            this.notifyAllStateChangeListener(this.formular.getSelectedFiles(), null);
        }
        return true;
    }

    public boolean isStateComplete() {
        return !this.getFiles().isEmpty();
    }

    public void setFileAsSeen(ProcessFileSeen file) {
        try {
            file.setSeen(true);
        }
        catch (SignerException e) {
            Document.getInstance().reportError(e, false, new Object[0]);
        }
    }

    public HashMap<String, LicenceTyp> getDefaultLicenceTypes() {
        HashMap<String, LicenceTyp> processLicenceTypes = new HashMap<String, LicenceTyp>();
        processLicenceTypes.put(this.getLicenceTypKey(), LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/addfiles", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/removefiles", LicenceTyp.enable);
        return processLicenceTypes;
    }
}

