/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.encrypt.control.step;

import de.bos_bremen.ecard.client.control.step.KeyProviderStep;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.encrypt.gui.step.SelectCertificatesView;
import de.bos_bremen.ecard.client.encrypt.model.formular.process.impl.EncryptFormular;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.formular.steps.StepFormular;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import java.util.HashMap;

public class SelectEncryptCertificates
extends KeyProviderStep {
    private static final String USE_PASSWORD_KEY = "usePassword";

    public SelectEncryptCertificates() {
        super(StepFactory.StepName.selectcertificates, KeyUsage.ENCRYPT);
    }

    public void setJComponent() {
        this.viewPanel = new SelectCertificatesView(this);
    }

    public HashMap<String, LicenceTyp> getDefaultLicenceTypes() {
        HashMap<String, LicenceTyp> processLicenceTypes = new HashMap<String, LicenceTyp>();
        processLicenceTypes.put(this.getLicenceTypKey(), LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/software", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/certificate", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/certificate/software", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/certificate/encryptmultiaddressee", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/password", LicenceTyp.enable);
        return processLicenceTypes;
    }

    public boolean setProcessFormular(StepFormular form) {
        if (!(form instanceof EncryptFormular)) {
            return false;
        }
        if (!super.setProcessFormular(form)) {
            return false;
        }
        this.form = form;
        Boolean usePassword = ((EncryptFormular)this.form).usePassword();
        if (usePassword == null) {
            ((EncryptFormular)this.form).usePassword(Boolean.valueOf(this.stepProperties.getProperty(USE_PASSWORD_KEY)));
        }
        if (usePassword == null) {
            usePassword = false;
        }
        if (usePassword.booleanValue()) {
            this.removeAllPropertiesProvider();
        }
        return true;
    }

    public boolean usePassword() {
        StepFormular stepFormular = this.form;
        if (!(stepFormular instanceof EncryptFormular)) {
            return false;
        }
        EncryptFormular encryptFormular = (EncryptFormular)stepFormular;
        if (encryptFormular.usePassword() == null) {
            return false;
        }
        return encryptFormular.usePassword();
    }

    public void usePassword(boolean value) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof EncryptFormular) {
            EncryptFormular encryptFormular = (EncryptFormular)stepFormular;
            encryptFormular.usePassword(value);
            this.stepProperties.put((Object)USE_PASSWORD_KEY, (Object)value);
        }
    }

    public boolean isStateComplete() {
        StepFormular stepFormular = this.form;
        if (!(stepFormular instanceof EncryptFormular)) {
            return false;
        }
        EncryptFormular encryptFormular = (EncryptFormular)stepFormular;
        if (encryptFormular.usePassword() == null) {
            return super.isStateComplete();
        }
        if (encryptFormular.usePassword().booleanValue()) {
            return true;
        }
        return super.isStateComplete();
    }

    public boolean isSaveAsStandard() {
        String value = this.stepProperties.getProperty("isSaveAsStandardProperty");
        return Boolean.parseBoolean(value);
    }
}

