/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.encrypt.control.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.control.step.WorkingResult;
import de.bos_bremen.ecard.client.control.step.working.WorkingStep;
import de.bos_bremen.ecard.client.encrypt.EncryptFunction;
import de.bos_bremen.ecard.client.encrypt.control.process.impl.EncryptConfig;
import de.bos_bremen.ecard.client.encrypt.gui.step.EncryptView;
import de.bos_bremen.ecard.client.encrypt.model.formular.process.EncryptProcessFormular;
import de.bos_bremen.ecard.client.encrypt.model.formular.step.SelectEncryptTargetFolderFormular;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.dialog.PasswordDialog;
import de.bos_bremen.ecard.client.gui.dialog.RenameFileDialog;
import de.bos_bremen.ecard.client.gui.view.component.filechooser.FileChooserFactory;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.DetachableFile;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.ProcessFileSeen;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.FileExistException;
import de.bos_bremen.ecard.client.model.error.FileInUseException;
import de.bos_bremen.ecard.client.model.formular.steps.SelectTargetFolderFormular;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import de.bos_bremen.ecard.client.model.licence.Licence;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.util.XMLProperties;
import de.governikus.csl.ECardProgressListener;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Encrypt
extends WorkingStep {
    private static final Logger LOG = LogManager.getLogger(Encrypt.class);
    boolean cancelCreateZipFile = false;
    private byte[] bs;
    private int zipEntries;
    private int countExistZip;

    public Encrypt() {
        super(StepFactory.StepName.encrypt);
    }

    public void setJComponent() {
        this.viewPanel = new EncryptView(this);
    }

    public void setDefaults(XMLProperties propertiesForNode) {
        super.setDefaults(propertiesForNode);
        this.notifyAllStateChangeListener(null, propertiesForNode);
    }

    public void run(SubsequentProcess process) {
        this.reset();
        EncryptProcessFormular encryptFormular = (EncryptProcessFormular)this.form;
        this.buildWorkingResult();
        Document documentInstance = Document.getInstance();
        if (!this.canMoveToTargetFolder(encryptFormular)) {
            this.finished(process, true, documentInstance.getWorkingResults().size());
            return;
        }
        documentInstance.notifyProgressListeners(ECardProgressListener.ProgressType.ENCRYPT_CONTENT, -1);
        int errorCounter = 0;
        boolean cancelled = false;
        List workingResultList = documentInstance.getWorkingResults();
        Boolean createZipArchiv = ((SelectEncryptTargetFolderFormular)this.form).createZipArchiv();
        if (createZipArchiv != null && createZipArchiv.booleanValue()) {
            if (!this.runZipProcessWasSuccessfully(documentInstance)) {
                ++errorCounter;
                cancelled = true;
            }
        } else {
            for (WorkingResult workingResult : workingResultList) {
                if (!this.checkSourceFileBeforeProcess(workingResult, encryptFormular.getTargetFolderType())) {
                    cancelled = documentInstance.getLastReportedErrorObject().abortError();
                    ++errorCounter;
                    continue;
                }
                documentInstance.resetLastErrorObject();
                if (cancelled) {
                    documentInstance.reportError(ErrorCode.FILE_CANCELLED, false, new Object[]{workingResult.getSourceFile()});
                    workingResult.setCurrentState(WorkingResult.Status.ABORTED);
                    continue;
                }
                workingResult.setCurrentState(WorkingResult.Status.WORKING);
                if (!this.encrypt(encryptFormular, workingResult)) {
                    cancelled = true;
                    continue;
                }
                if (workingResult.getCurrentState().equals((Object)WorkingResult.Status.ERROR)) {
                    ++errorCounter;
                }
                this.notifyProgressListener(null, workingResultList);
            }
        }
        this.displayFinishDialog(cancelled, errorCounter);
        this.state = WorkingStep.WorkingState.CALLING_SUBSEQUENT_PROCESS;
        if (process != null) {
            super.callSubsequentProcess(process);
        }
        this.deleteOriginalFiles(workingResultList, createZipArchiv, cancelled);
        this.state = WorkingStep.WorkingState.FINISHED;
        this.notifyProgressListener(null, workingResultList);
        this.notifyAllStateChangeListener(null, workingResultList);
        this.parent.isFinished(true);
    }

    private void deleteOriginalFiles(List<WorkingResult> workingResultList, Boolean createZipArchiv, boolean cancelled) {
        if (cancelled) {
            return;
        }
        EncryptConfig config = (EncryptConfig)this.parent.getConfig();
        if (!config.useDeleteSource()) {
            return;
        }
        for (WorkingResult workingResult : workingResultList) {
            DetachableFile sourceFile = workingResult.getSourceFile();
            LOG.debug("source file to delete : {}", (Object)sourceFile);
            if (sourceFile == null || !sourceFile.exists()) continue;
            if (Boolean.TRUE.equals(createZipArchiv)) {
                if (sourceFile.delete()) continue;
                LOG.info("could not delete file: {}", (Object)sourceFile);
                continue;
            }
            File targetFile = (File)workingResult.getResult().get(0);
            LOG.debug("target file: {}", (Object)targetFile);
            if (targetFile == null) continue;
            if (!sourceFile.delete()) {
                LOG.debug("could not delete folder: {}", (Object)sourceFile);
                continue;
            }
            LOG.info("source file deleted : {}", (Object)sourceFile);
        }
    }

    private boolean runZipProcessWasSuccessfully(Document documentInstance) {
        EncryptProcessFormular encryptFormular = (EncryptProcessFormular)this.form;
        List workingResultList = documentInstance.getWorkingResults();
        File zipFile = this.createZipArchiv(workingResultList);
        if (zipFile == null) {
            WorkingResult.Status status = WorkingResult.Status.ERROR;
            if (this.lastRepeat == null || this.lastRepeat.equals((Object)WorkingStep.Repeat.CANCEL)) {
                status = WorkingResult.Status.ABORTED;
            }
            for (WorkingResult workingResult : workingResultList) {
                documentInstance.reportError(ErrorCode.FILE_CANCELLED, false, new Object[]{workingResult.getSourceFile()});
                workingResult.setCurrentState(status);
            }
            return false;
        }
        DetachableFile detachableFile = new DetachableFile(zipFile);
        WorkingResult zipWorking = new WorkingResult(detachableFile);
        zipWorking.setCurrentState(WorkingResult.Status.WORKING);
        zipWorking.setZipped(true);
        workingResultList.add(zipWorking);
        if (!this.checkSourceFileBeforeProcess(zipWorking, encryptFormular.getTargetFolderType())) {
            return false;
        }
        boolean result = this.encrypt(encryptFormular, zipWorking);
        this.notifyProgressListener(null, workingResultList);
        try {
            Files.delete(zipFile.toPath());
        }
        catch (IOException e) {
            LOG.debug("konnte {}{}", (Object)zipFile.getAbsolutePath(), (Object)" nicht loeschen");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean encrypt(EncryptProcessFormular encryptFormular, WorkingResult workingResult) {
        String resultFileName = workingResult.getSourceFile() + (Boolean.TRUE.equals(encryptFormular.usePassword()) ? ".enz" : ".p7m");
        LOG.debug("Encrypt ResultFileName : {}", (Object)resultFileName);
        WorkingStep.Repeat currentRepeat = this.canMoveDocumentsToTargetFolder(encryptFormular.getTargetFolderType(), encryptFormular.getTargetFolder(), encryptFormular.getLocalCopyFolder(), (File)workingResult.getSourceFile(), resultFileName, false, false);
        LOG.debug("Encrypt Repeat : {}", (Object)currentRepeat);
        if (WorkingStep.Repeat.CANCEL == this.lastRepeat) {
            workingResult.setCurrentState(WorkingResult.Status.ABORTED);
            return false;
        }
        if (WorkingStep.Repeat.SKIP.equals((Object)currentRepeat) || WorkingStep.Repeat.SKIP_ALL.equals((Object)currentRepeat)) {
            workingResult.setCurrentState(WorkingResult.Status.ABORTED);
            return false;
        }
        try {
            File encryptedFiles = Boolean.TRUE.equals(encryptFormular.usePassword()) ? this.passwordEncryption(encryptFormular, workingResult) : this.certificateEncryption(encryptFormular, workingResult);
            if (encryptedFiles != null) {
                boolean bl = true;
                return bl;
            }
            workingResult.setCurrentState(WorkingResult.Status.ABORTED);
            boolean bl = false;
            return bl;
        }
        catch (FileExistException | FileInUseException ex) {
            LOG.info((Object)ex, ex);
            workingResult.setCurrentState(WorkingResult.Status.ABORTED);
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            workingResult.setCurrentState(WorkingResult.Status.ERROR);
        }
        finally {
            this.notifyProgressListener(null, workingResult);
        }
        return true;
    }

    private File certificateEncryption(EncryptProcessFormular encryptFormular, WorkingResult workingResult) throws IOException, FileInUseException, FileExistException {
        List keyProviderList = encryptFormular.getKeyProvider(KeyUsage.ENCRYPT);
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        for (KeyProvider keyProvider : keyProviderList) {
            X509Certificate certificate = keyProvider.getCertificate();
            certificateList.add(certificate);
        }
        DetachableFile sourceFile = workingResult.getSourceFile();
        File tempEncryptFile = new File(Encrypt.getTempFolder(), sourceFile.getName() + ".p7m");
        try {
            EncryptFunction.certificateEncryption(certificateList, (File)sourceFile, tempEncryptFile, "BC");
            File storeFile = this.moveResultDocumentToTargetFolder(encryptFormular, (File)workingResult.getSourceFile(), tempEncryptFile, false, false, false);
            workingResult.addResultFile(storeFile);
            workingResult.setCurrentState(WorkingResult.Status.FINISHED);
            Document.getInstance().reportError(ErrorCode.FILE_PROCESSED, true, new Object[]{workingResult.getSourceFile()});
            this.notifyProgressListener(null, workingResult);
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
            workingResult.setCurrentState(WorkingResult.Status.ERROR);
            this.notifyProgressListener(null, workingResult);
            throw new IOException(ex.getMessage());
        }
        return tempEncryptFile;
    }

    private File passwordEncryption(EncryptProcessFormular encryptFormular, WorkingResult workingResult) throws IOException, FileInUseException, FileExistException {
        PasswordDialog encryptPasswordDialog = new PasswordDialog(workingResult.getSourceFile().getName(), true);
        encryptPasswordDialog.setVisible(true);
        if (!encryptPasswordDialog.usePassword()) {
            return null;
        }
        DetachableFile sourceFile = workingResult.getSourceFile();
        File tempEncryptFile = new File(Encrypt.getTempFolder(), sourceFile.getName() + ".enz");
        try {
            EncryptFunction.passwordEncryption(encryptPasswordDialog.getPassword(), (File)sourceFile, tempEncryptFile);
            File storeFile = this.moveResultDocumentToTargetFolder(encryptFormular, (File)workingResult.getSourceFile(), tempEncryptFile, false, false, false);
            workingResult.addResultFile(storeFile);
            workingResult.setCurrentState(WorkingResult.Status.FINISHED);
            Document.getInstance().reportError(ErrorCode.FILE_PROCESSED, true, new Object[]{workingResult.getSourceFile()});
            this.notifyProgressListener(null, workingResult);
            return tempEncryptFile;
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
            workingResult.setCurrentState(WorkingResult.Status.ERROR);
            this.notifyProgressListener(null, workingResult);
            throw new IOException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createZipArchiv(List<WorkingResult> workingResultList) {
        this.lastRepeat = null;
        ZipOutputStream zout = null;
        File zipFile = null;
        this.zipEntries = 0;
        String targetFileFolder = "";
        try {
            while (zipFile == null && !this.cancelCreateZipFile) {
                zipFile = this.chooseZipArchivFile();
            }
            if (zipFile == null) {
                this.cancelCreateZipFile = false;
                Document.getInstance().reportError(ErrorCode.CANNOT_CREATE_ZIP, true, new Object[0]);
                File file = null;
                return file;
            }
            LOG.debug("Encrypt ResultFileName : {}", (Object)zipFile);
            WorkingStep.Repeat currentRepeat = this.canMoveDocumentsToTargetFolder(((SelectTargetFolderFormular)this.form).getTargetFolderType(), ((SelectTargetFolderFormular)this.form).getTargetFolder(), ((SelectTargetFolderFormular)this.form).getLocalCopyFolder(), zipFile, zipFile.getName(), false, false);
            LOG.debug("Encrypt Repeat : {}", (Object)currentRepeat);
            if (WorkingStep.Repeat.CANCEL == this.lastRepeat) {
                LOG.trace("reportError ...");
                Document.getInstance().reportError(ErrorCode.CANNOT_CREATE_ZIP, true, new Object[0]);
                File file = null;
                return file;
            }
            if (WorkingStep.Repeat.SKIP.equals((Object)currentRepeat) || WorkingStep.Repeat.SKIP_ALL.equals((Object)currentRepeat)) {
                LOG.trace("reportError ...");
                Document.getInstance().reportError(ErrorCode.CANNOT_CREATE_ZIP, true, new Object[0]);
                File file = null;
                return file;
            }
            FileOutputStream ostr = new FileOutputStream(zipFile);
            this.bs = new byte[512];
            zout = new ZipOutputStream(ostr);
            for (WorkingResult workingResult : workingResultList) {
                try (FileInputStream in = new FileInputStream((File)workingResult.getSourceFile());){
                    ZipEntry e = new ZipEntry(workingResult.getSourceFile().getName());
                    zout.putNextEntry(e);
                    int len = 0;
                    while ((len = ((InputStream)in).read(this.bs)) != -1) {
                        zout.write(this.bs, 0, len);
                    }
                    zout.closeEntry();
                    workingResult.setCurrentState(WorkingResult.Status.ZIPPED);
                    ++this.zipEntries;
                }
                catch (FileNotFoundException fnfe) {
                    LOG.info("", (Throwable)fnfe);
                    LOG.trace("reportError ...");
                    Document.getInstance().reportError(ErrorCode.FILE_NOT_FOUND, true, new Object[]{workingResult.getSourceFile()});
                    workingResult.setErrorObject(Document.getInstance().getLastReportedErrorObject());
                    workingResult.setCurrentState(WorkingResult.Status.ERROR);
                }
                catch (ZipException ex) {
                    LOG.info((Object)ex, (Throwable)ex);
                    if (!ex.getMessage().startsWith("duplicate entry")) continue;
                    this.zipEntryExist(workingResult, zout);
                }
            }
            Utils.closeStream((Closeable)zout);
        }
        catch (FileNotFoundException e) {
            LOG.trace("reportError ...");
            Document.getInstance().reportError(ErrorCode.CANNOT_WRITE_TO_FOLDER, true, new Object[]{targetFileFolder});
            for (WorkingResult workingResult : workingResultList) {
                workingResult.setErrorObject(Document.getInstance().getLastReportedErrorObject());
            }
            zipFile = null;
        }
        catch (IOException ex) {
            LOG.trace("reportError ...");
            Document.getInstance().reportError(ErrorCode.UNKNOWN, true, new Object[]{zipFile.getAbsolutePath()});
            for (WorkingResult workingResult : workingResultList) {
                workingResult.setErrorObject(Document.getInstance().getLastReportedErrorObject());
            }
            zipFile = null;
        }
        finally {
            Utils.closeStream(zout);
        }
        if (this.zipEntries == 0) {
            LOG.error("Es wurden keine Dateien in das Zip-Archiv eingebunden");
            if (zipFile != null) {
                try {
                    Files.delete(zipFile.toPath());
                }
                catch (IOException e) {
                    LOG.debug("{}{}", (Object)zipFile.getAbsolutePath(), (Object)" konnte nicht geloescht werden");
                    zipFile.deleteOnExit();
                }
            }
            zipFile = null;
        }
        return zipFile;
    }

    private void zipEntryExist(WorkingResult workingResult, ZipOutputStream zout) {
        boolean ready = false;
        ++this.countExistZip;
        do {
            RenameFileDialog dialog = new RenameFileDialog((File)workingResult.getSourceFile(), true);
            WorkingStep.Repeat tmpRepeat = dialog.showDialog();
            File copyFile = null;
            switch (tmpRepeat) {
                case ZIP_ENTRY_RENAME: {
                    copyFile = new File("(" + this.countExistZip + ")" + workingResult.getSourceFile().getName());
                    break;
                }
                case CANCEL: {
                    copyFile = null;
                    workingResult.setCurrentState(WorkingResult.Status.ABORTED);
                    break;
                }
            }
            if (copyFile != null) {
                try (FileInputStream in = new FileInputStream((File)workingResult.getSourceFile());){
                    ZipEntry e = new ZipEntry(copyFile.getName());
                    zout.putNextEntry(e);
                    int len = 0;
                    while ((len = ((InputStream)in).read(this.bs)) != -1) {
                        zout.write(this.bs, 0, len);
                    }
                    zout.closeEntry();
                    workingResult.setCurrentState(WorkingResult.Status.ZIPPED);
                    ++this.zipEntries;
                    ready = true;
                }
                catch (IOException ex) {
                    LOG.info((Object)ex, (Throwable)ex);
                    if (!ex.getMessage().startsWith("duplicate entry")) continue;
                    this.zipEntryExist(workingResult, zout);
                }
                continue;
            }
            ready = true;
        } while (!ready);
    }

    private File chooseZipArchivFile() {
        EncryptProcessFormular encryptFormular = (EncryptProcessFormular)this.form;
        File lastDir = null;
        if (encryptFormular.getTargetFolderType().equals((Object)TargetFolderType.sameAsSourceFolder)) {
            lastDir = ((ProcessFileSeen)encryptFormular.getSelectedFiles().get(0)).getFile().getAbsoluteFile();
        } else if (encryptFormular.getTargetFolderType().equals((Object)TargetFolderType.oneSpecial)) {
            lastDir = new File(encryptFormular.getTargetFolder());
        }
        JFileChooser chooser = FileChooserFactory.defaultFileChooser();
        if (lastDir != null) {
            chooser.setCurrentDirectory(lastDir);
        }
        if (this.getParent().getCurrentStep().getApplicationProperties().getProperty("last_filename", null) != null) {
            if (lastDir != null) {
                chooser.setSelectedFile(new File(lastDir, this.getParent().getCurrentStep().getApplicationProperties().getProperty("last_filename", null)));
            } else {
                chooser.setSelectedFile(new File(this.getParent().getCurrentStep().getApplicationProperties().getProperty("last_filename", null)));
            }
        }
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName().toLowerCase();
                if (f.isDirectory()) {
                    return true;
                }
                return name.endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return ".ZIP";
            }
        });
        chooser.setMinimumSize(Document.getInstance().getFrame().getMinimumSize());
        chooser.setPreferredSize(GUIUtils.createRelativeToParent((Dimension)Document.getInstance().getFrame().getMinimumSize()));
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(Messages.getString((String)"step.selecttargetfolder.targetdir.choosezipFolder"));
        File returnFile = null;
        if (chooser.showSaveDialog((Component)Document.getInstance().getFrame()) == 0) {
            if (!chooser.getSelectedFile().getName().endsWith(".zip")) {
                File chooserFile = chooser.getSelectedFile();
                returnFile = new File(chooserFile.getAbsolutePath() + ".zip");
            } else {
                returnFile = chooser.getSelectedFile();
            }
            this.getParent().getCurrentStep().setApplicationProperty("last_filename", returnFile.getPath());
        } else {
            this.cancelCreateZipFile = true;
        }
        return returnFile;
    }

    public SubsequentProcess getDefaultSubsequentProcess() {
        return Config.getInstance().getSubsequentProcess(this.parent.getSubsequentProcessUID());
    }

    public HashMap<String, LicenceTyp> getDefaultLicenceTypes() {
        HashMap<String, LicenceTyp> processLicenceTypes = new HashMap<String, LicenceTyp>();
        processLicenceTypes.put(this.getLicenceTypKey(), LicenceTyp.enable);
        processLicenceTypes.put(Licence.Keys.general_actions_settings_subsequentprocess.toString(), LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/encryptalgorithm", LicenceTyp.enable);
        return processLicenceTypes;
    }

    private boolean canMoveToTargetFolder(EncryptProcessFormular encryptFormular) {
        if (encryptFormular.getTargetFolderType() != TargetFolderType.oneSpecial) {
            return true;
        }
        if (Utils.canWrite((String)encryptFormular.getTargetFolder())) {
            return true;
        }
        Document documentInstance = Document.getInstance();
        documentInstance.reportError(ErrorCode.CANNOT_WRITE_TO_FOLDER, false, new Object[]{encryptFormular.getTargetFolder()});
        List workingResultList = documentInstance.getWorkingResults();
        for (WorkingResult workingResult : workingResultList) {
            workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
            workingResult.setCurrentState(WorkingResult.Status.ERROR);
        }
        return false;
    }

    private void reset() {
        this.lastRepeat = null;
        this.fullRepeat = null;
        Document.getInstance().resetLastErrorObject();
    }

    private void finished(SubsequentProcess process, boolean cancelled, int errorCounter) {
        Document documentInstance = Document.getInstance();
        List workingResultList = documentInstance.getWorkingResults();
        documentInstance.notifyProgressListeners(ECardProgressListener.ProgressType.ENCRYPT_CONTENT, 1);
        this.displayFinishDialog(cancelled, errorCounter);
        this.state = WorkingStep.WorkingState.CALLING_SUBSEQUENT_PROCESS;
        if (process != null) {
            super.callSubsequentProcess(process);
        }
        this.state = WorkingStep.WorkingState.FINISHED;
        this.notifyProgressListener(null, workingResultList);
        this.notifyAllStateChangeListener(null, workingResultList);
        this.parent.isFinished(true);
    }
}

