/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.encrypt.control.process.impl;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.process.impl.Process;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.encrypt.control.process.impl.EncryptConfig;
import de.bos_bremen.ecard.client.encrypt.control.step.Encrypt;
import de.bos_bremen.ecard.client.encrypt.control.step.SelectEncryptCertificates;
import de.bos_bremen.ecard.client.encrypt.control.step.SelectFiles;
import de.bos_bremen.ecard.client.encrypt.control.step.SelectTargetDir;
import de.bos_bremen.ecard.client.encrypt.gui.dialog.config.components.EncryptConfigPanel;
import de.bos_bremen.ecard.client.encrypt.gui.dialog.config.components.EncryptResetPanel;
import de.bos_bremen.ecard.client.encrypt.model.formular.process.EncryptProcessFormular;
import de.bos_bremen.ecard.client.encrypt.model.formular.process.impl.EncryptFormular;
import de.bos_bremen.ecard.client.gui.dialog.config.ProcessConfigComponent;
import de.bos_bremen.ecard.client.gui.dialog.config.components.ResetConfigPanel;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import de.bos_bremen.ecard.client.util.XMLProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class EncryptProcess
extends Process {
    public static final ProcessName PROCESS_NAME = new ProcessName("encrypt", 2);
    private EncryptConfig encryptConfig;
    private List<ProcessConfigComponent> processConfigComponent = null;

    public EncryptProcess() {
        super(null);
        this.getConfig();
        this.addStep(new SelectFiles());
        this.addStep((Step)new SelectEncryptCertificates());
        this.addStep((Step)new SelectTargetDir());
        this.addStep((Step)new Encrypt());
    }

    private void addConfigComponents() {
        this.processConfigComponent = new ArrayList<ProcessConfigComponent>();
        String licenceTypKey = "process/encrypt";
        EncryptConfigPanel encryptConfigPanel = new EncryptConfigPanel((ProcessI)this, Document.getInstance().getProductFunctions().getLicence(licenceTypKey + "/encryptalgorithm"));
        this.processConfigComponent.add(encryptConfigPanel);
    }

    public ProcessName getProcessName() {
        return PROCESS_NAME;
    }

    public boolean startProcess(ProcessFormular processFormular) {
        super.startProcess(processFormular);
        if (processFormular instanceof EncryptProcessFormular) {
            this.form = processFormular;
            return true;
        }
        return false;
    }

    protected boolean couldHideAfterProcess() {
        return true;
    }

    public boolean canOpenProcessFile() {
        return true;
    }

    public boolean canOpenResultFile() {
        return false;
    }

    public ProcessFormular createNewFormular() {
        return new EncryptFormular();
    }

    public ProcessFormular createNewFormular(ProcessFormular arg0) {
        ProcessFormular processFormular = this.form;
        if (processFormular instanceof EncryptFormular) {
            EncryptFormular encryptFormular = (EncryptFormular)processFormular;
            return new EncryptFormular(encryptFormular);
        }
        return new EncryptFormular();
    }

    public List<ProcessConfigComponent> getConfigComponents() {
        if (this.processConfigComponent == null) {
            this.addConfigComponents();
        }
        return this.processConfigComponent;
    }

    public ResetConfigPanel getResetConfigPanel() {
        return new EncryptResetPanel(this.getProcessName(), false);
    }

    public EncryptConfig getConfig() {
        if (this.encryptConfig == null) {
            this.encryptConfig = new EncryptConfig();
        }
        return this.encryptConfig;
    }

    public XMLProperties getProperties() {
        XMLProperties properties = super.getProperties();
        this.getConfig().store(properties);
        return properties;
    }

    public void setProperties(XMLProperties properties) {
        super.setProperties(properties);
        this.getConfig().load(properties);
    }

    public void addProcessRessourceBundle() {
        String bundleName = "de.bos_bremen.ecard.client.encrypt.encrypt";
        ResourceBundle erb = ResourceBundle.getBundle(bundleName);
        Messages.addResourceBundle((String)bundleName, (ResourceBundle)erb);
    }

    public boolean canRunProcess() {
        return true;
    }

    public boolean canShowPopUpMenu() {
        return false;
    }

    public JPopupMenu getPopUpMenu(JTable table, File file) {
        return null;
    }
}

