/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.encrypt;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.gov2.jca_provider.eccipher.EcTempKeyPairGenerator;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyAgreeRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.operator.OutputEncryptor;

public class EncryptFunction {
    private static final Logger LOG = LogManager.getLogger(EncryptFunction.class);
    private static ASN1ObjectIdentifier defaultAlgo = CMSAlgorithm.AES256_GCM;
    private static final String KEY_ALGORITHM_EC = "EC";
    public static final int BUFFER_SIZE = 8192;
    private static final Map<ASN1ObjectIdentifier, ASN1ObjectIdentifier> mapEcWrapAlgorithm;

    private EncryptFunction() {
        throw new IllegalStateException("Utility class");
    }

    private static void addCertificate(List<RecipientInfoGenerator> certificates, X509Certificate certificate, String providerName) throws Exception {
        PublicKey publicKey = certificate.getPublicKey();
        if (publicKey.getAlgorithm().equals(KEY_ALGORITHM_EC)) {
            KeyPair tempSenderKeyPair = EcTempKeyPairGenerator.generateKeyPair((Certificate)certificate, (String)providerName);
            X509Certificate x509certificate = certificate;
            if (!(x509certificate.getPublicKey() instanceof JCEECPublicKey) && !(x509certificate.getPublicKey() instanceof BCECPublicKey)) {
                x509certificate = (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(new ByteArrayInputStream(x509certificate.getEncoded()));
            }
            ASN1ObjectIdentifier algo = CMSAlgorithm.AES256_GCM;
            JceKeyAgreeRecipientInfoGenerator addRecipient = new JceKeyAgreeRecipientInfoGenerator(CMSAlgorithm.ECDH_SHA256KDF, tempSenderKeyPair.getPrivate(), tempSenderKeyPair.getPublic(), mapEcWrapAlgorithm.get(algo));
            addRecipient.setProvider("BC");
            addRecipient.addRecipient(x509certificate);
            certificates.add((RecipientInfoGenerator)addRecipient);
        } else {
            certificates.add((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(certificate));
        }
    }

    public static void passwordEncryption(String password, File sourceFile, File encryptFile) throws Exception {
        try (ZipFile zipFile = new ZipFile(encryptFile);){
            ArrayList<File> filesToAdd = new ArrayList<File>();
            filesToAdd.add(sourceFile);
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(CompressionMethod.DEFLATE);
            parameters.setCompressionLevel(CompressionLevel.NORMAL);
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(EncryptionMethod.AES);
            parameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
            zipFile.setPassword(password.toCharArray());
            zipFile.addFiles(filesToAdd, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void certificateEncryption(List<X509Certificate> certificateList, File sourceFile, File encryptFile, String providerName) throws Exception {
        SecureRandom secureRandom = SecureRandom.getInstanceStrong();
        ArrayList<RecipientInfoGenerator> recipientList = new ArrayList<RecipientInfoGenerator>();
        for (X509Certificate x509Certificate : certificateList) {
            EncryptFunction.addCertificate(recipientList, x509Certificate, providerName);
        }
        FileOutputStream outputStream = null;
        try (FileInputStream inputStream = new FileInputStream(sourceFile);){
            outputStream = new FileOutputStream(encryptFile);
            LOG.info("Algo: {}", (Object)defaultAlgo);
            JceCMSContentEncryptorBuilder encryptorBuilder = new JceCMSContentEncryptorBuilder(defaultAlgo);
            encryptorBuilder.setSecureRandom(secureRandom);
            encryptorBuilder.setProvider(providerName);
            OutputEncryptor encryptor = encryptorBuilder.build();
            CMSEnvelopedDataStreamGenerator cmsGen = new CMSEnvelopedDataStreamGenerator();
            for (RecipientInfoGenerator cert : recipientList) {
                cmsGen.addRecipientInfoGenerator(cert);
            }
            try (OutputStream outputStream2 = cmsGen.open((OutputStream)outputStream, encryptor);){
                byte[] buffer = new byte[8192];
                int readBytes = 0;
                while ((readBytes = ((InputStream)inputStream).read(buffer)) > 0) {
                    outputStream2.write(buffer, 0, readBytes);
                }
            }
        }
        catch (Throwable throwable) {
            Utils.closeStream(outputStream);
            throw throwable;
        }
        Utils.closeStream((Closeable)outputStream);
    }

    static {
        HashMap<ASN1ObjectIdentifier, ASN1ObjectIdentifier> tmp = new HashMap<ASN1ObjectIdentifier, ASN1ObjectIdentifier>();
        tmp.put(CMSAlgorithm.DES_EDE3_CBC, CMSAlgorithm.DES_EDE3_WRAP);
        tmp.put(CMSAlgorithm.AES128_CBC, CMSAlgorithm.AES128_WRAP);
        tmp.put(CMSAlgorithm.AES192_CBC, CMSAlgorithm.AES192_WRAP);
        tmp.put(CMSAlgorithm.AES256_CBC, CMSAlgorithm.AES256_WRAP);
        tmp.put(CMSAlgorithm.AES128_GCM, CMSAlgorithm.AES128_WRAP);
        tmp.put(CMSAlgorithm.AES192_GCM, CMSAlgorithm.AES192_WRAP);
        tmp.put(CMSAlgorithm.AES256_GCM, CMSAlgorithm.AES256_WRAP);
        mapEcWrapAlgorithm = Collections.unmodifiableMap(tmp);
    }
}

