/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.encrypt;

import de.bos_bremen.gov2.jca_provider.eccipher.EcTempKeyPairGenerator;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.PasswordRecipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyAgreeRecipientInfoGenerator;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.util.encoders.Hex;

public class CCC {
    private static final Logger LOG = LogManager.getLogger(CCC.class);
    private static final Level LOG_LEVEL = Level.INFO;
    private static final Handler LOG_HANDLER = new ConsoleHandler();
    private static final Map<ASN1ObjectIdentifier, ASN1ObjectIdentifier> mapEcWrapAlgorithm;
    private static final Map BASE_CIPHER_NAMES;
    private static final Map CIPHER_ALG_NAMES;
    private static final Map MAC_ALG_NAMES;
    private static final Map PBKDF2_ALG_NAMES;

    private CCC() {
        throw new IllegalStateException("Utility class");
    }

    private static OutputEncryptor createEncryptor(final ASN1ObjectIdentifier encryptionOID, boolean staticKeys, final SecureRandom secureRandom) throws Exception {
        JceCMSContentEncryptorBuilder encryptorBuilder = new JceCMSContentEncryptorBuilder(encryptionOID);
        if (secureRandom != null) {
            encryptorBuilder.setSecureRandom(secureRandom);
        }
        OutputEncryptor encryptor = encryptorBuilder.build();
        if (staticKeys) {
            SecretKeySpec tmpKey;
            final AlgorithmIdentifier algorithmIdentifier = encryptor.getKey().getAlgorithmIdentifier();
            final SecretKeySpec encKey = tmpKey = new SecretKeySpec(Hex.decode((String)"248d434999b995d868eb661508c83a3d"), "AES");
            return new OutputEncryptor(){

                public OutputStream getOutputStream(OutputStream dOut) {
                    Cipher cipher = null;
                    try {
                        AlgorithmParameters params = null;
                        cipher = Cipher.getInstance((String)CIPHER_ALG_NAMES.get(encryptionOID));
                        params = CCC.generateParameters(encryptionOID, encKey, secureRandom, "BC");
                        try {
                            cipher.init(1, (Key)encKey, params, secureRandom);
                        }
                        catch (GeneralSecurityException e) {
                            throw new CMSException("unable to initialize cipher: " + e.getMessage(), (Exception)e);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return new CipherOutputStream(dOut, cipher);
                }

                public GenericKey getKey() {
                    return new GenericKey(algorithmIdentifier, encKey.getEncoded());
                }

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return algorithmIdentifier;
                }
            };
        }
        return encryptor;
    }

    private static KeyPair createTempKeyPair(X509Certificate x509certificate, boolean staticKeys) throws Exception {
        KeyPair tempSenderKeyPair = EcTempKeyPairGenerator.generateKeyPair((Certificate)x509certificate, (String)"BC");
        if (staticKeys) {
            BCECPublicKey pubKey = new BCECPublicKey("EC", (ECPublicKeyParameters)PublicKeyFactory.createKey((byte[])Hex.decode((String)"308201333081ec06072a8648ce3d02013081e0020101302c06072a8648ce3d0101022100a9fb57dba1eea9bc3e660a909d838d726e3bf623d52620282013481d1f6e537730440420a9fb57dba1eea9bc3e660a909d838d726e3bf623d52620282013481d1f6e53740420662c61c430d84ea4fe66a7733d0b76b7bf93ebc4af2f49256ae58101fee92b04044104a3e8eb3cc1cfe7b7732213b23a656149afa142c47aafbc2b79a191562e1305f42d996c823439c56d7f7b22e14644417e69bcb6de39d027001dabe8f35b25c9be022100a9fb57dba1eea9bc3e660a909d838d718c397aa3b561a6f7901e0e82974856a7020101034200048fbb59ecc3b4eede8c1bc871f5dea12300eba1757960763c1c77bb485e77849343cef361f77d7646a9eb7264d0a4ecab1842425e75f6df2e9929ac9819cb9b9c")), ((ECPublicKey)tempSenderKeyPair.getPublic()).getParameters(), BouncyCastleProvider.CONFIGURATION);
            BCECPrivateKey prvKey = new BCECPrivateKey("EC", (ECPrivateKeyParameters)PrivateKeyFactory.createKey((byte[])Hex.decode((String)"3082024b0201003081ec06072a8648ce3d02013081e0020101302c06072a8648ce3d0101022100a9fb57dba1eea9bc3e660a909d838d726e3bf623d52620282013481d1f6e537730440420a9fb57dba1eea9bc3e660a909d838d726e3bf623d52620282013481d1f6e53740420662c61c430d84ea4fe66a7733d0b76b7bf93ebc4af2f49256ae58101fee92b04044104a3e8eb3cc1cfe7b7732213b23a656149afa142c47aafbc2b79a191562e1305f42d996c823439c56d7f7b22e14644417e69bcb6de39d027001dabe8f35b25c9be022100a9fb57dba1eea9bc3e660a909d838d718c397aa3b561a6f7901e0e82974856a70201010482015530820151020101042071b56ed20dd8b3d5049612bf89b837cb4c0cbeac4dcd3c3428cdd6ed7878cc70a081e33081e0020101302c06072a8648ce3d0101022100a9fb57dba1eea9bc3e660a909d838d726e3bf623d52620282013481d1f6e537730440420a9fb57dba1eea9bc3e660a909d838d726e3bf623d52620282013481d1f6e53740420662c61c430d84ea4fe66a7733d0b76b7bf93ebc4af2f49256ae58101fee92b04044104a3e8eb3cc1cfe7b7732213b23a656149afa142c47aafbc2b79a191562e1305f42d996c823439c56d7f7b22e14644417e69bcb6de39d027001dabe8f35b25c9be022100a9fb57dba1eea9bc3e660a909d838d718c397aa3b561a6f7901e0e82974856a7020101a144034200048fbb59ecc3b4eede8c1bc871f5dea12300eba1757960763c1c77bb485e77849343cef361f77d7646a9eb7264d0a4ecab1842425e75f6df2e9929ac9819cb9b9c")), pubKey, ((ECPrivateKey)tempSenderKeyPair.getPrivate()).getParameters(), BouncyCastleProvider.CONFIGURATION);
            tempSenderKeyPair = new KeyPair((PublicKey)pubKey, (PrivateKey)prvKey);
        }
        return tempSenderKeyPair;
    }

    static AlgorithmParameters generateParameters(ASN1ObjectIdentifier encryptionOID, SecretKey encKey, SecureRandom rand, String provider) throws CMSException {
        try {
            AlgorithmParameterGenerator pGen = CCC.createAlgorithmParameterGenerator(encryptionOID, provider);
            if (encryptionOID.equals((ASN1Primitive)CMSAlgorithm.RC2_CBC)) {
                byte[] iv = new byte[8];
                rand.nextBytes(iv);
                try {
                    pGen.init(new RC2ParameterSpec(encKey.getEncoded().length * 8, iv), rand);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new CMSException("parameters generation error: " + e, (Exception)e);
                }
            }
            return pGen.generateParameters();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (GeneralSecurityException e) {
            throw new CMSException("exception creating algorithm parameter generator: " + e, (Exception)e);
        }
    }

    static AlgorithmParameterGenerator createAlgorithmParameterGenerator(ASN1ObjectIdentifier algorithm, String provider) throws GeneralSecurityException {
        String algorithmName = (String)BASE_CIPHER_NAMES.get(algorithm);
        if (algorithmName != null) {
            try {
                return CCC.createAlgorithmParameterGenerator(algorithmName, provider);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.debug(e.getMessage());
            }
        }
        return CCC.createAlgorithmParameterGenerator(algorithm.getId(), provider);
    }

    public static AlgorithmParameterGenerator createAlgorithmParameterGenerator(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return AlgorithmParameterGenerator.getInstance(algorithm, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyEncryption(InputStream inputStream, OutputStream outputStream, boolean staticKeys, ASN1ObjectIdentifier algo, ASN1ObjectIdentifier ecKeyAgreementIdentifier, SecureRandom secureRandom, List<X509Certificate> recipientCertificates) throws Exception {
        ArrayList<JceKeyAgreeRecipientInfoGenerator> certificates = new ArrayList<JceKeyAgreeRecipientInfoGenerator>();
        for (X509Certificate tmpRecipientCertificate : recipientCertificates) {
            KeyPair tempSenderKeyPair = CCC.createTempKeyPair(tmpRecipientCertificate, staticKeys);
            JceKeyAgreeRecipientInfoGenerator jceKeyAgreeRecipientInfoGenerator = new JceKeyAgreeRecipientInfoGenerator(ecKeyAgreementIdentifier, tempSenderKeyPair.getPrivate(), tempSenderKeyPair.getPublic(), mapEcWrapAlgorithm.get(algo)).addRecipient(tmpRecipientCertificate);
            jceKeyAgreeRecipientInfoGenerator.setProvider("BC");
            certificates.add(jceKeyAgreeRecipientInfoGenerator);
        }
        OutputEncryptor encryptor = CCC.createEncryptor(algo, staticKeys, secureRandom);
        CMSEnvelopedDataStreamGenerator cmsGen = new CMSEnvelopedDataStreamGenerator();
        for (RecipientInfoGenerator recipientInfoGenerator : certificates) {
            cmsGen.addRecipientInfoGenerator(recipientInfoGenerator);
        }
        try (OutputStream out = cmsGen.open(outputStream, encryptor);){
            byte[] byArray = new byte[4096];
            int readBytes = 0;
            while ((readBytes = inputStream.read(byArray)) > 0) {
                out.write(byArray, 0, readBytes);
            }
        }
        finally {
            inputStream.close();
        }
    }

    static {
        LOG_HANDLER.setLevel(LOG_LEVEL);
        HashMap<ASN1ObjectIdentifier, ASN1ObjectIdentifier> tmp = new HashMap<ASN1ObjectIdentifier, ASN1ObjectIdentifier>();
        tmp.put(CMSAlgorithm.DES_EDE3_CBC, CMSAlgorithm.DES_EDE3_WRAP);
        tmp.put(CMSAlgorithm.AES128_CBC, CMSAlgorithm.AES128_WRAP);
        tmp.put(CMSAlgorithm.AES192_CBC, CMSAlgorithm.AES192_WRAP);
        tmp.put(CMSAlgorithm.AES256_CBC, CMSAlgorithm.AES256_WRAP);
        tmp.put(CMSAlgorithm.AES128_GCM, CMSAlgorithm.AES128_WRAP);
        tmp.put(CMSAlgorithm.AES192_GCM, CMSAlgorithm.AES192_WRAP);
        tmp.put(CMSAlgorithm.AES256_GCM, CMSAlgorithm.AES256_WRAP);
        mapEcWrapAlgorithm = Collections.unmodifiableMap(tmp);
        BASE_CIPHER_NAMES = new HashMap();
        CIPHER_ALG_NAMES = new HashMap();
        MAC_ALG_NAMES = new HashMap();
        PBKDF2_ALG_NAMES = new HashMap();
        BASE_CIPHER_NAMES.put(CMSAlgorithm.DES_CBC, "DES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.DES_EDE3_CBC, "DESEDE");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES128_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES192_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES256_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES128_GCM, "AES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES192_GCM, "AES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES256_GCM, "AES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.RC2_CBC, "RC2");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.CAST5_CBC, "CAST5");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.CAMELLIA128_CBC, "Camellia");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.CAMELLIA192_CBC, "Camellia");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.CAMELLIA256_CBC, "Camellia");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.SEED_CBC, "SEED");
        BASE_CIPHER_NAMES.put(PKCSObjectIdentifiers.rc4, "RC4");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.DES_CBC, "DES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.RC2_CBC, "RC2/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.DES_EDE3_CBC, "DESEDE/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.AES128_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.AES192_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.AES256_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.AES128_GCM, "AES/GCM/NoPadding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.AES192_GCM, "AES/GCM/NoPadding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.AES256_GCM, "AES/GCM/NoPadding");
        CIPHER_ALG_NAMES.put(PKCSObjectIdentifiers.rsaEncryption, "RSA/ECB/PKCS1Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.CAST5_CBC, "CAST5/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.CAMELLIA128_CBC, "Camellia/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.CAMELLIA192_CBC, "Camellia/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.CAMELLIA256_CBC, "Camellia/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.SEED_CBC, "SEED/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(PKCSObjectIdentifiers.rc4, "RC4");
        MAC_ALG_NAMES.put(CMSAlgorithm.DES_EDE3_CBC, "DESEDEMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES128_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES192_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES256_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES128_GCM, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES192_GCM, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES256_GCM, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.RC2_CBC, "RC2Mac");
        PBKDF2_ALG_NAMES.put(PasswordRecipient.PRF.HMacSHA1.getAlgorithmID(), "PBKDF2WITHHMACSHA1");
        PBKDF2_ALG_NAMES.put(PasswordRecipient.PRF.HMacSHA224.getAlgorithmID(), "PBKDF2WITHHMACSHA224");
        PBKDF2_ALG_NAMES.put(PasswordRecipient.PRF.HMacSHA256.getAlgorithmID(), "PBKDF2WITHHMACSHA256");
        PBKDF2_ALG_NAMES.put(PasswordRecipient.PRF.HMacSHA384.getAlgorithmID(), "PBKDF2WITHHMACSHA384");
        PBKDF2_ALG_NAMES.put(PasswordRecipient.PRF.HMacSHA512.getAlgorithmID(), "PBKDF2WITHHMACSHA512");
    }
}

