/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater;

import de.governikus.updater.ArchType;
import de.governikus.updater.ArtefactType;
import de.governikus.updater.ConfigurationType;
import de.governikus.updater.Increasable;
import de.governikus.updater.InstallationType;
import de.governikus.updater.Logger;
import de.governikus.updater.OSType;
import de.governikus.updater.ProjectType;
import de.governikus.updater.SoftwareType;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.security.CodeSigner;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Utils {
    private static Map<String, X509Certificate> trustedCertificates = new HashMap<String, X509Certificate>();
    private static FileLock lock = null;
    private static FileOutputStream fos;

    public static synchronized void lock(File lockFile) throws IOException {
        if (lock != null) {
            return;
        }
        File parentFolder = lockFile.getParentFile();
        if (!parentFolder.exists() && !parentFolder.mkdirs()) {
            Logger.info("cant create dir: " + lockFile.getParentFile().getAbsolutePath());
            return;
        }
        fos = new FileOutputStream(lockFile);
        FileChannel fc = fos.getChannel();
        lock = fc.tryLock();
    }

    public static synchronized boolean isLocked(File lockFile) {
        if (!lockFile.exists()) {
            return false;
        }
        try {
            Files.delete(lockFile.toPath());
        }
        catch (IOException ex) {
            Logger.info("could not delete file: " + lockFile);
        }
        return lockFile.exists();
    }

    public static synchronized void unlock(File lockFile) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (IOException ex) {
                Logger.info("LockFile \"" + lockFile.getAbsolutePath() + "\" can not unlock!");
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                        try {
                            Files.delete(lockFile.toPath());
                        }
                        catch (IOException ex) {
                            Logger.info("could not delete file: " + lockFile);
                        }
                    }
                    catch (IOException ex) {
                        Logger.info(ex);
                    }
                }
                lockFile = null;
                lock = null;
            }
        }
    }

    public static boolean copyFile(File sourceFile, File targetFile, boolean ignoreExists) throws IOException {
        return Utils.copyFile(sourceFile.getAbsoluteFile().toURI().toString(), targetFile, ignoreExists, null, null);
    }

    public static boolean copyFile(String sourceFileURI, File targetFile, boolean ignoreExists, MessageDigest digest, Increasable progress) throws IOException {
        InputStream fis;
        if (sourceFileURI == null || targetFile == null) {
            return false;
        }
        if (!ignoreExists && targetFile.exists()) {
            return false;
        }
        if (digest != null) {
            digest.reset();
        }
        try {
            URLConnection connection = new URI(sourceFileURI).toURL().openConnection();
            connection.setRequestProperty("pragma", "no-cache");
            connection.setRequestProperty("Cache-Control", "no-store");
            fis = connection.getInputStream();
        }
        catch (URISyntaxException e) {
            return false;
        }
        try {
            boolean bl;
            try (FileOutputStream fos = new FileOutputStream(targetFile);){
                byte[] buffer = new byte[1024];
                int readBytes = fis.read(buffer);
                while (readBytes != -1) {
                    ((OutputStream)fos).write(buffer, 0, readBytes);
                    if (progress != null) {
                        progress.increase(readBytes);
                    }
                    if (digest != null) {
                        digest.update(buffer, 0, readBytes);
                    }
                    readBytes = fis.read(buffer);
                }
                bl = true;
            }
            return bl;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean streamToFile(InputStream in, File file, boolean closeInput) throws IOException {
        if (in == null) {
            return false;
        }
        File parentFolder = file.getParentFile();
        if (!parentFolder.exists() && !parentFolder.mkdirs()) {
            return false;
        }
        FileOutputStream fos = new FileOutputStream(file);
        try {
            byte[] buffer = new byte[8192];
            int readBytes = in.read(buffer);
            while (readBytes != -1) {
                fos.write(buffer, 0, readBytes);
                readBytes = in.read(buffer);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception ex) {
                Logger.debug(ex);
            }
            if (closeInput) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.debug(ex);
                }
            }
        }
    }

    public static void delete(File file) {
        Utils.delete(file, true);
    }

    public static void delete(File file, boolean deleteOnExit) {
        block5: {
            File[] files;
            if (!file.exists()) {
                return;
            }
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                for (File f : files) {
                    Utils.delete(f, deleteOnExit);
                }
            }
            try {
                Files.delete(file.toPath());
            }
            catch (IOException ex) {
                if (!deleteOnExit) break block5;
                file.deleteOnExit();
            }
        }
    }

    public static void copy(File source, File target) throws IOException {
        Utils.copy(source, target, true);
    }

    public static void copy(File source, File target, boolean ignoreExists) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (source.isDirectory()) {
            target.mkdirs();
            File[] files = source.listFiles();
            if (files != null) {
                for (File file : files) {
                    Utils.copy(file, new File(target, file.getName()), ignoreExists);
                }
            }
            return;
        }
        if (!source.isFile()) {
            return;
        }
        Utils.copyFile(source, target, ignoreExists);
    }

    public static byte[] digest(File file, String algo) throws IOException, GeneralSecurityException {
        return Utils.digest(new FileInputStream(file), algo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] digest(InputStream is, String algo) throws IOException, GeneralSecurityException {
        MessageDigest md = MessageDigest.getInstance(algo);
        try {
            byte[] buf = new byte[8192];
            int read = is.read(buf);
            while (read > -1) {
                md.update(buf, 0, read);
                read = is.read(buf);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String join(Collection<String> list2, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (String s : list2) {
            sb.append(s);
            sb.append(delimiter);
        }
        sb.replace(sb.length() - delimiter.length(), sb.length(), "");
        return sb.toString();
    }

    protected static void addCertificate(X509Certificate cert) {
        if (cert == null) {
            return;
        }
        String alias = cert.getIssuerDN().getName() + cert.getSerialNumber();
        trustedCertificates.put(alias, cert);
    }

    private static Map<String, X509Certificate> getAllowedSignerCertificates() {
        return trustedCertificates;
    }

    public static void verifyJar(File file) {
        if (Logger.DEBUG) {
            Logger.debug("verify jar: " + file.getName());
        }
        try (JarFile jar = new JarFile(file);){
            InputStream is = jar.getInputStream(jar.getEntry("META-INF/MANIFEST.MF"));
            Manifest man = new Manifest(is);
            is.close();
            HashSet<String> signed = new HashSet<String>();
            for (Map.Entry<String, Attributes> entry : man.getEntries().entrySet()) {
                for (Object object : entry.getValue().keySet()) {
                    Attributes.Name name;
                    if (!(object instanceof Attributes.Name) || (name = (Attributes.Name)object).toString().indexOf("-Digest") == -1 || entry.getKey().endsWith("/")) continue;
                    signed.add(entry.getKey());
                }
            }
            HashSet<String> entries = new HashSet<String>();
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry je = enumeration.nextElement();
                if (je.isDirectory() || je.getName().startsWith("META-INF/MANIFEST.MF") || je.getName().startsWith("META-INF/") && (je.getName().endsWith(".SF") || je.getName().endsWith(".DSA") || je.getName().endsWith(".RSA"))) continue;
                try {
                    byte[] byArray = new byte[(int)je.getSize()];
                    try (DataInputStream dis = new DataInputStream(jar.getInputStream(je));){
                        dis.readFully(byArray);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                entries.add(je.getName());
            }
            HashMap<CallSite, X509Certificate> hashMap = new HashMap<CallSite, X509Certificate>();
            for (Map.Entry entry : man.getEntries().entrySet()) {
                for (Object attrkey : ((Attributes)entry.getValue()).keySet()) {
                    Attributes.Name name;
                    if (!(attrkey instanceof Attributes.Name) || (name = (Attributes.Name)attrkey).toString().indexOf("-Digest") == -1) continue;
                    JarEntry jarEntry = jar.getJarEntry((String)entry.getKey());
                    if (jarEntry == null) {
                        throw new IOException("entries missing (" + (String)entry.getKey() + ")");
                    }
                    CodeSigner[] codeSigners = jarEntry.getCodeSigners();
                    if (codeSigners != null) {
                        for (CodeSigner codeSigner : codeSigners) {
                            CertPath signerCertPath = codeSigner.getSignerCertPath();
                            List<? extends Certificate> certificates = signerCertPath.getCertificates();
                            X509Certificate c = (X509Certificate)certificates.get(0);
                            hashMap.put((CallSite)((Object)(c.getIssuerDN().getName() + c.getSerialNumber())), c);
                        }
                        continue;
                    }
                    System.out.println(jarEntry.getName());
                }
            }
            HashSet unsigned = new HashSet(entries);
            unsigned.removeAll(signed);
            HashSet hashSet = new HashSet(signed);
            hashSet.removeAll(entries);
            System.out.println(hashSet);
            System.out.println(unsigned);
            Map<String, X509Certificate> allowedSignerCertificates = Utils.getAllowedSignerCertificates();
            boolean allowed = false;
            for (String string : hashMap.keySet()) {
                X509Certificate trustedCert;
                X509Certificate foundCert = (X509Certificate)hashMap.get(string);
                if (allowedSignerCertificates.containsKey(string) && foundCert.equals(trustedCert = allowedSignerCertificates.get(string))) {
                    allowed = true;
                    break;
                }
                try {
                    foundCert.verify(Utils.getPublicKey());
                    allowed = true;
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (!allowed) {
                if (Logger.DEBUG) {
                    Logger.debug("  no allowed signer found: ");
                    for (Map.Entry entry : hashMap.entrySet()) {
                        Logger.debug("    " + entry.getValue());
                    }
                }
                throw new IOException("unknown code signers");
            }
            if (!unsigned.isEmpty()) {
                if (Logger.DEBUG) {
                    Logger.debug("  unsigned entries: ");
                    for (String string : unsigned) {
                        Logger.debug("    " + string);
                    }
                }
                throw new IOException("unsigned entries");
            }
            if (!hashSet.isEmpty()) {
                if (Logger.DEBUG) {
                    Logger.debug("  entries missing: ");
                    for (String string : hashSet) {
                        Logger.debug("    " + string);
                    }
                }
                throw new IOException("entries missing");
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static PublicKey getPublicKeyVersion1() {
        String str = "MIIBtzCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYQAAoGAYq6sYhu3h/lgzSXOv7r+EUYj6OmejlebIsWyOhJ9i/L+a5+7bnVs2dUwBC+8B2VNSbaPICbnA1aT7q0tE7PrWDs25UDPlkNE9e5UeLKSWsi/j+SZC6ERxg/8JHU/zuhxG/tIw8VE6kx67CPwraPIR4DxVffUdnr1/Mt5LY8lg7s=";
        byte[] asBytes = Base64.getDecoder().decode(str);
        try {
            return KeyFactory.getInstance("DSA").generatePublic(new X509EncodedKeySpec(asBytes));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            return null;
        }
    }

    private static PublicKey getPublicKey() {
        String str = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAlHLQqS/O9Ik9tpeAF4Sf3EXxnUQk11pcyMnyTX+f5uJWp0guantJS8YYOg89WJhA9Ie8G8GXVUjERLHQz0f2N6F5rhiCZozRuihIhIXiicMUofkYQrtErNs6fPh8j7XnW/vFURbGxYFdCJ7lCQidwTzHAfKPMMCRquxSObCss0Lkxgh2ST4d11gDcJWNqyhqdsCvAcEGSM1aRkoYuxCb/uhSaFbijOLa94qV0mGQwKkdqrPY4xqE810NgVffr3INpJiVnFxq6ivPKUFLAtX9xgWaYTeK52O1PizCv8coji33GBvV3IWgLAxZuSG4Jkn9NJrl7Xe3SzgLqPX8LYn1yQIDAQAB";
        byte[] asBytes = Base64.getDecoder().decode(str);
        try {
            return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(asBytes));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            return null;
        }
    }

    static ProjectType readUpdateXML(File xml) throws JAXBException, FileNotFoundException, SAXException, XMLStreamException {
        Schema schema = null;
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] schemaSources = new Source[]{new StreamSource(Utils.class.getResourceAsStream("/xsd/xmldsig-core-schema.xsd")), new StreamSource(Utils.class.getResourceAsStream("/xsd/update.xsd"))};
        schema = sf.newSchema(schemaSources);
        JAXBContext jc = JAXBContext.newInstance((String)"de.governikus.updater");
        Unmarshaller um = jc.createUnmarshaller();
        um.setSchema(schema);
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xsr = xif.createXMLStreamReader(new FileInputStream(xml));
        JAXBElement jaxbElement = (JAXBElement)um.unmarshal(xsr);
        return (ProjectType)jaxbElement.getValue();
    }

    private static DocumentBuilderFactory getDBF() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        return dbf;
    }

    static boolean verifyOldXMLSignature(File xmlFile) {
        return Utils.verifyXMLSignature(xmlFile, Utils.getPublicKeyVersion1());
    }

    static boolean verifyXMLSignature(File xmlFile) {
        return Utils.verifyXMLSignature(xmlFile, Utils.getPublicKey());
    }

    private static boolean verifyXMLSignature(File xmlFile, final PublicKey publicKey) {
        try {
            Document doc = Utils.getDBF().newDocumentBuilder().parse(xmlFile);
            NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl.getLength() != 1) {
                throw new IOException("Number of Signature elements is not 1 (" + nl.getLength() + ")");
            }
            Element signature = (Element)nl.item(0);
            if (!((Element)signature.getFirstChild()).getElementsByTagName("Reference").item(0).getAttributes().getNamedItem("URI").getNodeValue().isEmpty()) {
                throw new IllegalArgumentException("Signature does not refer to document root \"\"");
            }
            DOMValidateContext valContext = new DOMValidateContext(new KeySelector(){

                @Override
                public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
                    return new KeySelectorResult(){

                        @Override
                        public Key getKey() {
                            return publicKey;
                        }
                    };
                }
            }, nl.item(0));
            valContext.setProperty("org.jcp.xml.dsig.secureValidation", Boolean.TRUE);
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            XMLSignature xmlSig = fac.unmarshalXMLSignature(valContext);
            return xmlSig.validate(valContext);
        }
        catch (Exception ex) {
            return false;
        }
    }

    static void applyXMLSignature(File f, KeyStore ks, String alias, char[] priKPassword) throws GeneralSecurityException, IOException, SAXException, ParserConfigurationException, MarshalException, XMLSignatureException, TransformerException {
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        LinkedList<Transform> transforms = new LinkedList<Transform>();
        transforms.add(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        transforms.add(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null));
        Reference ref = fac.newReference("", fac.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null), transforms, null, null);
        SignatureMethod signatureMethod = fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null);
        SignedInfo si = fac.newSignedInfo((CanonicalizationMethod)transforms.get(1), signatureMethod, Collections.singletonList(ref));
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<Object> x509Content = new ArrayList<Object>();
        X509Certificate c = (X509Certificate)ks.getCertificate(alias);
        x509Content.add(c.getSubjectX500Principal().getName());
        x509Content.add(c);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        Document doc = Utils.getDBF().newDocumentBuilder().parse(f);
        PrivateKey priK = (PrivateKey)ks.getKey(alias, priKPassword);
        DOMSignContext dsc = new DOMSignContext(priK, (Node)doc.getDocumentElement());
        XMLSignature signature = fac.newXMLSignature(si, ki);
        signature.sign(dsc);
        try (FileOutputStream os = new FileOutputStream(f);){
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer t = tf.newTransformer();
            t.transform(new DOMSource(doc), new StreamResult(os));
        }
    }

    public static ArchType currentArch() {
        String osName = System.getProperty("os.arch");
        if (osName.contains("86")) {
            return ArchType.B_32;
        }
        if (osName.contains("64")) {
            return ArchType.B_64;
        }
        return null;
    }

    public static ArchType fileNameToArch(String name) {
        name = name.toLowerCase();
        for (ArchType arch : ArchType.values()) {
            if (!name.equalsIgnoreCase(arch.value())) continue;
            return arch;
        }
        return null;
    }

    public static boolean runningInConsole() {
        String sessionName = System.getProperty("SESSIONNAME", null);
        return sessionName != null && "Console".equalsIgnoreCase(sessionName.trim());
    }

    public static String getValidFileName(String filename) {
        filename = filename.replace("u\u0308", "\u00fc").replace("o\u0308", "\u00f6").replace("a\u0308", "\u00e4").replace("U\u0308", "\u00dc").replace("O\u0308", "\u00d6").replace("A\u0308", "\u00c4");
        filename = filename.replace('/', ' ');
        filename = filename.replace(':', ' ');
        filename = filename.replace('*', ' ');
        filename = filename.replace('?', ' ');
        filename = filename.replace('\\', ' ');
        filename = filename.replace('<', ' ');
        filename = filename.replace('>', ' ');
        filename = filename.replace('|', ' ');
        filename = filename.replace('\\', ' ');
        filename = filename.replace('&', ' ');
        filename = filename.replace('\n', ' ');
        return filename.replace('\r', ' ');
    }

    public static OSType currentOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        for (OSType os : OSType.values()) {
            if (!osName.contains(os.name().toLowerCase())) continue;
            Logger.debug("OSType: " + osName);
            return os;
        }
        return null;
    }

    public static OSType fileNameToOS(String name) {
        name = name.toLowerCase();
        for (OSType os : OSType.values()) {
            if (!name.equalsIgnoreCase(os.name())) continue;
            Logger.debug("OS: " + os.name());
            return os;
        }
        return null;
    }

    public boolean equals(ArtefactType obj1, ArtefactType obj2) {
        if (!(obj2 instanceof ArtefactType)) {
            return false;
        }
        if (obj1 == obj2) {
            return true;
        }
        ArtefactType o = obj2;
        if (!obj1.getName().equals(o.getName())) {
            return false;
        }
        boolean sameVersion = false;
        sameVersion = obj1.getVersion() == null ? obj1.getVersion() == null : obj1.getVersion().equals(o.getVersion());
        if (!sameVersion) {
            return false;
        }
        if (!obj1.isNative().equals(o.isNative())) {
            return false;
        }
        return obj1.getOs() == o.getOs() && obj1.getArch() == o.getArch();
    }

    public static boolean isOlderThan(SoftwareType locale, SoftwareType remote) {
        if (remote == null || locale == null || remote.getVersion() == null || locale.getVersion() == null) {
            return false;
        }
        String[] localParts = locale.getVersion().split("\\.");
        String[] remoteParts = remote.getVersion().split("\\.");
        int length = Math.max(localParts.length, remoteParts.length);
        for (int i = 0; i < length; ++i) {
            int remotePart;
            int localPart = i < localParts.length ? Integer.parseInt(localParts[i]) : 0;
            int n = remotePart = i < remoteParts.length ? Integer.parseInt(remoteParts[i]) : 0;
            if (localPart < remotePart) {
                return true;
            }
            if (localPart <= remotePart) continue;
            return false;
        }
        return false;
    }

    public static boolean isOlderThan(ConfigurationType config1, ConfigurationType config2) {
        if (config2 == null || config1 == null || config2.getVersion() == null) {
            return false;
        }
        return !config2.getVersion().equals(config1.getVersion());
    }

    public static boolean isOlderThan(InstallationType install1, InstallationType install2) {
        if (install2 == null || install1 == null || install2.getVersion() == null || install1.getVersion() == null) {
            return false;
        }
        return install2.getVersion().compareTo(install1.getVersion()) > 0;
    }

    public static boolean isOlderThan(ArtefactType a1, ArtefactType a2) {
        return a2.getVersion().compareTo(a1.getVersion()) > 0;
    }

    public static String getLocalPath(ArtefactType artefactType) {
        return Utils.getLocalPath(artefactType, false);
    }

    public static String getLocalPath(ArtefactType artefactType, boolean folder) {
        StringBuilder path = new StringBuilder();
        if (folder) {
            path.append('/');
        }
        if (artefactType.getOs() != null) {
            path.append(artefactType.getOs().value());
            if (!folder) {
                path.append('/');
            }
        }
        if (artefactType.getArch() != null) {
            if (folder) {
                path.append('/');
            }
            path.append(artefactType.getArch().value());
            if (!folder) {
                path.append('/');
            }
        }
        if (!folder) {
            path.append(artefactType.getName());
        }
        return path.toString();
    }

    public static String getID(ArtefactType a) {
        return a.getName() + a.getOs() + a.getArch();
    }

    public static void main(String[] args) {
        Utils.verifyJar(new File("osci-bibliothek_server.jar"));
    }
}

