/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater;

import de.governikus.updater.ArtefactListType;
import de.governikus.updater.ArtefactType;
import de.governikus.updater.CertificateListType;
import de.governikus.updater.ConfigurationType;
import de.governikus.updater.InstallationType;
import de.governikus.updater.Logger;
import de.governikus.updater.ProjectType;
import de.governikus.updater.SoftwareType;
import de.governikus.updater.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class Project {
    private static File tempXMLFile;
    private ProjectType proj;
    private String descriptionFileName;

    private ProjectType readUpdateXML(InputStream xml) throws IOException, GeneralSecurityException, JAXBException, SAXException, XMLStreamException {
        tempXMLFile = File.createTempFile("bosupdater", "backup");
        tempXMLFile.deleteOnExit();
        try {
            Utils.streamToFile(xml, tempXMLFile, true);
        }
        catch (FileNotFoundException e1) {
            return null;
        }
        catch (Exception e1) {
            throw new IOException(e1);
        }
        ProjectType projectType = Utils.readUpdateXML(tempXMLFile);
        if (projectType.getSignature() == null) {
            throw new GeneralSecurityException("update.xml is not signed.");
        }
        if (!Utils.verifyXMLSignature(tempXMLFile) && !Utils.verifyOldXMLSignature(tempXMLFile)) {
            throw new GeneralSecurityException("Signature of update.xml is invalid.");
        }
        CertificateListType certificateList = projectType.getCertificateList();
        if (certificateList != null) {
            List certificate = certificateList.getCertificate();
            for (byte[] bytes : certificate) {
                X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(bytes));
                Utils.addCertificate(cert);
            }
        }
        SoftwareType softwareType = projectType.getSoftware();
        this.adjustFromOSAndArch(softwareType.getArtefacts());
        ConfigurationType configurationType = projectType.getConfiguration();
        this.adjustFromOSAndArch(configurationType.getArtefacts());
        return projectType;
    }

    private void adjustFromOSAndArch(ArtefactListType artefactsType) {
        List artefacts = artefactsType.getArtefact();
        Iterator it = artefacts.iterator();
        while (it.hasNext()) {
            ArtefactType artefactType = (ArtefactType)it.next();
            if (artefactType.getOs() != null && artefactType.getOs() != Utils.currentOS()) {
                it.remove();
                continue;
            }
            if (artefactType.getArch() == null || artefactType.getArch() == Utils.currentArch()) continue;
            it.remove();
        }
    }

    public void load(URI uri) throws IOException, GeneralSecurityException, JAXBException, SAXException, XMLStreamException {
        IOException toBeThrown = null;
        try {
            URLConnection connection = uri.toURL().openConnection();
            connection.setRequestProperty("pragma", "no-cache");
            connection.setRequestProperty("Cache-Control", "no-store");
            this.proj = this.readUpdateXML(connection.getInputStream());
        }
        catch (IOException e) {
            toBeThrown = e;
            this.proj = new ProjectType();
        }
        String s = uri.toString();
        this.descriptionFileName = s.substring(s.lastIndexOf(47) + 1);
        s = s.substring(0, s.lastIndexOf(47) + 1);
        for (ArtefactType artefactType : this.getSoftware().getArtefacts().getArtefact()) {
            artefactType.setFile(s + Utils.getLocalPath(artefactType));
        }
        for (ArtefactType artefactType : this.getConfiguration().getArtefacts().getArtefact()) {
            artefactType.setFile(s + Utils.getLocalPath(artefactType));
        }
        if (toBeThrown != null) {
            throw toBeThrown;
        }
    }

    public void load(File localAppFolder, String descFilename) throws IOException, GeneralSecurityException, JAXBException, SAXException, XMLStreamException {
        File f = new File(localAppFolder, descFilename);
        this.descriptionFileName = descFilename;
        try {
            this.proj = this.readUpdateXML(f.toURI().toURL().openStream());
        }
        catch (IOException | GeneralSecurityException | UnmarshalException e) {
            Logger.info("Error reading update xml, cause: ", e);
            Logger.info("Resetting Project and download whole application again...");
            this.proj = new ProjectType();
        }
    }

    public SoftwareType getSoftware() {
        if (this.proj.getSoftware() == null) {
            this.proj.setSoftware(new SoftwareType());
            this.proj.getSoftware().setArtefacts(new ArtefactListType());
        }
        return this.proj.getSoftware();
    }

    public boolean isSigned() {
        return this.proj.getSignature() != null;
    }

    public void removeSignature() {
        this.proj.setSignature(null);
    }

    public InstallationType getInstallation() {
        if (this.proj.getInstallation() == null) {
            this.proj.setInstallation(new InstallationType());
        }
        return this.proj.getInstallation();
    }

    public ConfigurationType getConfiguration() {
        if (this.proj.getConfiguration() == null) {
            this.proj.setConfiguration(new ConfigurationType());
            this.proj.getConfiguration().setArtefacts(new ArtefactListType());
        }
        return this.proj.getConfiguration();
    }

    public String getName() {
        return this.proj.getName();
    }

    public void setName(String name) {
        this.proj.setName(name);
    }

    public String getURI() {
        return this.descriptionFileName;
    }

    public void setDescriptionFileName(String d) {
        this.descriptionFileName = d;
    }

    public void copyUpdateXMLTo(File f) throws IOException {
        try (FileInputStream is = new FileInputStream(tempXMLFile);
             FileOutputStream fos = new FileOutputStream(f);){
            byte[] buf = new byte[8192];
            int read = ((InputStream)is).read(buf);
            while (read != -1) {
                ((OutputStream)fos).write(buf, 0, read);
                read = ((InputStream)is).read(buf);
            }
        }
    }
}

