/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater;

import de.governikus.updater.SystemPropertyKey;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty(SystemPropertyKey.UPDATER_DEBUG.name, Boolean.FALSE.toString()));
    public static final boolean TOFILE = System.getProperty(SystemPropertyKey.UPDATER_OUTPUT_FILE.name) != null;
    public static final boolean TOCONSOLE = Boolean.parseBoolean(System.getProperty(SystemPropertyKey.UPDATER_OUTPUT_CONSOLE.name, Boolean.TRUE.toString()));
    private static File logFile;
    private static boolean firstWriteInLifeCicle;

    public static void initLogFile(String appName) {
        File folder = new File(System.getProperty(SystemPropertyKey.LOCAL_APP_DATA.name));
        folder = new File(folder, System.getProperty(SystemPropertyKey.MANUFACTURER_NAME.name));
        logFile = new File(folder, appName);
        logFile = new File(logFile, "updater.log");
    }

    public static final void info(String message) {
        Logger.log(Type.INFO, message, null);
    }

    public static final void info(Throwable t) {
        Logger.log(Type.INFO, null, t);
    }

    public static final void info(String message, Throwable t) {
        Logger.log(Type.INFO, message, t);
    }

    public static final void debug(String message) {
        Logger.log(Type.DEBUG, message, null);
    }

    public static final void debug(Throwable t) {
        Logger.log(Type.DEBUG, null, t);
    }

    public static final void debug(String message, Throwable t) {
        Logger.log(Type.DEBUG, message, t);
    }

    public static final void error(String message) {
        Logger.log(Type.ERROR, message, null);
    }

    public static final void error(Throwable throwable) {
        Logger.log(Type.ERROR, null, throwable);
    }

    public static final void error(String message, Throwable throwable) {
        Logger.log(Type.ERROR, message, throwable);
    }

    private static final synchronized void log(Type type, String msg, Throwable throwable) {
        if (type == Type.DEBUG && !DEBUG) {
            return;
        }
        Throwable t = new Throwable();
        StackTraceElement stackTraceElements = null;
        for (StackTraceElement ste : t.getStackTrace()) {
            String className = ste.getClassName();
            if (className.equals(Logger.class.getName())) continue;
            stackTraceElements = ste;
            break;
        }
        if (stackTraceElements == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(new SimpleDateFormat("HH:mm:ss:SSS").format(new Date()));
        sb.append(' ');
        sb.append(type.toString());
        sb.append(' ');
        sb.append(stackTraceElements.getClassName());
        sb.append('.');
        sb.append(stackTraceElements.getMethodName());
        sb.append('(');
        sb.append(stackTraceElements.getFileName());
        sb.append(':');
        if (stackTraceElements.isNativeMethod()) {
            sb.append("native");
        } else if (stackTraceElements.getLineNumber() < 0) {
            sb.append("unknown");
        } else {
            sb.append(stackTraceElements.getLineNumber());
        }
        sb.append(')');
        sb.append(' ');
        sb.append('-');
        sb.append(' ');
        if (msg != null) {
            sb.append(msg);
        }
        if (throwable != null) {
            sb.append('\n');
            sb.append('\t');
            sb.append('\t');
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            pw.flush();
            sb.append(sw.toString());
        }
        String message = sb.toString();
        if (TOFILE) {
            Logger.appendToFile(message);
        }
        if (TOCONSOLE) {
            Logger.appendToConsole(message);
        }
    }

    private static void appendToConsole(String message) {
        System.err.println(message);
    }

    private static void appendToFile(String message) {
        try {
            if (!logFile.exists()) {
                logFile.getParentFile().mkdirs();
            }
            FileWriter w = new FileWriter(logFile, true);
            try {
                if (firstWriteInLifeCicle) {
                    w.append('\n');
                    w.append('\n');
                    w.append("__________________________________________");
                    w.append('\n');
                    w.append("Session started at ");
                    w.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS").format(new Date()));
                    w.append('\n');
                    firstWriteInLifeCicle = false;
                }
                w.append(message);
                w.append('\n');
            }
            finally {
                try {
                    w.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        firstWriteInLifeCicle = true;
    }

    public static enum Type {
        INFO,
        DEBUG,
        ERROR;


        public String toString() {
            if (this == INFO) {
                return this.name() + " ";
            }
            return this.name();
        }
    }

    public static enum Output {
        CONSOLE,
        FILE;

    }
}

