/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater;

import de.governikus.updater.ArtefactListType;
import de.governikus.updater.ArtefactType;
import de.governikus.updater.ConfigurationType;
import de.governikus.updater.InstallationType;
import de.governikus.updater.Logger;
import de.governikus.updater.ObjectFactory;
import de.governikus.updater.ProjectType;
import de.governikus.updater.SoftwareType;
import de.governikus.updater.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.LinkedHashMap;
import javax.swing.BoundedRangeModel;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class DistributingProject {
    private final JAXBContext jc;
    private final ObjectFactory bosCF = new ObjectFactory();
    private ProjectType project;
    private String descriptionFileName;

    public DistributingProject() throws JAXBException {
        Class[] classes = new Class[]{this.bosCF.getClass(), ObjectFactory.class};
        this.jc = JAXBContext.newInstance((Class[])classes);
        this.project = new ProjectType();
    }

    public void load(File descriptionFile) throws IOException, GeneralSecurityException, JAXBException, SAXException, XMLStreamException {
        this.descriptionFileName = null;
        File f = descriptionFile.getAbsoluteFile();
        this.project = this.readUpdateXML(f);
        if (this.project == null) {
            throw new IOException("no App update folder");
        }
        for (ArtefactType artefactType : this.project.getSoftware().getArtefacts().getArtefact()) {
            artefactType.setFile(new File(descriptionFile.getParent(), Utils.getLocalPath(artefactType)).getAbsolutePath());
        }
        for (ArtefactType artefactType : this.project.getConfiguration().getArtefacts().getArtefact()) {
            artefactType.setFile(new File(descriptionFile.getParent(), Utils.getLocalPath(artefactType)).getAbsolutePath());
            artefactType.setConfig(Boolean.TRUE);
        }
        try {
            this.descriptionFileName = f.getName();
        }
        catch (Exception e) {
            throw new IOException("app description file is not valid", e);
        }
    }

    public void deployTo(File deploymentFolder, BoundedRangeModel p, boolean useSignature, KeyStore ks, String alias, char[] priKPassword) throws IOException, GeneralSecurityException, JAXBException {
        File applicationUpdateFolder = deploymentFolder;
        applicationUpdateFolder.mkdirs();
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        for (Object a : this.project.getSoftware().getArtefacts().getArtefact()) {
            if (a.getVersion() == null) {
                a.setVersion(Long.toString(System.currentTimeMillis()));
            }
            if (a.getFile() == null) continue;
            m.put(Utils.getID((ArtefactType)a), a.getFile());
            a.setFile(null);
            if (p == null) continue;
            p.setRangeProperties(p.getValue() + 1, p.getExtent(), p.getMinimum(), p.getMaximum(), false);
        }
        StringBuilder sb = new StringBuilder();
        for (ArtefactType a : this.project.getConfiguration().getArtefacts().getArtefact()) {
            if (a.getVersion() == null) {
                a.setVersion(Long.toString(System.currentTimeMillis()));
            }
            sb.append(a.getVersion());
            if (a.getFile() == null) continue;
            m.put(Utils.getID(a), a.getFile());
            a.setFile(null);
            if (p == null) continue;
            p.setRangeProperties(p.getValue() + 1, p.getExtent(), p.getMinimum(), p.getMaximum(), false);
        }
        String oldConfigVersion = this.project.getConfiguration().getVersion();
        String newConfigVersion = Integer.toString(sb.toString().hashCode());
        if (oldConfigVersion == null || !oldConfigVersion.equals(newConfigVersion)) {
            this.project.getConfiguration().setVersion(newConfigVersion);
        }
        File f = new File(applicationUpdateFolder, this.descriptionFileName);
        Marshaller marshaller = this.jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"utf-8");
        marshaller.marshal((Object)this.bosCF.createProject(this.project), f);
        for (ArtefactType a : this.project.getSoftware().getArtefacts().getArtefact()) {
            a.setFile((String)m.get(Utils.getID(a)));
        }
        for (ArtefactType a : this.project.getConfiguration().getArtefacts().getArtefact()) {
            a.setFile((String)m.get(Utils.getID(a)));
            a.setConfig(Boolean.TRUE);
        }
        if (useSignature) {
            try {
                Utils.applyXMLSignature(f, ks, alias, priKPassword);
            }
            catch (Exception e) {
                Logger.error(e);
            }
            try {
                if (!Utils.verifyXMLSignature(f)) {
                    Logger.error("Signature of update.xml is invalid.");
                }
            }
            catch (Exception e1) {
                Logger.error(e1);
            }
        }
        if (p != null) {
            p.setRangeProperties(p.getValue() + 1, p.getExtent(), p.getMinimum(), p.getMaximum(), false);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("P");
        sb.append('[');
        sb.append(this.project.getName());
        sb.append(']');
        return sb.toString();
    }

    private ProjectType readUpdateXML(File xmlFile) throws IOException, GeneralSecurityException, JAXBException, SAXException, XMLStreamException {
        File tempXMLFile = File.createTempFile("bosupdater", "backup");
        tempXMLFile.deleteOnExit();
        try {
            Utils.streamToFile(new FileInputStream(xmlFile), tempXMLFile, true);
        }
        catch (FileNotFoundException e1) {
            return null;
        }
        ProjectType proj = Utils.readUpdateXML(tempXMLFile);
        if (proj.getSignature() != null) {
            try {
                if (!Utils.verifyXMLSignature(tempXMLFile)) {
                    Logger.error("Signature of update.xml is invalid.");
                }
            }
            catch (Exception e) {
                throw new GeneralSecurityException(e);
            }
        }
        return proj;
    }

    public SoftwareType getSoftware() {
        if (this.project.getSoftware() == null) {
            this.project.setSoftware(new SoftwareType());
            this.project.getSoftware().setArtefacts(new ArtefactListType());
        }
        return this.project.getSoftware();
    }

    public InstallationType getInstallation() {
        if (this.project.getInstallation() == null) {
            this.project.setInstallation(new InstallationType());
        }
        return this.project.getInstallation();
    }

    public ConfigurationType getConfiguration() {
        if (this.project.getConfiguration() == null) {
            this.project.setConfiguration(new ConfigurationType());
            this.project.getConfiguration().setArtefacts(new ArtefactListType());
        }
        return this.project.getConfiguration();
    }

    public String getName() {
        return this.project.getName();
    }

    public void setName(String name) {
        this.project.setName(name);
    }

    public String getDescriptionFileName() {
        return this.descriptionFileName;
    }

    public void setDescriptionFileName(String d) {
        this.descriptionFileName = d;
    }

    public boolean isSigned() {
        return this.project.getSignature() != null;
    }

    public void removeSignature() {
        this.project.setSignature(null);
    }

    public ProjectType getProjectType() {
        return this.project;
    }
}

